function handleFormSubmit(event) {
        event.preventDefault(); // Prevent the default form submission
    
        const form = event.target;
        const submitButton = form.querySelector('.submitButton');
        const submitButtonValue = submitButton.textContent;
    
        // Disable the submit button to prevent multiple submissions
        submitButton.disabled = true;
        submitButton.innerHTML = '<span class="spinner-border spinner-border-sm"></span> ' + submitButtonValue;
    
        // Get the form data
        const formData = new FormData(form);
    
        // CSRF Token
        const csrfTokenElement = form.querySelector('input[name="csrf_appdl"]');
        if (!csrfTokenElement || !csrfTokenElement.value) {
            Swal.fire({
                icon: 'warning',
                html: 'CSRF token is missing or invalid. Please refresh the page and try again.',
                showCloseButton: true,
                showConfirmButton: false,
            });
            submitButton.disabled = false;
            submitButton.textContent = submitButtonValue;
            return;
        }
        const csrfToken = csrfTokenElement.value;
    
        // Get the action URL from the form's data-action attribute
        const actionUrl = form.getAttribute('data-action');

        // Handle different form types differently
        const dataFormType = form.getAttribute('data-form-type');
    
        // Check for reCAPTCHA v2 or v3
        const recaptchaType = form.getAttribute('data-recaptcha-type');
        const recaptchaKey = form.getAttribute('data-recaptcha-key');
    
        if (recaptchaType && recaptchaKey) {
            if (recaptchaType === '2') {
                // Handle reCAPTCHA v2
                if (typeof grecaptcha === 'undefined') {
                    handleRecaptchaError('reCAPTCHA failed to load. Please refresh the page and try again.');
                    return;
                }
    
                const recaptchaResponse = grecaptcha.getResponse();
                if (!recaptchaResponse) {
                    handleRecaptchaError('Please complete the reCAPTCHA to proceed.');
                    return;
                }
    
                formData.append('g-recaptcha-type', recaptchaType);
                formData.append('g-recaptcha-response', recaptchaResponse);
                submitForm(actionUrl, dataFormType, csrfToken, formData, form, submitButton, submitButtonValue);
    
            } else if (recaptchaType === '3') {
                grecaptcha.ready(() => {
                    grecaptcha.execute(recaptchaKey, { action: 'submit' }).then((token) => {
                        if (!token) {
                            handleRecaptchaError('reCAPTCHA failed to generate a token. Please try again.');
                            return;
                        }
    
                        formData.append('g-recaptcha-type', recaptchaType);
                        formData.append('g-recaptcha-response', token);
                        submitForm(actionUrl, dataFormType, csrfToken, formData, form, submitButton, submitButtonValue);
                    }).catch(() => {
                        handleRecaptchaError('reCAPTCHA execution failed. Please try again.');
                    });
                });
            }
        } else {
            // No reCAPTCHA, submit the form directly
            submitForm(actionUrl, dataFormType, csrfToken, formData, form, submitButton, submitButtonValue);
        }
    
        function handleRecaptchaError(message) {
            toastr.options = {
                "progressBar": true,
                "positionClass": "toast-top-center",
            };
            toastr['error'](message, "Error");

            submitButton.disabled = false;
            submitButton.textContent = submitButtonValue;
        }
    }
    
//==============================================================================================//
function submitForm(actionUrl, dataFormType, csrfToken, formData, form, submitButton, submitButtonValue) {
        // Send the form data to the server using Fetch API
        fetch(actionUrl, {
                method: 'POST',
                headers: {
                'X-CSRF-Token': csrfToken,
                'X-Requested-With': 'XMLHttpRequest'
                },
                body: formData // Send FormData directly, without specifying headers
        })
        .then(response => response.json())
        .then(data => {
                if (data.errors) {
                        // Display validation errors
                        const errorList = Object.values(data.errors).map(error => `<li>${error}</li>`).join('');
                        const errorHtml = `<ul>${errorList}</ul>`;
                        if(data.messageType == "toastr") {
                                toastr.options = {
                                "progressBar": true,
                                "positionClass": "toast-top-center",
                                };
                                toastr[data.messageIcon](errorHtml, data.messageTitle);

                        } else if (data.messageType == "sweetalert") {
                                Swal.fire({
                                icon: data.messageIcon,
                                title: data.messageTitle,
                                html: errorHtml,
                                showCloseButton: true,
                                showConfirmButton: false,
                                });
                        }
                
                        resetRecaptchaWidget();

                } else if (data.redirectUrl) {
                        if(data.messageType == "toastr") {
                                toastr.options = {
                                        "progressBar": true,
                                        "positionClass": "toast-top-center",
                                };
                                toastr[data.messageIcon](data.messageBody, data.messageTitle);
                        }
                        
                        // Redirect to the specified URL if provided
                        const delay = data.redirectTimer || 0;
                        setTimeout(() => {
                        window.location.href = data.redirectUrl;
                        }, delay); // 3000 milliseconds = 3 seconds

                } else if (data.messageBody) {
                        const isWarning = data.messageBody.includes("The action you requested is not allowed.");
                        if(data.messageType == "toastr") {
                                toastr.options = {
                                "progressBar": true,
                                "positionClass": "toast-top-center",
                                };
                                toastr[data.messageIcon](data.messageBody, data.messageTitle);
                        } else if (data.messageType == "sweetalert") {
                                Swal.fire({
                                icon: isWarning ? "warning" : data.messageIcon,
                                title: data.messageTitle,
                                html: data.messageBody,
                                showCloseButton: true,
                                showConfirmButton: false,
                                });
                        }

                        if (!isWarning) {
                                // Clear the form after successful submission if not a warning
                                resetFormByDataType(dataFormType);
                                resetRecaptchaWidget();
                        }
                

                        // Handle updateData form inputs with the response data if perform edit
                        if (data.updatedData) {
                                for (const [key, value] of Object.entries(data.updatedData)) {
                                        const input = form.querySelector(`[name="${key}"]`);
                                        if (input) {
                                                switch (input.type) {
                                                case 'checkbox':
                                                        input.checked = value;
                                                        break;
                                                case 'radio':
                                                        const radioButtons = form.querySelectorAll(`[name="${key}"]`);
                                                        radioButtons.forEach(radio => {
                                                        radio.checked = (radio.value === value);
                                                        });
                                                        break;
                                                case 'file':
                                                        console.warn(`Cannot set value for file input: ${key}`);
                                                        break;
                                                case 'select-one':
                                                case 'select-multiple':
                                                        for (const option of input.options) {
                                                        option.selected = value.includes(option.value);
                                                        }
                                                        break;
                                                case 'textarea':
                                                        input.value = value;
                                                        break;
                                                default:
                                                        input.value = value;
                                                        break;
                                                }
                                        }
                                }
                        }
                        // End handle updateData

                        // Handle newData
                        if (data.newData) {
                                let resultObject = {};
                                for (const [key, value] of Object.entries(data.newData)) {
                                        resultObject[key] = value;
                                }
                                
                                // Call displayData directly
                                function displayData(resultObject) {
                                        const container = document.getElementById('newDataContainer');
                                
                                        if (!container) {
                                                // If the container doesn't exist, exit the function
                                                return;
                                        }
                        
                                        let htmlContent = container.innerHTML;
                        
                                        for (const [key, value] of Object.entries(resultObject)) {
                                                const regex = new RegExp(`{{${key}}}`, 'g');
                                                htmlContent = htmlContent.replace(regex, value);
                                        }
                        
                                        container.innerHTML = htmlContent;
                                        container.classList.remove('d-none'); // Remove the d-none class to show the container
                                }

                                displayData(resultObject);
                        }
                        // End handle newData


                } else {
                        // Check if there's an error message in the response
                        const errorMessage = 'Unexpected response from the server. Please try again.';
                        Swal.fire({
                                icon: "error",
                                title: 'Error',
                                html: errorMessage,
                                showCloseButton: true,
                                showConfirmButton: false,
                        });
                }
        })
        .catch(error => {
                Swal.fire({
                icon: "error",
                title: 'Error',
                html: 'An error occurred: ' + error.message,
                showCloseButton: true,
                showConfirmButton: false,
                });
        })
        .finally(() => {
                // Re-enable the submit button
                submitButton.disabled = false;
                submitButton.textContent = submitButtonValue;
        });
}    

//==============================================================================================//        
function resetRecaptchaWidget() {
        // Reset reCAPTCHA v2 or v3 (if present)
        if (typeof grecaptcha !== 'undefined') {
                // Check for reCAPTCHA v2
                if (document.querySelector('.g-recaptcha')) {
                        grecaptcha.reset();
                } else {
                        // Handle reCAPTCHA v3
                        //grecaptcha.execute(); // NO Need
                }
        }
}

//==============================================================================================//        
function resetFormByDataType(dataFormType) {
        const form = document.querySelector(`form[data-form-type="${dataFormType}"]`);
    
        if (form) {
            form.reset(); // Reset the form elements to their default values
    
            // Manually reset any additional fields if necessary
            const elements = form.elements;
    
            for (let i = 0; i < elements.length; i++) {
                const element = elements[i];
                
                // Reset textareas
                if (element.type === 'textarea') {
                    element.value = '';
                }
    
                // Reset checkboxes and radio buttons
                if (element.type === 'checkbox' || element.type === 'radio') {
                    element.checked = false;
                }
    
                // Reset other types of inputs if needed
                // if (element.type === 'something_else') {
                //     element.value = ''; // or another default value
                // }
            }
        }
}

// Attach the form submit handler to all forms with data-form-type
document.querySelectorAll('form[data-form-type]').forEach(form => {
        form.addEventListener('submit', handleFormSubmit);
});
     

//==============================================================================================//    
function handleFormSubmit_OLD_Without_reCAPTCHA(event) {
        event.preventDefault(); // Prevent the default form submission

        const form = event.target;
        const submitButton = form.querySelector('.submitButton');
        const submitButtonValue = submitButton.textContent;
        const responseMessageElement = document.getElementById('responseMessage');

        // Disable the submit button to prevent multiple submissions
        submitButton.disabled = true;
        submitButton.innerHTML = '<span class="spinner-border spinner-border-sm"></span> ' + submitButtonValue;

        // Get the form data
        const formData = new FormData(form);

        // CSRF Token
        const csrfTokenElement = form.querySelector('input[name="csrf_appdl"]');
        if (!csrfTokenElement || !csrfTokenElement.value) {
                Swal.fire({
                icon: 'warning',
                html: 'CSRF token is missing or invalid. Please refresh the page and try again.',
                showCloseButton: true,
                showConfirmButton: false,
                });
                submitButton.disabled = false;
                submitButton.textContent = submitButtonValue;
                return;
        }
        const csrfToken = csrfTokenElement.value;

        // Get the action URL from the form's data-action attribute
        const actionUrl = form.getAttribute('data-action');

        // Optionally, handle different form types differently
        const formType = form.getAttribute('data-form-type');

        // Send the form data to the server using Fetch API
        fetch(actionUrl, {
                method: 'POST',
                headers: {
                         'X-CSRF-Token': csrfToken,
                         'X-Requested-With': 'XMLHttpRequest'
                },
                body: formData // Send FormData directly, without specifying headers
        })
        .then(response => response.json())
        .then(data => {
                if (data.errors) {
                // Display validation errors
                const errorList = Object.values(data.errors).map(error => `<li>${error}</li>`).join('');
                const errorHtml = `<ul>${errorList}</ul>`;
                if(data.messageType == "toastr") {
                        toastr.options = {
                                "progressBar": true,
                                "positionClass": "toast-top-center",
                            }
                            toastr[data.messageIcon](errorHtml, data.messageTitle);

                } else if (data.messageType == "sweetalert") {
                        Swal.fire({
                                icon: data.messageIcon,
                                title: data.messageTitle,
                                html: errorHtml,
                                showCloseButton: true,
                                showConfirmButton: false,
                        });
                }
                

                } else if (data.messageBody) {
                        // Determine icon type based on message content for CSRF Token
                        const isWarning = data.messageBody.includes("The action you requested is not allowed.");

                        if(data.messageType == "toastr") {
                                toastr.options = {
                                        "progressBar": true,
                                        "positionClass": "toast-top-center",
                                }
                                toastr[data.messageIcon](data.messageBody, "<?= lang('Dashboard.error') ?>");

                        } else if (data.messageType == "sweetalert") {
                                Swal.fire({
                                        icon: isWarning ? "warning" : data.messageIcon,
                                        title: data.messageTitle,
                                        html: data.messageBody,
                                        showCloseButton: true,
                                        showConfirmButton: false,
                                });
                        }

                        if (!isWarning) {
                                // Clear the form after successful submission if not a warning
                                form.reset();
                        }
                
                        // Update form inputs with the response data if perform edit...
                        if (data.updatedData) {
                                for (const [key, value] of Object.entries(data.updatedData)) {
                                        const input = form.querySelector(`[name="${key}"]`);
                                        if (input) {
                                                switch (input.type) {
                                                case 'checkbox':
                                                        input.checked = value;
                                                        break;
                                                case 'radio':
                                                        const radioButtons = form.querySelectorAll(`[name="${key}"]`);
                                                        radioButtons.forEach(radio => {
                                                        radio.checked = (radio.value === value);
                                                        });
                                                        break;
                                                case 'file':
                                                        // File inputs cannot be set programmatically for security reasons
                                                        console.warn(`Cannot set value for file input: ${key}`);
                                                        break;
                                                case 'select-one':
                                                case 'select-multiple':
                                                        for (const option of input.options) {
                                                        option.selected = value.includes(option.value);
                                                        }
                                                        break;
                                                case 'textarea':
                                                        input.value = value;
                                                        break;
                                                default:
                                                        input.value = value;
                                                        break;
                                                }
                                        }
                                }
                        }

                } else {
                // Handle unexpected response format
                const errorMessage = 'Unexpected response from the server. Please try again.';
                Swal.fire({
                        icon: 'warning',
                        html: errorMessage,
                        showCloseButton: true,
                        showConfirmButton: false,
                });
                }
        })
        .catch(error => {
                Swal.fire({
                icon: "error",
                html: 'An error occurred: ' + error.message,
                showCloseButton: true,
                showConfirmButton: false,
                });
        })
        .finally(() => {
                // Re-enable the submit button
                submitButton.disabled = false;
                submitButton.textContent = submitButtonValue;
        });
}
// Attach the form submit handler to all forms with data-form-type
/*document.querySelectorAll('form[data-form-type]').forEach(form => {
form.addEventListener('submit', handleFormSubmit);
});*/

//==============================================================================================//
function buttonLoading() {
        const btnValue = document.getElementById("submitButton").value;
        document.getElementById("submitButton").disabled = true;
        document.getElementById("submitButton").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton").style = 'cursor: not-allowed;';
}

function buttonLoading2() {
        const btnValue = document.getElementById("submitButton2").value;
        document.getElementById("submitButton2").disabled = true;
        document.getElementById("submitButton2").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton2").style = 'cursor: not-allowed;';
}

function buttonLoading3() {
        const btnValue = document.getElementById("submitButton3").value;
        document.getElementById("submitButton3").disabled = true;
        document.getElementById("submitButton3").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton3").style = 'cursor: not-allowed;';
}

function buttonLoading4() {
        const btnValue = document.getElementById("submitButton4").value;
        document.getElementById("submitButton4").disabled = true;
        document.getElementById("submitButton4").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton4").style = 'cursor: not-allowed;';
}

function buttonLoading5() {
        const btnValue = document.getElementById("submitButton5").value;
        document.getElementById("submitButton5").disabled = true;
        document.getElementById("submitButton5").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton5").style = 'cursor: not-allowed;';
}

function buttonLoading6() {
        const btnValue = document.getElementById("submitButton6").value;
        document.getElementById("submitButton6").disabled = true;
        document.getElementById("submitButton6").innerHTML = '<span class="spinner-border spinner-border-sm"></span> '+btnValue;
        document.getElementById("submitButton6").style = 'cursor: not-allowed;';
}

$(function () {
        // Summernote: https://summernote.org/deep-dive/
        $('#summernote').summernote({
                height: 300,
                placeholder: '',
                codeviewFilter: false,
                codeviewIframeFilter: true,
                spellCheck: true,
                fontSizeUnit: 'pt',
                toolbar: [
                        ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['fontsize', ['fontsize', 'fontname', 'height']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert',['ltr','rtl']],
                        ['insert', ['link','picture', 'video', 'hr']],
                        ['table', ['table']],
                        ['view', ['codeview', 'undo', 'redo', 'help', 'fullscreen']]
                ]
        })
        $('#summernote2').summernote({
                height: 300,
                placeholder: '',
                codeviewFilter: false,
                codeviewIframeFilter: true,
                spellCheck: true,
                fontSizeUnit: 'pt',
                toolbar: [
                        ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['fontsize', ['fontsize', 'fontname', 'height']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert',['ltr','rtl']],
                        ['insert', ['link','picture', 'video', 'hr']],
                        ['table', ['table']],
                        ['view', ['codeview', 'undo', 'redo', 'help', 'fullscreen']]
                ]
        })
        $('#summernote3').summernote({
                height: 300,
                placeholder: '',
                codeviewFilter: false,
                codeviewIframeFilter: true,
                spellCheck: true,
                fontSizeUnit: 'pt',
                toolbar: [
                        ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['fontsize', ['fontsize', 'fontname', 'height']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert',['ltr','rtl']],
                        ['insert', ['link','picture', 'video', 'hr']],
                        ['table', ['table']],
                        ['view', ['codeview', 'undo', 'redo', 'help', 'fullscreen']]
                ]
        })
        $('#summernotebig').summernote({
                height: 400,
                placeholder: '',
                codeviewFilter: false,
                codeviewIframeFilter: true,
                spellCheck: true,
                fontSizeUnit: 'pt',
                toolbar: [
                        ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['fontsize', ['fontsize', 'fontname', 'height']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert',['ltr','rtl']],
                        ['insert', ['link','picture', 'video', 'hr']],
                        ['table', ['table']],
                        ['view', ['codeview', 'undo', 'redo', 'help', 'fullscreen']]
                ]
        })
        // CodeMirror
        CodeMirror.fromTextArea(document.getElementById("codeMirrorDemo"), {
                mode: "htmlmixed",
                theme: "monokai"
        });
})


$(function () {
        //Initialize Select2 Elements
        $('.select2').select2()

        //Initialize Select2 Elements
        $('.select2bs4').select2({
                theme: 'bootstrap4'
        })

        //Datemask dd/mm/yyyy
        $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
        //Datemask2 mm/dd/yyyy
        $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
        //Money Euro
        $('[data-mask]').inputmask()

        //Date picker
        $('#reservationdate').datetimepicker({
                format: 'L'
        });

        //Date and time picker
        $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

        //Date range picker
        $('#reservation').daterangepicker()
        //Date range picker with time picker
        $('#reservationtime').daterangepicker({
                timePicker: true,
                timePickerIncrement: 30,
                locale: {
                        format: 'MM/DD/YYYY hh:mm A'
                }
        })
        //Date range as a button
        $('#daterange-btn').daterangepicker(
            {
                    ranges   : {
                            'Today'       : [moment(), moment()],
                            'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                            'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
                            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                            'This Month'  : [moment().startOf('month'), moment().endOf('month')],
                            'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    },
                    startDate: moment().subtract(29, 'days'),
                    endDate  : moment()
            },
            function (start, end) {
                    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
            }
        )

        //Timepicker
        $('#timepicker').datetimepicker({
                format: 'LT'
        })

        //Bootstrap Duallistbox
        $('.duallistbox').bootstrapDualListbox()

        //Colorpicker
        $('.my-colorpicker1').colorpicker()
        //color picker with addon
        $('.my-colorpicker2').colorpicker()

        $('.my-colorpicker2').on('colorpickerChange', function(event) {
                $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
        })

        $("input[data-bootstrap-switch]").each(function(){
                $(this).bootstrapSwitch('state', $(this).prop('checked'));
        })

})
// BS-Stepper Init
document.addEventListener('DOMContentLoaded', function () {
        window.stepper = new Stepper(document.querySelector('.bs-stepper'))
})

// DropzoneJS Demo Code Start
Dropzone.autoDiscover = false

// Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
var previewNode = document.querySelector("#template")
previewNode.id = ""
var previewTemplate = previewNode.parentNode.innerHTML
previewNode.parentNode.removeChild(previewNode)

var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
        url: "/target-url", // Set the url
        thumbnailWidth: 80,
        thumbnailHeight: 80,
        parallelUploads: 20,
        previewTemplate: previewTemplate,
        autoQueue: false, // Make sure the files aren't queued until manually added
        previewsContainer: "#previews", // Define the container to display the previews
        clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
})

myDropzone.on("addedfile", function(file) {
        // Hookup the start button
        file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
})

// Update the total progress bar
myDropzone.on("totaluploadprogress", function(progress) {
        document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
})

myDropzone.on("sending", function(file) {
        // Show the total progress bar when upload starts
        document.querySelector("#total-progress").style.opacity = "1"
        // And disable the start button
        file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
})

// Hide the total progress bar when nothing's uploading anymore
myDropzone.on("queuecomplete", function(progress) {
        document.querySelector("#total-progress").style.opacity = "0"
})

// Setup the buttons for all transfers
// The "add files" button doesn't need to be setup because the config
// `clickable` has already been specified.
document.querySelector("#actions .start").onclick = function() {
        myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
}
document.querySelector("#actions .cancel").onclick = function() {
        myDropzone.removeAllFiles(true)
}
// DropzoneJS Demo Code End