<?php

namespace Modules\Addons\ImageSlider\Controllers\Api;

use Modules\Addons\ImageSlider\Models\Backend\ImageSliderModel;
use CodeIgniter\RESTful\ResourceController;

class ApiImageSliderController extends ResourceController
{
    public function __construct()
    {
        $this->session = session();
        $this->imageSliderModel = new ImageSliderModel();
    }
    
    //===========================================================//
    public function get_images_slider()
    {
        $rules = [
            'api_id'            => 'required|integer',
            'api_key'           => 'required|min_length[32]|max_length[64]|validateApi[api_id,api_key]',
            'type_id'           => 'required|integer',
            'category_type_id'  => 'required|integer',
            'locale'            => 'required|alpha_dash|min_length[2]|max_length[10]',
            'limit'             => 'required|integer',
        ];
        
        if (!$this->validate($rules)) {
            echo json_encode($this->validator->getErrors(), JSON_UNESCAPED_UNICODE);
            die();
        }

        $api_id = $this->request->getVar('api_id');
        $type_id = $this->request->getVar('type_id');
        $category_type_id = $this->request->getVar('category_type_id');
        $locale = $this->request->getVar('locale');
        $limit = intval($this->request->getVar('limit'));

        $data['imagesSlider'] = $this->imageSliderModel->select('images_slider_tbl.*')
            ->Where('images_slider_tbl.type_id', $type_id)
            ->Where('images_slider_tbl.category_type_id', $category_type_id)
            ->Where('images_slider_tbl.locale', $locale)
            ->limit($limit)
            ->orderBy('images_slider_tbl.id', 'ASC')
            ->get()->getResult();
        if(!$data)
            echo json_encode("NoDataFound", JSON_UNESCAPED_UNICODE);

        $response = [
            'status' => 200,
            "error" => false,
            'messages' => 'Images Slider',
            'data' => $data,
        ];

        return $this->respondCreated($response);
    }

    public function get_images_slider2() {
        echo "Hello ";
    }

}
