<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.imagesGallery') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-6">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.addImagesToX', [$file->title]) ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/files-list') ?>" class="dropdown-item"><?= lang('Dashboard.filesList') ?></a>
                                            <a href="<?= base_url("file-details/$file->id/$file->title_slug?id=$file->id") ?>" target="_blank" class="dropdown-item"><?= lang('Dashboard.show').' '.$file->title ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-add-images-gallery') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    
                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?></label>
                                        <div class="col-sm-9" id="fileInputs">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input fileInputField" name="image[]" id="image" accept=".png,.jpeg,.jpg,.webp">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <label class="col-sm-3 col-form-label"></label>
                                        <div class="col-sm-9">
                                            <button type="button" class="btn btn-sm btn-success mt-1 mb-2" id="addButton"><small><i class="nav-icon fas fa-plus"></i> <?= lang('Dashboard.addAnotherFile') ?></small></button><br>
                                            <small class="text-info"><?= lang('Dashboard.onlyFilesWithPngJpgJpegWebpExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theImageSizeShouldBe', [ 800, 1200 ]) ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="file_id" value="<?= $file->id ?>" readonly>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" onclick="validateFilesSelected();" value="<?= lang('Dashboard.uploadFiles') ?>"><?= lang('Dashboard.uploadFiles') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.uploadFiles') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                                <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeCreatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-6">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.imagesGallery') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card-body">
                                <div class="row">
                                    <?php
                                    foreach($images as $img)
                                    {
                                    ?>
                                        <div class="col-sm-3">
                                            <a target="_blank" href="<?= base_url("backend/assets/uploads/admins/modules/contents/images_gallery/$img->image") ?>">
                                                <img src="<?= base_url("backend/assets/uploads/admins/modules/contents/images_gallery/thumb/$img->image") ?>" class="img-thumbnail" />
                                            </a>
                                            <div class="d-flex mb-4">
                                                <!--<a type="button" target="_blank" href="<?= base_url("backend/assets/uploads/admins/modules/contents/images_gallery/$img->image") ?>" class="btn btn-info btn-xs m-1"><i class="fa fa-eye"></i> <?= lang('Dashboard.view') ?></a>-->
                                                <a type="button" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" href="<?= base_url("dashboard/delete-images-gallery/$file->id?img_id=$img->id") ?>" class="btn btn-danger btn-xs m-1"><i class="fa fa-trash-alt"></i> <?= lang('Dashboard.delete') ?></a>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                    if(empty($images))
                                        echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound').". ".lang('Dashboard.addTheFirstImage')."<br><br></p>";
                                    ?>
                                </div>
                            </div>
                            
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <script>
        <?php
        $maxFileInputs = 10; // Maximum number of fields
        $maxFileSizeKB = 1024; // The maximum size of each file in KB (1024 KB = 1 MB)
        ?>
        var maxFileInputs = <?= $maxFileInputs ?>; 
        var currentFileInputCount = 1; // Current file input count 
        var allowedExtensions = ['png', 'jpeg', 'jpg', 'webp']; // Allowed extensions 
        var maxFileSizeKB = <?= $maxFileSizeKB ?>; 

        document.getElementById('addButton').addEventListener('click', function() {
            if (currentFileInputCount < maxFileInputs) {
                addFileInput();
            } else {
                alert('<?= lang('Dashboard.youCanOnlyaddUpToXFiles', [$maxFileInputs]) ?>');
            }
        });

        function addFileInput() {
            var fileInputsDiv = document.getElementById('fileInputs');
            var newFileInput = document.createElement('div');
            newFileInput.classList.add('fileInput');
            newFileInput.innerHTML = '<div class="input-group mt-1"><div class="custom-file"><input type="file" name="image[]" class="custom-file-input fileInputField" accept=".png,.jpeg,.jpg,.webp"><label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label></div></div>';
            fileInputsDiv.appendChild(newFileInput);
            addChangeListener(newFileInput.querySelector('.fileInputField'));
            currentFileInputCount++;
        }

        function validateFilesSelected() {
            var fileInputs = document.querySelectorAll('.fileInputField');
            for (var i = 0; i < fileInputs.length; i++) {
                if (fileInputs[i].files.length > 0) {
                    return true;
                }
            }
            alert('<?= lang('Dashboard.atLeastOneFileMustBeSelectedForUploading') ?>');
            event.preventDefault(); // Prevent the form from submitting
            return false; // Stop further processing
        }

        function addChangeListener(fileInputField) {
            fileInputField.addEventListener('change', function() {
                if (this.files && this.files.length > 0) {
                    var file = this.files[0];
                    var fileExtension = file.name.split('.').pop().toLowerCase();
                    var fileSizeKB = file.size / 1024; // Convert file size to KB

                    if (!allowedExtensions.includes(fileExtension)) {
                        alert('<?= lang('Dashboard.invalidFileTypeAllowedTypesAre') ?> ' + allowedExtensions.join(', '));
                        this.value = ''; // Clean the field
                    } else if (fileSizeKB > maxFileSizeKB) {
                        alert('<?= lang('Dashboard.fileSizeExceedsXKBPleaseSelectASmallerFileSize', [$maxFileSizeKB]) ?>');
                        this.value = ''; // Clean the field
                    } else if (currentFileInputCount < maxFileInputs) {
                        addFileInput();
                    } else if (image == "") {
                        alert('ddd');
                    }

                    // Update the label with the file name
                    var fileName = file.name;
                    var label = this.nextElementSibling;
                    if (label && label.classList.contains('custom-file-label')) {
                        label.textContent = fileName;
                    }
                }
            });
        }

        // Add change listener to the initial file input
        document.querySelectorAll('.fileInputField').forEach(addChangeListener);
    </script>

<?= $this->endSection() ?>