<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.downloadManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/files-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                <table class="table table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.id') ?></th>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.category') ?></th>
                                        <th><?= lang('Dashboard.volume') ?></th>
                                        <th><?= lang('Dashboard.image') ?></th>
                                        <th><?= lang('Dashboard.genre') ?></th>
                                        <th><?= lang('Dashboard.type') ?></th>
                                        <th><?= lang('Dashboard.views') ?></th>
                                        <th><?= lang('Dashboard.downloads') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($files as $file)
                                    {
                                        $status = "<span class='badge badge-secondary'>".lang('Dashboard.pending')."</span>";
                                        if($file->status == 0) $status = "<span class='center badge badge-secondary'>".lang('Dashboard.pending')."</span>";
                                        if($file->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.active')."</span>";
                                        if($file->status == 2) $status = "<span class='center badge badge-danger'>".lang('Dashboard.hardRejected')."</span>";
                                        if($file->status == 3) $status = "<span class='center badge badge-warning'>".lang('Dashboard.softRejected')."</span>";
                                        if($file->status == 4) $status = "<span class='center badge badge-dark'>".lang('Dashboard.suspended')."</span>";

                                        if($file->download_type == 1) $download_type = "<span class='center badge badge-info'>".lang('Dashboard.free')."</span>";
                                        if($file->download_type == 2) $download_type = "<span class='center badge badge-primary'>".lang('Dashboard.paid')."</span>";
                                        if($file->download_type == 3) $download_type = "<span class='center badge badge-danger'>".lang('Dashboard.inAppPurchase')."</span>";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $file->id ?></td>
                                            <td class="align-middle"><strong><?= $file->title ?></strong> (<?= $file->version_name ?>)<br><small class="text-muted"><?= $file->publisher_name ?></small></td>
                                            <td class="align-middle"><?= $file->category_title ?></td>
                                            <td class="align-middle"><?= $file->volume ?></td>
                                            <td class="align-middle"><img width="72px" height="auto" src="<?= base_url("backend/assets/uploads/admins/modules/contents/download/thumb/$file->image") ?>" class="img-rounded" alt="<?= $file->title ?>"></td>
                                            <td class="align-middle"><?= $file->category_type_title ?></td>
                                            <td class="align-middle"><?= $download_type ?></td>
                                            <td class="align-middle"><?= $file->views ?></td>
                                            <td class="align-middle"><?= $file->downloads ?></td>
                                            <td class="align-middle"><?= $status ?></td>
                                            <td class="align-middle">
                                            <?php
                                            if($file->category_type_title == "Apps")
                                                $edit_url = "edit-app-file-user";
                                            if($file->category_type_title == "Games")
                                                $edit_url = "edit-game-file-user";
                                            ?>
                                                <div class="dropdown">
                                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown">
                                                        <?= lang('Dashboard.action') ?>
                                                    </button>
                                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>">
                                                        <a class="dropdown-item" target="_blank" title="<?= lang('Dashboard.show') ?>" href="<?= base_url("file-details/$file->id/$file->title_slug") ?>" class="text-primary p-1"><i class="fas fa-eye"></i> <?= lang('Dashboard.show') ?></a>
                                                        <a class="dropdown-item" title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/'.$edit_url.'/'.$file->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i> <?= lang('Dashboard.edit') ?></a>
                                                        <a class="dropdown-item" title="<?= lang('Dashboard.imagesGallery') ?>" href="<?= base_url('dashboard/images-gallery/'.$file->id) ?>" class="text-info p-1"><i class="fas fa-images"></i> <?= lang('Dashboard.imagesGallery') ?></a>
                                                    </div>
                                                </div> 
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($files)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
// Pass language variables to confirmAction function.
var lang_yes = "<?= lang('Dashboard.yes') ?>";
var lang_no = "<?= lang('Dashboard.no') ?>";
</script>
<?= $this->endSection() ?>