<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersReviews') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-8">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/contents-reviews-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersReviews') ?></a>
                                            <a href="<?= base_url('dashboard/deleted-contents-reviews-list') ?>" class="dropdown-item"><?= lang('Dashboard.deletedUsersReviews') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-contents-review') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-2 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= $review->title ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="description" class="col-sm-2 col-form-label"><?= lang('Dashboard.review') ?> *</label>
                                        <div class="col-sm-10">
                                            <textarea rows="6" class="form-control" name="description" required placeholder="<?= lang('Dashboard.review') ?>"><?= $review->description ?></textarea>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <?php
                                        $selected_star1 = $selected_star2 = $selected_star3 = $selected_star4 = $selected_star5 = "";
                                        if($review->rating == 1) $selected_star1 = "selected";
                                        if($review->rating == 2) $selected_star2 = "selected";
                                        if($review->rating == 3) $selected_star3 = "selected";
                                        if($review->rating == 4) $selected_star4 = "selected";
                                        if($review->rating == 5) $selected_star5 = "selected";

                                        ?>
                                        <label for="rating" class="col-sm-2 col-form-label"><?= lang('Dashboard.rating') ?> *</label>
                                        <div class="col-sm-3">
                                            <select class="form-control" name="rating" id="rating" required>
                                                <option <?= $selected_star1 ?> value="1">1 <?= lang('Dashboard.star') ?></option>
                                                <option <?= $selected_star2 ?> value="2">2 <?= lang('Dashboard.stars') ?></option>
                                                <option <?= $selected_star3 ?> value="3">3 <?= lang('Dashboard.stars') ?></option>
                                                <option <?= $selected_star4 ?> value="4">4 <?= lang('Dashboard.stars') ?></option>
                                                <option <?= $selected_star5 ?> value="5">5 <?= lang('Dashboard.stars') ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" readonly name="review_id" value="<?= $review->id ?>">
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.edit') ?>"><?= lang('Dashboard.edit') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.edit') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>