<?php

use App\Models\Backend\CategoryModel;
$categoryModel = new CategoryModel();

?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.downloadManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-danger card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/contents-reviews-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th style="min-width: 150px;"><?= lang('Dashboard.author') ?></th>
                                        <th style="min-width: 150px;"><?= lang('Dashboard.file') ?></th>
                                        <th><?= lang('Dashboard.review') ?></th>
                                        <th><?= lang('Dashboard.rating') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th style="min-width: 150px;"><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <form class="contact-form" method="POST" id="approvedForm" accept-charset="UTF-8" onsubmit="return false">
                                    <?= csrf_field() ?>
                                    <?php
                                    foreach ($contentsReviews as $review)
                                    {
                                        $author_ip = $review->author_ip;
                                        if($theRoleID == 9)
                                            $author_ip = 'xx.xx.xx.xx';
                                    ?>
                                    
                                        <tr>
                                        <td class="align-middle"><a href="<?= base_url("dashboard/user-profile/$review->user_id") ?>"><?= $review->first_name." ".$review->last_name ?></a></td>
                                            <td class="align-middle"><a target="_blank" href="<?= base_url("file-details/$review->content_id/file") ?>"><?= $review->content_title ?></a></td>
                                            <?php
                                            $description_count = str_word_count($review->description);
                                            if ($description_count > 25)
                                            {
                                            ?>
                                            <td class="align-middle"><?= $review->title ?><br><?= word_limiter($review->description, 25); ?> 
                                                [<a href="#" onclick="openModal('<?= $review->description ?>', <?= $review->id ?>)"><?= lang('Dashboard.readMore') ?></a>]
                                            </td>
                                            <?php
                                            }else{
                                            ?>
                                            <td class="align-middle"><?= $review->title ?><br><?= $review->description; ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td class="align-middle"><?= $review->rating ?> <i class="fas fa-star fa-sm text-yellow"></i></td>
                                            <td class="align-middle"><a target="_blank" href="https://extreme-ip-lookup.com/<?= $author_ip ?>" title="<?= $review->author_agent ?>"><?= $author_ip ?></a></td>
                                            <td class="align-middle">
                                                <div class="form-group">
                                                    <?php
                                                        $approved_checked = "";
                                                        if($review->approved == 1)
                                                            $approved_checked = "checked";
                                                    ?>
                                                    <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success pt-3">
                                                        <input type="hidden" id="review_id_<?= $review->id ?>" value="<?= $review->id ?>">
                                                        <input type="checkbox" class="custom-control-input" disabled id="show_hide_<?= $review->id ?>" <?= $approved_checked ?> onclick="approvedFunction(this);">
                                                        <input type="hidden" id="approved" value="<?= $review->approved ?>">
                                                        <label class="custom-control-label" for="show_hide_<?= $review->id ?>"></label>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="align-middle" style="width: 128px;">
                                                <a target="_blank" title="<?= lang('Dashboard.viewFile') ?>" href="<?= base_url("file-details/$review->content_id/file") ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>&nbsp;
                                                <a title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/edit-contents-review/'.$review->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>
                                                <a title="<?= lang('Dashboard.restore') ?>" href="<?= base_url('dashboard/restore-contents-review/'.$review->id) ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToRestore') ?>');" class="text-dark p-1">&nbsp;<i class="fas fa-trash-restore-alt"></i></a>
                                                <a title="<?= lang('Dashboard.hardDelete') ?>" href="<?= base_url('dashboard/hard-delete-contents-review/'.$review->id); ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToHardDelete') ?>');" class="text-danger p-1">&nbsp;<i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    
                                    <?php
                                    }
                                    ?>
                                    </tbody>
                                    </form>
                                </table>
                                <?php
                                if(empty($contentsReviews)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Modal -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel"><?= lang('Dashboard.review') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p id="fullDescription"></p>
                    <p class="d-none" id="reviewId"></p>
                </div>
                <div class="modal-footer">
                <a href="#" id="deleteReviewButton" type="button" class="btn btn-sm btn-danger" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');"><?= lang('Dashboard.deleteReview') ?></a>
                <a href="#" id="editReviewButton" type="button" class="btn btn-sm btn-success"><?= lang('Dashboard.editReview') ?></a>
            </div>
            </div>
        </div>
    </div>

<script>
    function openModal(description, reviewId) {
        // Set the full description in the modal
        document.getElementById("fullDescription").textContent = description;
        document.getElementById("reviewId").textContent = "Review ID: " + reviewId;
        document.getElementById("editReviewButton").href = "<?= base_url('dashboard/edit-contents-review/') ?>";
        document.getElementById("editReviewButton").href += reviewId; // Append reviewId to the Edit button URL
        document.getElementById("deleteReviewButton").href = "<?= base_url('dashboard/hard-delete-contents-review/') ?>";
        document.getElementById("deleteReviewButton").href += reviewId; // Append reviewId to the Delete button URL
        // Open the modal
        $('#myModal').modal('show');
    }
</script>

<script>
    function approvedFunction(checkbox) {
        // Get the CSRF token value
        var csrfToken = document.querySelector('input[name="csrf_appdl"]').value;

        var reviewId = checkbox.previousElementSibling.value;
        var approved = checkbox.nextElementSibling.value;
        var data = new URLSearchParams();
        var xhr = new XMLHttpRequest();
        var url = "<?= base_url('dashboard/perform-approve-unapprove-contents-reviews') ?>";

        data.append('review_id', reviewId);
        data.append('approved', approved);

        xhr.open('POST', url, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
        xhr.send(data);
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                if(xhr.responseText == 3) {
                    // Please fill all required fields
                    //alert(xhr.responseText);
                    toastr["error"](xhr.responseText, "<?= lang('Dashboard.error') ?>");

                }else {
                    //alert(xhr.responseText);
                    // https://codeseven.github.io/toastr/demo.html
                    toastr.options = {
                    "progressBar": true,
                    "positionClass": "toast-top-center",
                    }
                    toastr["success"](xhr.responseText, "");
                }

                var updated_approved = 0;
                if(approved == 1)
                    updated_approved = 0;
                else
                    updated_approved = 1;
                
                checkbox.nextElementSibling.value = updated_approved;

            }else if(xhr.status !== 200){
                //alert('<?= lang('Dashboard.errorCode') ?>: '+xhr.status);
                toastr["error"]("<?= lang('Dashboard.errorCode') ?>: "+xhr.status, "<?= lang('Dashboard.error') ?>");
            }
        };
    }
</script>
<?= $this->endSection() ?>