<?php

namespace Modules\Addons\Contents\Controllers\Backend;

use Modules\Addons\Contents\Models\Backend\ContentModel;
use Modules\Addons\Contents\Models\Backend\ContentReviewModel;
use Modules\Addons\Contents\Models\Backend\ContentReportModel;
use Modules\Addons\Contents\Models\Backend\ContentDownloadedModel;
use Modules\Addons\Contents\Models\Backend\ContentImageGalleryModel;
use App\Controllers\BaseController;

class ContentController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
        $this->contentModel = new ContentModel();
        $this->contentReviewModel = new ContentReviewModel();
        $this->contentImageGalleryModel = new ContentImageGalleryModel();
    }


    //===========================================================//
    public function files_list()
    {
        $locale = $this->session->lang;
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'files' => $this->contentModel
                    ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                    ->Where('contents_tbl.locale', $locale)
                    ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                    ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                    ->orderBy('contents_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentModel->pager
            ];

        }else{
            $data = [
                'files' => $this->contentModel
                ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                ->Where('contents_tbl.locale', $locale)
                ->like('contents_tbl.title',$keyword)
                ->orLike('contents_tbl.about_content',$keyword)
                ->orLike('contents_tbl.description',$keyword)
                ->orLike('contents_tbl.keywords',$keyword)
                ->orLike('contents_tbl.publisher_name',$keyword)
                ->orLike('categories_types_tbl.title',$keyword)
                ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                ->orderBy('contents_tbl.id', 'DESC')
                ->paginate(10),
                'pager' => $this->contentModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.filesList');
        $data['pageSubTitle'] = lang('Dashboard.filesList');
        return view('\Modules\Addons\Contents\Views\backend\contents\files_list_view', $data);
    }


    //===========================================================//
    public function files_list_pending()
    {
        $locale = $this->session->lang;
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'files' => $this->contentModel
                    ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                    ->Where('contents_tbl.locale', $locale)
                    ->Where('contents_tbl.status', 0)
                    ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                    ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                    ->orderBy('contents_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentModel->pager
            ];

        }else{
            $data = [
                'files' => $this->contentModel
                ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                ->Where('contents_tbl.locale', $locale)
                ->Where('contents_tbl.status', 0)
                ->like('contents_tbl.title',$keyword)
                ->orLike('contents_tbl.about_content',$keyword)
                ->orLike('contents_tbl.description',$keyword)
                ->orLike('contents_tbl.keywords',$keyword)
                ->orLike('contents_tbl.publisher_name',$keyword)
                ->orLike('categories_types_tbl.title',$keyword)
                ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                ->orderBy('contents_tbl.id', 'DESC')
                ->paginate(10),
                'pager' => $this->contentModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.filesList');
        $data['pageSubTitle'] = lang('Dashboard.filesList');
        return view('\Modules\Addons\Contents\Views\backend\contents\files_list_view', $data);
    }


    //===========================================================//
    public function files_list_user()
    {
        $user_id = $this->session->id;
        $locale = $this->session->lang;
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'files' => $this->contentModel
                    ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                    ->Where('contents_tbl.user_id', $user_id)
                    ->Where('contents_tbl.locale', $locale)
                    ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                    ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                    ->orderBy('contents_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentModel->pager
            ];

        }else{
            $data = [
                'files' => $this->contentModel
                    ->select('contents_tbl.*, categories_tbl.title AS category_title, categories_types_tbl.title AS category_type_title, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name')
                    ->Where('contents_tbl.user_id', $user_id)    
                    ->Where('contents_tbl.locale', $locale)
                    ->like('contents_tbl.title',$keyword)
                    ->orLike('contents_tbl.about_content',$keyword)
                    ->orLike('contents_tbl.description',$keyword)
                    ->orLike('contents_tbl.keywords',$keyword)
                    ->orLike('contents_tbl.publisher_name',$keyword)
                    ->orLike('categories_types_tbl.title',$keyword)
                    ->join('categories_tbl', 'categories_tbl.id = contents_tbl.category_id')
                    ->join('categories_types_tbl', 'categories_types_tbl.id = categories_tbl.type_id')
                    ->join('users_tbl', 'users_tbl.id = contents_tbl.user_id')
                    ->orderBy('contents_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.filesList');
        $data['pageSubTitle'] = lang('Dashboard.filesList');
        return view('\Modules\Addons\Contents\Views\backend\contents\files_list_user_view', $data);
    }


	//===========================================================//
    public function images_gallery()
    {
        // Check product exist
        $id = service('uri')->getSegment(3);
        $data['file'] = $this->contentModel->select('contents_tbl.*')->where('contents_tbl.id', $id)->first();
        if(is_null($data['file']))
        {
            return redirect()->to(base_url('dashboard/files-list'))->with('error', lang('Dashboard.notFound'));
        }

        $locale = $this->session->lang;
        $data['images'] = $this->contentImageGalleryModel->select('contents_images_gallery_tbl.*')->where('contents_images_gallery_tbl.locale', $locale)->where('contents_images_gallery_tbl.content_id', $id)->get()->getResult();

        $data['pageTitle'] = lang('Dashboard.addImagesGallery');
        $data['pageSubTitle'] = lang('Dashboard.addImagesGallery');
        return view('\Modules\Addons\Contents\Views\backend\contents\images_gallery_view', $data);
    }
	
	
	//===========================================================//
    public function perform_add_images_gallery()
    {
        // Validation the form
        $rules = [
            'file_id'               => 'required|integer',
            'image'                 => [
                'ext_in[image,png,jpg,jpeg,webp]',
                'is_image[image]',
                'max_size[image,1000]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1000 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegWebpExtensionAreSupported')
                ]
            ],
        ];

        
        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/images-gallery/{$this->request->getVar('file_id')}"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $locale = $this->session->lang;
        $file_id = $this->request->getVar('file_id');
        $files = $this->request->getFiles();
        if (empty($files['image']) || count($files['image']) === 0) {
            return redirect()->to(base_url("dashboard/images-gallery/{$this->request->getVar('file_id')}"))
                ->withInput()
                ->with('error', lang('Dashboard.atLeastOneFileMustBeSelectedForUploading'));
        }
        
        foreach ($files['image'] as $file) {
            if ($file->isValid() && !$file->hasMoved()) {
                $imgExtension = $file->getExtension();
                $newName = $newWebpName = $file_id.'_'.$file->getRandomName();
                $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
                $newWebpName = $newNameWithoutExtension . '.webp';
                $imageExtension = $file->getExtension();
                $file->move('./backend/assets/uploads/admins/modules/contents/images_gallery/', $newName);
                $imgPath = $file->getTempName();
                $imgQuality = 85;
                $watermark = "";
                $imgWidth = 800;
                $imgHeight = 1200;
                $imgWidthThumbnail = 320;
                $imgHeightThumbnail = 480;
    
                // Image Process
                helper('image_process');
                imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);
                imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, true); // Create thumbnail

                // Remove original image from disk
                if($imageExtension != 'webp')
                {
                    @unlink($imgPath . $newName);
                    @unlink($imgPath . 'thumb/' . $newName);
                }

                $data = [
                    'content_id'    => $file_id,
                    'locale'        => $locale,
                    'image'         => $newWebpName,
                    'status'        => 1,
                ];
                $this->contentImageGalleryModel->save($data);
            }
        }

        return redirect()->to(base_url("dashboard/images-gallery/$file_id"))->with('success', lang('Dashboard.imagesGalleryUpdatedSuccessfully'));
    }
	
	
	//===========================================================//
    public function delete_images_gallery()
    {
        // Check file exist
        $file_id = service('uri')->getSegment(3);
        $img_id = $this->request->getVar('img_id');
        $img = $this->contentImageGalleryModel->where('id', $img_id)->first();
        if(is_null($img))
        {
            return redirect()->to(base_url("dashboard/images-gallery/$file_id"))->with('error', lang('Dashboard.notFound'));

        }else{
            // Delete image
            $this->contentImageGalleryModel->delete($img_id);

            // Remove image from disk
            if($img->image != '') {
                @unlink('./backend/assets/uploads/admins/modules/contents/images_gallery/'.$img->image);
                @unlink('./backend/assets/uploads/admins/modules/contents/images_gallery/thumb/'.$img->image);
            }

            return redirect()->to(base_url("dashboard/images-gallery/$file_id"))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }
	
	
    //===========================================================//
	public function add_app_file()
	{
        $locale = $this->session->lang;
        $type_id = 1; // 1 = Apps | 2 = Games
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['typeId'] = $type_id;
	    $data['pageTitle'] = lang('Dashboard.addAppFile');
        $data['pageSubTitle'] = lang('Dashboard.addAppFile');

        return view('\Modules\Addons\Contents\Views\backend\contents\add_file_view', $data);
	}


    //===========================================================//
	public function add_app_file_user()
	{
        $locale = $this->session->lang;
        $type_id = 1; // 1 = Apps | 2 = Games
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['typeId'] = $type_id;
	    $data['pageTitle'] = lang('Dashboard.addAppFile');
        $data['pageSubTitle'] = lang('Dashboard.addAppFile');

        return view('\Modules\Addons\Contents\Views\backend\contents\add_file_user_view', $data);
	}


    //===========================================================//
	public function add_game_file()
	{
        $locale = $this->session->lang;
        $type_id = 2; // 1 = Apps | 2 = Games
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

	    $data['typeId'] = $type_id;
	    $data['pageTitle'] = lang('Dashboard.addGameFile');
        $data['pageSubTitle'] = lang('Dashboard.addGameFile');

        return view('\Modules\Addons\Contents\Views\backend\contents\add_file_view', $data);
	}


    //===========================================================//
	public function add_game_file_user()
	{
        $locale = $this->session->lang;
        $type_id = 2; // 1 = Apps | 2 = Games
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

	    $data['typeId'] = $type_id;
	    $data['pageTitle'] = lang('Dashboard.addGameFile');
        $data['pageSubTitle'] = lang('Dashboard.addGameFile');

        return view('\Modules\Addons\Contents\Views\backend\contents\add_file_user_view', $data);
	}


    //===========================================================//
    public function perform_add_file_user()
    {
        // Validation the form
        $rules = [
            'title'             => 'required|min_length[2]|max_length[100]|is_unique[contents_tbl.title]',
            'about_content'     => 'required|min_length[2]',
            'latest_changelog'  => 'permit_empty',
            'package_name'      => 'permit_empty',
            'version_code'      => 'required|integer',
            'version_name'      => 'required',
            'system_requirements' => 'required',
            'volume'            => 'required',
            'publisher_name'    => 'required',
            'publisher_url'     => 'required|valid_url',
            'download_url'      => 'required|valid_url',
            'description'       => 'max_length[255]',
            'keywords'          => 'max_length[255]',
            'tags'              => 'max_length[255]',
            'structure_id'      => 'required|integer',
            'category_id'       => 'required|integer',
            'download_type'     => 'required|integer',
            'role_id'           => 'required|integer',
            'special'           => 'permit_empty',
            'featured'          => 'permit_empty',
            'allow_comments'    => 'permit_empty',
            'allow_reviews'     => 'permit_empty',
            'install_after_downloading' => 'permit_empty',
            'status'            => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,1024]',
                'max_dims[image,512,512]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]),
                    'max_dims' => lang('Dashboard.theMaximumWidthAndHeightOfAnUploadedImageShouldBe', [ 512, 512 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
                die();
        }

        $newName = $newWebpName = "file.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/contents/download/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 512;
            $imgHeight = 512;
            $imgWidthThumbnail = 256;
            $imgHeightThumbnail = 256;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, true); // Create thumbnail

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }
        }

        $allow_reviews = $allow_comments = $special = $featured = $install_after_downloading = 0;
        if($this->request->getVar('allow_reviews') == 'on') $allow_reviews = 1;
        if($this->request->getVar('install_after_downloading') == 'on') $install_after_downloading = 1;
        if($this->request->getVar('allow_comments') == 'on') $allow_comments = 1;

        $fileData = [
            'user_id'           => $this->request->getVar('user_id'),
            'title'             => $this->request->getVar('title'),
            'title_slug'        => url_title($this->request->getVar('title'), '-', true),
            'about_content'     => htmlspecialchars($this->request->getVar('about_content')),
            'latest_changelog'  => htmlspecialchars($this->request->getVar('latest_changelog')),
            'package_name'      => $this->request->getVar('package_name'),
            'version_code'      => $this->request->getVar('version_code'),
            'version_name'      => $this->request->getVar('version_name'),
            'system_requirements'      => $this->request->getVar('system_requirements'),
            'volume'            => $this->request->getVar('volume'),
            'publisher_name'    => $this->request->getVar('publisher_name'),
            'publisher_url'     => $this->request->getVar('publisher_url'),
            'download_url'      => $this->request->getVar('download_url'),
            'description'       => $this->request->getVar('description'),
            'keywords'          => $this->request->getVar('keywords'),
            'tags'              => $this->request->getVar('tags'),
            'tags_slug'         => url_title($this->request->getVar('tags'),'-',true),
            'structure_id'      => $this->request->getVar('structure_id'),
            'category_id'       => $this->request->getVar('category_id'),
            'download_type'     => $this->request->getVar('download_type'),
            'role_id'           => $this->request->getVar('role_id'),
            'allow_comments'    => $allow_comments,
            'allow_reviews'     => $allow_reviews,
            'install_after_downloading'     => $install_after_downloading,
            'special'           => $special,
            'featured'          => $featured,
            'status'            => $this->request->getVar('status'),
            'locale'            => $this->request->getVar('locale'),
            'image'             => $newWebpName,
        ];
        $this->contentModel->save($fileData);

        $insert_id = $this->contentModel->getInsertID();

        //return redirect()->to(base_url("dashboard/files-list-user"))->with('success', lang('Dashboard.fileAddedSuccessfully'));
        return redirect()->to(base_url("dashboard/images-gallery/$insert_id"))->with('success', lang('Dashboard.fileAddedSuccessfully'));
    }


    //===========================================================//
    public function perform_add_file()
    {
        // Validation the form
        $rules = [
            'title'             => 'required|min_length[2]|max_length[100]|is_unique[contents_tbl.title]',
            'about_content'     => 'required|min_length[2]',
            'latest_changelog'  => 'permit_empty',
            'package_name'      => 'permit_empty',
            'version_code'      => 'required|integer',
            'version_name'      => 'required',
            'system_requirements'      => 'required',
            'volume'            => 'required',
            'publisher_name'    => 'required',
            'publisher_url'     => 'required|valid_url',
            'download_url'      => 'required|valid_url',
            'description'       => 'max_length[255]',
            'keywords'          => 'max_length[255]',
            'tags'              => 'max_length[255]',
            'structure_id'      => 'required|integer',
            'category_id'       => 'required|integer',
            'download_type'     => 'required|integer',
            'role_id'           => 'required|integer',
            'special'           => 'permit_empty',
            'featured'          => 'permit_empty',
            'dl_after_rewarded_ad' => 'permit_empty',
            'power_ribbon'      => 'permit_empty',
            'allow_comments'    => 'permit_empty',
            'allow_reviews'     => 'permit_empty',
            'install_after_downloading' => 'permit_empty',
            'status'            => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,1024]',
                'max_dims[image,512,512]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]),
                    'max_dims' => lang('Dashboard.theMaximumWidthAndHeightOfAnUploadedImageShouldBe', [ 512, 512 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
                die();
        }

        $newName = $newWebpName = "file.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/contents/download/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 512;
            $imgHeight = 512;
            $imgWidthThumbnail = 256;
            $imgHeightThumbnail = 256;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, true); // Create thumbnail

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }
        }

        $allow_reviews = $allow_comments = $special = $featured = $dl_after_rewarded_ad = $install_after_downloading = 0;
        if($this->request->getVar('allow_reviews') == 'on') $allow_reviews = 1;
        if($this->request->getVar('install_after_downloading') == 'on') $install_after_downloading = 1;
        if($this->request->getVar('allow_comments') == 'on') $allow_comments = 1;
        if($this->request->getVar('special') == 'on') $special = 1;
        if($this->request->getVar('featured') == 'on') $featured = 1;
        if($this->request->getVar('dl_after_rewarded_ad') == 'on') $dl_after_rewarded_ad = 1;

        $fileData = [
            'user_id'           => $this->request->getVar('user_id'),
            'title'             => $this->request->getVar('title'),
            'title_slug'        => url_title($this->request->getVar('title'), '-', true),
            'about_content'     => htmlspecialchars($this->request->getVar('about_content')),
            'latest_changelog'  => htmlspecialchars($this->request->getVar('latest_changelog')),
            'package_name'      => $this->request->getVar('package_name'),
            'version_code'      => $this->request->getVar('version_code'),
            'version_name'      => $this->request->getVar('version_name'),
            'system_requirements'      => $this->request->getVar('system_requirements'),
            'volume'            => $this->request->getVar('volume'),
            'publisher_name'    => $this->request->getVar('publisher_name'),
            'publisher_url'     => $this->request->getVar('publisher_url'),
            'download_url'      => $this->request->getVar('download_url'),
            'description'       => $this->request->getVar('description'),
            'keywords'          => $this->request->getVar('keywords'),
            'tags'              => $this->request->getVar('tags'),
            'tags_slug'         => url_title($this->request->getVar('tags'),'-',true),
            'structure_id'      => $this->request->getVar('structure_id'),
            'category_id'       => $this->request->getVar('category_id'),
            'download_type'     => $this->request->getVar('download_type'),
            'role_id'           => $this->request->getVar('role_id'),
            'allow_comments'    => $allow_comments,
            'allow_reviews'     => $allow_reviews,
            'install_after_downloading' => $install_after_downloading,
            'special'           => $special,
            'featured'          => $featured,
            'dl_after_rewarded_ad' => $dl_after_rewarded_ad,
            'power_ribbon'      => $this->request->getVar('power_ribbon'),
            'status'            => $this->request->getVar('status'),
            'locale'            => $this->request->getVar('locale'),
            'image'             => $newWebpName,
        ];
        $this->contentModel->save($fileData);

        $insert_id = $this->contentModel->getInsertID();

        return redirect()->to(base_url("dashboard/images-gallery/$insert_id"))->with('success', lang('Dashboard.fileAddedSuccessfully'));
    }


    //===========================================================//
    public function delete_file()
    {
        // Check file is exist
        $id = service('uri')->getSegment(3);
        $file = $this->contentModel->where('id', $id)->first();
        if(is_null($file))
        {
            return redirect()->to(base_url('dashboard/files-list'))->with('error', lang('Dashboard.notFound'));

        }else{
            // Remove image gallery from disk (if exist)
            $images = $this->contentImageGalleryModel->select('contents_images_gallery_tbl.*')->where('contents_images_gallery_tbl.content_id', $file->id)->get()->getResult();
            if(!empty($images))
            {
                foreach($images as $img)
                {
                    unlink('./backend/assets/uploads/admins/modules/contents/images_gallery/'.$img->image);
                    unlink('./backend/assets/uploads/admins/modules/contents/images_gallery/thumb/'.$img->image);
                }
            }

            // Delete content
            $this->contentModel->delete($id);

            // Remove image from disk
            if($file->image != 'file.png') {
                @unlink('./backend/assets/uploads/admins/modules/contents/download/'.$file->image);
                @unlink('./backend/assets/uploads/admins/modules/contents/download/thumb/'.$file->image);
            }
            
            return redirect()->to(base_url('dashboard/files-list'))->with('success', lang('Dashboard.dataDeletedSuccessfully'));
        }
    }


    //===========================================================//
    public function edit_app_file()
    {
        $id = service('uri')->getSegment(3);
        $type_id = 1; // 1 = Apps | 2 = Games
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['content'] = $this->contentModel->select('contents_tbl.*')
            ->where('contents_tbl.id', $id)
            ->first();

        $data['typeId'] = $type_id;
        $data['pageTitle'] = lang('Dashboard.editFile');
        $data['pageSubTitle'] = lang('Dashboard.editFile');
        return view('\Modules\Addons\Contents\Views\backend\contents\edit_file_view', $data);
    }


    //===========================================================//
    public function edit_app_file_user()
    {
        $id = service('uri')->getSegment(3);
        // Check the file owner
        $data['file'] = $this->contentModel->where('id', $id)->where('user_id', $this->session->id)->first();
        if(is_null($data['file']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }
        
        $type_id = 1; // 1 = Apps | 2 = Games
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['content'] = $this->contentModel->select('contents_tbl.*')
            ->where('contents_tbl.id', $id)
            ->first();

        $data['typeId'] = $type_id;
        $data['pageTitle'] = lang('Dashboard.editFile');
        $data['pageSubTitle'] = lang('Dashboard.editFile');
        return view('\Modules\Addons\Contents\Views\backend\contents\edit_file_user_view', $data);
    }


    //===========================================================//
    public function edit_game_file()
    {
        $id = service('uri')->getSegment(3);
        $type_id = 2; // 1 = Apps | 2 = Games
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['content'] = $this->contentModel->select('contents_tbl.*')
            ->where('contents_tbl.id', $id)
            ->first();

        $data['typeId'] = $type_id;
        $data['pageTitle'] = lang('Dashboard.editFile');
        $data['pageSubTitle'] = lang('Dashboard.editFile');
        return view('\Modules\Addons\Contents\Views\backend\contents\edit_file_view', $data);
    }


    //===========================================================//
    public function edit_game_file_user()
    {
        $id = service('uri')->getSegment(3);
        // Check the file owner
        $data['file'] = $this->contentModel->where('id', $id)->where('user_id', $this->session->id)->first();
        if(is_null($data['file']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        $type_id = 2; // 1 = Apps | 2 = Games
        $locale = $this->session->lang;
        $db = db_connect();

        // Fetch structures
        $builder = $db->table('contents_structure_tbl');
        $builder->where('status', 1);
        $builder->orderBy('id', 'ASC');
        $data['contentStructure'] = $builder->get()->getResult();

        // Fetch main categories
        $builder = $db->table('categories_tbl');
        $builder->where('locale', $locale);
        $builder->where('status', 1);
        $builder->where('parent_id', 0);
        $builder->where('type_id', $type_id);
        $builder->where('deleted_at', NULL);
        $builder->orderBy('id', 'ASC');
        $data['contentMainCategories'] = $builder->get()->getResult();

        $db->close();

        $data['content'] = $this->contentModel->select('contents_tbl.*')
            ->where('contents_tbl.id', $id)
            ->first();

        $data['typeId'] = $type_id;
        $data['pageTitle'] = lang('Dashboard.editFile');
        $data['pageSubTitle'] = lang('Dashboard.editFile');
        return view('\Modules\Addons\Contents\Views\backend\contents\edit_file_user_view', $data);
    }


    //===========================================================//
    public function perform_edit_file()
    {
        $old_image = $this->request->getVar('old_image');
        
        // Define validation rules
        $rules = [
            'id'                => 'required|integer',
            'old_image'         => 'required',
            'title'             => 'required|min_length[2]|max_length[100]',
            'title_slug'        => 'required|min_length[2]|max_length[255]',
            'about_content'     => 'required|min_length[2]',
            'latest_changelog'  => 'permit_empty',
            'package_name'      => 'permit_empty',
            'version_code'      => 'required|integer',
            'version_name'      => 'required',
            'system_requirements' => 'required',
            'volume'            => 'required',
            'publisher_name'    => 'required',
            'publisher_url'     => 'required|valid_url',
            'download_url'      => 'required|valid_url',
            'description'       => 'max_length[255]',
            'keywords'          => 'max_length[255]',
            'tags'              => 'max_length[255]',
            'structure_id'      => 'required|integer',
            'category_id'       => 'required|integer',
            'download_type'     => 'required|integer',
            'role_id'           => 'required|integer',
            'special'           => 'permit_empty',
            'featured'          => 'permit_empty',
            'dl_after_rewarded_ad' => 'permit_empty',
            'power_ribbon'      => 'permit_empty',
            'allow_comments'    => 'permit_empty',
            'allow_reviews'     => 'permit_empty',
            'install_after_downloading' => 'permit_empty',
            'status'            => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,1024]',
                'max_dims[image,512,512]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]),
                    'max_dims' => lang('Dashboard.theMaximumWidthAndHeightOfAnUploadedImageShouldBe', [ 512, 512 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        // Validate the form
        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        // Flags setup using ternary operator
        $allow_reviews = $this->request->getVar('allow_reviews') === 'on' ? 1 : 0;
        $allow_comments = $this->request->getVar('allow_comments') === 'on' ? 1 : 0;
        $special = $this->request->getVar('special') === 'on' ? 1 : 0;
        $featured = $this->request->getVar('featured') === 'on' ? 1 : 0;
        $dl_after_rewarded_ad = $this->request->getVar('dl_after_rewarded_ad') === 'on' ? 1 : 0;
        $install_after_downloading = $this->request->getVar('install_after_downloading') === 'on' ? 1 : 0;

        $newName = $newWebpName = "file.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/contents/download/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 512;
            $imgHeight = 512;
            $imgWidthThumbnail = 256;
            $imgHeightThumbnail = 256;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, true); // Create thumbnail

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }

            // Remove old image from disk
            if($old_image != 'file.png') {
                @unlink('./backend/assets/uploads/admins/modules/contents/download/'.$old_image);
                @unlink('./backend/assets/uploads/admins/modules/contents/download/thumb/'.$old_image);
            }

        } else {
            // No new image uploaded, keep the old one
            $newWebpName = $old_image;
        }

        $data = [
            'id'                => $this->request->getVar('id'),
            'title'             => $this->request->getVar('title'),
            'title_slug'        => url_title($this->request->getVar('title'), '-', true),
            'about_content'     => htmlspecialchars($this->request->getVar('about_content')),
            'latest_changelog'  => htmlspecialchars($this->request->getVar('latest_changelog')),
            'package_name'      => $this->request->getVar('package_name'),
            'version_code'      => $this->request->getVar('version_code'),
            'version_name'      => $this->request->getVar('version_name'),
            'system_requirements'      => $this->request->getVar('system_requirements'),
            'volume'            => $this->request->getVar('volume'),
            'publisher_name'    => $this->request->getVar('publisher_name'),
            'publisher_url'     => $this->request->getVar('publisher_url'),
            'download_url'      => $this->request->getVar('download_url'),
            'description'       => $this->request->getVar('description'),
            'keywords'          => $this->request->getVar('keywords'),
            'tags'              => $this->request->getVar('tags'),
            'tags_slug'         => url_title($this->request->getVar('tags'),'-',true),
            'structure_id'      => $this->request->getVar('structure_id'),
            'category_id'       => $this->request->getVar('category_id'),
            'download_type'     => $this->request->getVar('download_type'),
            'role_id'           => $this->request->getVar('role_id'),
            'allow_comments'    => $allow_comments,
            'allow_reviews'     => $allow_reviews,
            'install_after_downloading' => $install_after_downloading,
            'special'           => $special,
            'featured'          => $featured,
            'dl_after_rewarded_ad' => $dl_after_rewarded_ad,
            'power_ribbon'      => $this->request->getVar('power_ribbon'),
            'status'            => $this->request->getVar('status'),
            'image'             => $newWebpName,
        ];
        $this->contentModel->save($data);

        return redirect()->to(base_url("dashboard/files-list"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }


    //===========================================================//
    public function perform_edit_file_user()
    {
        $old_image = $this->request->getVar('old_image');

        // Validation the form
        $rules = [
            'id'                => 'required|integer',
            'old_image'         => 'required',
            'title'             => 'required|min_length[2]|max_length[100]',
            'title_slug'        => 'required|min_length[2]|max_length[255]',
            'about_content'     => 'required|min_length[2]',
            'latest_changelog'  => 'permit_empty',
            'package_name'      => 'permit_empty',
            'version_code'      => 'required|integer',
            'version_name'      => 'required',
            'system_requirements'      => 'required',
            'volume'            => 'required',
            'publisher_name'    => 'required',
            'publisher_url'     => 'required|valid_url',
            'download_url'      => 'required|valid_url',
            'description'       => 'max_length[255]',
            'keywords'          => 'max_length[255]',
            'tags'              => 'max_length[255]',
            'structure_id'      => 'required|integer',
            'category_id'       => 'required|integer',
            'download_type'     => 'required|integer',
            'role_id'           => 'required|integer',
            'special'           => 'permit_empty',
            'featured'          => 'permit_empty',
            'dl_after_rewarded_ad' => 'permit_empty',
            'allow_comments'    => 'permit_empty',
            'allow_reviews'     => 'permit_empty',
            'install_after_downloading' => 'permit_empty',
            'status'            => 'required',
            'image'             => [
                'ext_in[image,png,jpg,jpeg]',
                'is_image[image]',
                'max_size[image,1024]',
                'max_dims[image,512,512]',
                'errors' => [
                    'max_size' => lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]),
                    'max_dims' => lang('Dashboard.theMaximumWidthAndHeightOfAnUploadedImageShouldBe', [ 512, 512 ]),
                    'ext_in' => lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported')
                ]
            ],
        ];

        // Validate the form
        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        // Flags setup using ternary operator
        $allow_reviews = $this->request->getVar('allow_reviews') === 'on' ? 1 : 0;
        $allow_comments = $this->request->getVar('allow_comments') === 'on' ? 1 : 0;
        $special = $this->request->getVar('special') === 'on' ? 1 : 0;
        $featured = $this->request->getVar('featured') === 'on' ? 1 : 0;
        $dl_after_rewarded_ad = $this->request->getVar('dl_after_rewarded_ad') === 'on' ? 1 : 0;
        $install_after_downloading = $this->request->getVar('install_after_downloading') === 'on' ? 1 : 0;

        $newName = $newWebpName = "file.png";
        $img = $this->request->getFile('image');
        if($img != "") {
            $newName = $img->getRandomName();
            $newNameWithoutExtension = pathinfo($newName, PATHINFO_FILENAME);
            $newWebpName = $newNameWithoutExtension . '.webp';
            $imageExtension = $img->getExtension();
            $img->move('./backend/assets/uploads/admins/modules/contents/download/', $newName);
            $imgPath = $img->getTempName();
            $imgQuality = 85;
            $watermark = "";
            $imgWidth = 512;
            $imgHeight = 512;
            $imgWidthThumbnail = 256;
            $imgHeightThumbnail = 256;

            // Image Process
            helper('image_process');
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension);
            imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, true); // Create thumbnail

            // Remove original image from disk
            if($imageExtension != 'webp')
            {
                @unlink($imgPath . $newName);
                @unlink($imgPath . 'thumb/' . $newName);
            }

            // Remove old image from disk
            if($old_image != 'file.png') {
                @unlink('./backend/assets/uploads/admins/modules/contents/download/'.$old_image);
                @unlink('./backend/assets/uploads/admins/modules/contents/download/thumb/'.$old_image);
            }

        } else {
            // No new image uploaded, keep the old one
            $newWebpName = $old_image;
        }

        $data = [
            'id'                => $this->request->getVar('id'),
            'title'             => $this->request->getVar('title'),
            'title_slug'        => url_title($this->request->getVar('title'), '-', true),
            'about_content'     => htmlspecialchars($this->request->getVar('about_content')),
            'latest_changelog'  => htmlspecialchars($this->request->getVar('latest_changelog')),
            'package_name'      => $this->request->getVar('package_name'),
            'version_code'      => $this->request->getVar('version_code'),
            'version_name'      => $this->request->getVar('version_name'),
            'system_requirements'      => $this->request->getVar('system_requirements'),
            'volume'            => $this->request->getVar('volume'),
            'publisher_name'    => $this->request->getVar('publisher_name'),
            'publisher_url'     => $this->request->getVar('publisher_url'),
            'download_url'      => $this->request->getVar('download_url'),
            'description'       => $this->request->getVar('description'),
            'keywords'          => $this->request->getVar('keywords'),
            'tags'              => $this->request->getVar('tags'),
            'tags_slug'         => url_title($this->request->getVar('tags'),'-',true),
            'structure_id'      => $this->request->getVar('structure_id'),
            'category_id'       => $this->request->getVar('category_id'),
            'download_type'     => $this->request->getVar('download_type'),
            'role_id'           => $this->request->getVar('role_id'),
            'allow_comments'    => $allow_comments,
            'allow_reviews'     => $allow_reviews,
            'install_after_downloading' => $install_after_downloading,
            'special'           => $special,
            'featured'          => $featured,
            'dl_after_rewarded_ad' => $dl_after_rewarded_ad,
            'status'            => $this->request->getVar('status'),
            'image'             => $newWebpName,
        ];
        $this->contentModel->save($data);

        return redirect()->to(base_url("dashboard/files-list-user"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }


    //===========================================================//
    public function downloaded_files()
    {
        $this->contentDownloadedModel = new ContentDownloadedModel();
        $keyword = $_GET['keyword'] ?? '';

        $baseQuery = $this->contentDownloadedModel
            ->select('contents_downloaded_tbl.*, 
                    contents_tbl.title AS file_title, 
                    COALESCE(users_tbl.first_name, "' . lang('Dashboard.notRegistered') . '") AS first_name, 
                    COALESCE(users_tbl.last_name, "") AS last_name, 
                    COALESCE(users_tbl.email, "N/A") AS email, 
                    contents_tbl.title_slug AS file_title_slug, 
                    devices_types_tbl.title AS device_type_title')
            ->join('users_tbl', 'users_tbl.id = contents_downloaded_tbl.user_id AND contents_downloaded_tbl.user_id != 0', 'left')
            ->join('contents_tbl', 'contents_tbl.id = contents_downloaded_tbl.content_id')
            ->join('devices_types_tbl', 'devices_types_tbl.id = contents_downloaded_tbl.device_type_id')
            ->orderBy('contents_downloaded_tbl.id', 'DESC');

        if (!empty($keyword)) {
            $baseQuery
                ->groupStart()
                    ->like('users_tbl.first_name', $keyword)
                    ->orLike('users_tbl.last_name', $keyword)
                    ->orLike('users_tbl.email', $keyword)
                    ->orLike('contents_tbl.title', $keyword)
                    ->orLike('devices_types_tbl.title', $keyword)
                    ->orLike('contents_downloaded_tbl.ip', $keyword)
                ->groupEnd();
        }

        $data = [
            'downloadedFiles' => $baseQuery->paginate(20),
            'pager' => $this->contentDownloadedModel->pager,
            'pageTitle' => lang('Dashboard.downloadedFiles'),
            'pageSubTitle' => lang('Dashboard.downloadedFiles'),
        ];

        return view('\Modules\Addons\Contents\Views\backend\contents\downloaded_files_view', $data);
    }


    //===========================================================//
    public function contents_reviews_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.approved', 'ASC')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(20),
                'pager' => $this->contentReviewModel->pager
            ];

        }else{
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->groupStart()
                        ->like('contents_reviews_tbl.title', $keyword)
                        ->orLike('contents_reviews_tbl.description', $keyword)
                        ->orLike('contents_reviews_tbl.author_ip', $keyword)
                        ->orLike('contents_tbl.title', $keyword)
                        ->orGroupStart()
                            ->like('users_tbl.first_name', $keyword)
                            ->orLike('users_tbl.last_name', $keyword)
                        ->groupEnd()
                    ->groupEnd()
                    ->orderBy('contents_reviews_tbl.approved', 'ASC')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(20),
                'pager' => $this->contentReviewModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.usersReviews');
        $data['pageSubTitle'] = lang('Dashboard.usersReviewsList');
        return view('\Modules\Addons\Contents\Views\backend\contents\contents_reviews_list_view', $data);
    }


    //===========================================================//
    public function deleted_contents_reviews_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.approved', 'ASC')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->onlyDeleted()
                    ->paginate(20),
                'pager' => $this->contentReviewModel->pager
            ];

        }else{
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->groupStart()
                        ->like('contents_reviews_tbl.title', $keyword)
                        ->orLike('contents_reviews_tbl.description', $keyword)
                        ->orLike('contents_reviews_tbl.author_ip', $keyword)
                        ->orLike('contents_tbl.title', $keyword)
                        ->orGroupStart()
                            ->like('users_tbl.first_name', $keyword)
                            ->orLike('users_tbl.last_name', $keyword)
                        ->groupEnd()
                    ->groupEnd()
                    ->orderBy('contents_reviews_tbl.approved', 'ASC')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->onlyDeleted()
                    ->paginate(20),
                'pager' => $this->contentReviewModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.deletedUsersReviews');
        $data['pageSubTitle'] = lang('Dashboard.deletedUsersReviewsList');
        return view('\Modules\Addons\Contents\Views\backend\contents\deleted_contents_reviews_list_view', $data);
    }


    //===========================================================//
    public function perform_approve_unapprove_contents_reviews()
    {
        $rules = [
            'review_id'  	=> 'required',
            'approved'  	=> 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            $errors = ['errors', $this->validator->getErrors()];
            json_encode($errors);
            echo lang('Frontend.pleaseFillAllRequiredFieldsCorrectly');
            die();
        }

        // Valid submission
        $review_id = $this->request->getPost('review_id');
        $approved = $this->request->getPost('approved'); // 0: No | 1: Yes

        // Check review exist
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            echo lang('Dashboard.notFound');
            die();
        }

        if($approved != 1) {
            $newData = [
                'id'           => $review_id,
                'approved'     => 1,
            ];
            $this->contentReviewModel->save($newData);
            echo lang('Dashboard.reviewApprovedSuccessfully');

        }else{
            $newData = [
                'id'           => $review_id,
                'approved'     => 0,
            ];
            $this->contentReviewModel->save($newData);
            echo lang('Dashboard.reviewUnapprovedSuccessfully');
        }

        // Check user sent review before
        /*$old_review_id = $data['review']->id;
        $user_id = $data['review']->user_id;
        $content_id = $data['review']->content_id;
        $data['reviewBefore'] = $this->contentReviewModel->where('user_id', $user_id)->where('content_id', $content_id)->where('approved', 1)->first();
        if(is_null($data['reviewBefore']))
        {
            // First review
            if($approved == 0) {
                $newData = [
                    'id'           => $review_id,
                    'approved'     => 1,
                ];
                $this->contentReviewModel->save($newData);
                echo lang('Dashboard.reviewApprovedSuccessfully');

            }else{
                $newData = [
                    'id'           => $review_id,
                    'approved'     => 0,
                ];
                $this->contentReviewModel->save($newData);
                echo lang('Dashboard.reviewUnapprovedSuccessfully');
            }

        }/*else{
            // The old review was exist. Unapprove old review
            $newData1 = [
                'id'           => $review_id,
                'approved'     => 1,
            ];
            $this->contentReviewModel->save($newData1);

            // Approve new review
            $newData2 = [
                'id'           => $data['reviewBefore']->id,
                'approved'     => 0,
            ];
            $this->contentReviewModel->save($newData2);

            echo lang('Dashboard.oldReviewUnapprovedAndNewReviewApprovedSuccessfully');
        }*/
        
    }


    //===========================================================//
    public function delete_contents_review()
    {
        // Check review exist
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        $newData = [
            'id'           => $review_id,
            'approved'     => 0,
        ];
        $this->contentReviewModel->save($newData);

        // softDelete
        $this->contentReviewModel->delete($review_id);
        return redirect()->to(base_url('dashboard/contents-reviews-list/'))->withInput()->with('success', lang('Dashboard.dataDeletedSuccessfully'));
    }


    //===========================================================//
    public function restore_contents_review()
    {
        // Check review exist
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        $this->contentReviewModel->set('deleted_at', NULL);
        $this->contentReviewModel->where('id', $review_id);
        $this->contentReviewModel->update();

        return redirect()->to(base_url('dashboard/deleted-contents-reviews-list/'))->withInput()->with('success', lang('Dashboard.reviewRestoredSuccessfully'));
    }


    //===========================================================//
    public function hard_delete_contents_review()
    {
        // Check review exist
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        // hardDelete
        $this->contentReviewModel->delete($review_id);

        $db = db_connect();
        $builder = $db->table('contents_reviews_tbl');
        $builder->delete(['id' => $review_id]);
        $db->close();

        return redirect()->to(base_url('dashboard/deleted-contents-reviews-list/'))->withInput()->with('success', lang('Dashboard.dataDeletedSuccessfully'));
    }


    //===========================================================//
    public function edit_contents_review()
    {
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->select('contents_reviews_tbl.*')->where('contents_reviews_tbl.id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));

        $data['pageTitle'] = lang('Dashboard.editReview');
        $data['pageSubTitle'] = lang('Dashboard.editReview');
        return view('\Modules\Addons\Contents\Views\backend\contents\edit_contents_review_view', $data);
    }


    //===========================================================//
    public function perform_edit_contents_review()
    {
        $review_id = $this->request->getVar('review_id');
        // Validation the form
        $rules = [
            'review_id'     => 'required|integer',
            'title'         => 'required|min_length[2]|max_length[60]',
            'description'   => 'required|min_length[2]|max_length[1000]',
            'rating'        => 'required|integer',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/edit-contents-review/$review_id"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $data = [
            'id'            => $this->request->getVar('review_id'),
            'title'         => $this->request->getVar('title'),
            'description'   => $this->request->getVar('description'),
            'rating'        => $this->request->getVar('rating'),
        ];
        $this->contentReviewModel->save($data);

        return redirect()->to(base_url("dashboard/edit-contents-review/$review_id"))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }


    //===========================================================//
    public function pending_contents_reviews_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reviews_tbl.approved', 2)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];

        }else{
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->like('contents_reviews_tbl.title', $keyword)
                    ->orLike('contents_reviews_tbl.description', $keyword)
                    ->orLike('contents_reviews_tbl.author_ip', $keyword)
                    ->where('contents_reviews_tbl.approved', 2)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.usersReviews');
        $data['pageSubTitle'] = lang('Dashboard.pendingReviews');
        return view('\Modules\Addons\Contents\Views\backend\contents\pending_contents_reviews_view', $data);
    }


    //===========================================================//
    public function approved_contents_reviews_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reviews_tbl.approved', 1)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];

        }else{
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->like('contents_reviews_tbl.title', $keyword)
                    ->orLike('contents_reviews_tbl.description', $keyword)
                    ->orLike('contents_reviews_tbl.author_ip', $keyword)
                    ->where('contents_reviews_tbl.approved', 1)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.usersReviews');
        $data['pageSubTitle'] = lang('Dashboard.approvedReviews');
        return view('\Modules\Addons\Contents\Views\backend\contents\approved_contents_reviews_view', $data);
    }


    //===========================================================//
    public function unapproved_contents_reviews_list()
    {
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reviews_tbl.approved', 0)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];

        }else{
            $data = [
                'contentsReviews' => $this->contentReviewModel
                    ->select('contents_reviews_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->like('contents_reviews_tbl.title', $keyword)
                    ->orLike('contents_reviews_tbl.description', $keyword)
                    ->orLike('contents_reviews_tbl.author_ip', $keyword)
                    ->where('contents_reviews_tbl.approved', 0)
                    ->join('users_tbl', 'users_tbl.id = contents_reviews_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reviews_tbl.content_id')
                    ->orderBy('contents_reviews_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReviewModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.usersReviews');
        $data['pageSubTitle'] = lang('Dashboard.unapprovedReviews');
        return view('\Modules\Addons\Contents\Views\backend\contents\unapproved_contents_reviews_view', $data);
    }


    //===========================================================//
    public function approve_contents_review()
    {
        // Check review exist
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        // Check user sent review before
        $old_review_id = $data['review']->id;
        $user_id = $data['review']->user_id;
        $content_id = $data['review']->content_id;
        $data['reviewBefore'] = $this->contentReviewModel->where('user_id', $user_id)->where('content_id', $content_id)->where('approved', 1)->first();
        if(is_null($data['reviewBefore']))
        {
            // First review
            $newData = [
                'id'           => $review_id,
                'approved'     => 1,
            ];
            $this->contentReviewModel->save($newData);

            return redirect()->back()->with('success', lang('Dashboard.reviewApprovedSuccessfully'));

        }else{
            // The old review was exist. Unapprove old review
            $newData1 = [
                'id'           => $review_id,
                'approved'     => 1,
            ];
            $this->contentReviewModel->save($newData1);

            // Approve new review
            $newData2 = [
                'id'           => $data['reviewBefore']->id,
                'approved'     => 0,
            ];
            $this->contentReviewModel->save($newData2);

            return redirect()->back()->with('success', lang('Dashboard.oldReviewUnapprovedAndNewReviewApprovedSuccessfully'));
        }
    }


    //===========================================================//
    public function unapproved_contents_review()
    {
        // Check review exist
        $review_id = service('uri')->getSegment(3);
        $data['review'] = $this->contentReviewModel->where('id', $review_id)->withDeleted()->first();
        if(is_null($data['review']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        $newData = [
            'id'           => $review_id,
            'approved'     => 0,
        ];
        $this->contentReviewModel->save($newData);

        return redirect()->back()->with('error', lang('Dashboard.reviewUnapproved'));
    }


    //===========================================================//
    public function not_checked_report()
    {
        $this->contentReportModel = new ContentReportModel();

        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReports' => $this->contentReportModel
                    ->select('contents_reports_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reports_tbl.status', 0)
                    ->join('users_tbl', 'users_tbl.id = contents_reports_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reports_tbl.content_id')
                    ->orderBy('contents_reports_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReportModel->pager
            ];

        }else{
            $data = [
                'contentsReports' => $this->contentReportModel
                    ->select('contents_reports_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reports_tbl.status', 0)
                    ->like('contents_reports_tbl.report_abuse', $keyword)
                    ->orLike('contents_tbl.title', $keyword)
                    ->orLike('contents_reports_tbl.author_ip', $keyword)
                    ->join('users_tbl', 'users_tbl.id = contents_reports_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reports_tbl.content_id')
                    ->orderBy('contents_reports_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReportModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.reportsAbuse');
        $data['pageSubTitle'] = lang('Dashboard.notChecked');
        return view('\Modules\Addons\Contents\Views\backend\contents\reports\not_checked_report_view', $data);
    }


    //===========================================================//
    public function checked_report()
    {
        $this->contentReportModel = new ContentReportModel();

        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'contentsReports' => $this->contentReportModel
                    ->select('contents_reports_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->where('contents_reports_tbl.status', 1)
                    ->join('users_tbl', 'users_tbl.id = contents_reports_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reports_tbl.content_id')
                    ->orderBy('contents_reports_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReportModel->pager
            ];

        }else{
            $data = [
                'contentsReports' => $this->contentReportModel
                    ->select('contents_reports_tbl.*, users_tbl.first_name AS first_name, users_tbl.last_name AS last_name, contents_tbl.title AS content_title')
                    ->like('contents_reports_tbl.report_abuse', $keyword)
                    ->orLike('contents_tbl.title', $keyword)
                    ->orLike('contents_reports_tbl.author_ip', $keyword)
                    ->where('contents_reports_tbl.status', 1)
                    ->join('users_tbl', 'users_tbl.id = contents_reports_tbl.user_id')
                    ->join('contents_tbl', 'contents_tbl.id = contents_reports_tbl.content_id')
                    ->orderBy('contents_reports_tbl.id', 'DESC')
                    ->paginate(10),
                'pager' => $this->contentReportModel->pager
            ];
        }

        $data['pageTitle'] = lang('Dashboard.reportsAbuse');
        $data['pageSubTitle'] = lang('Dashboard.checked');
        return view('\Modules\Addons\Contents\Views\backend\contents\reports\checked_report_view', $data);
    }


    //===========================================================//
    public function check_the_report()
    {
        $this->contentReportModel = new ContentReportModel();

        // Check review exist
        $report_id = service('uri')->getSegment(3);
        $data['report'] = $this->contentReportModel->where('id', $report_id)->withDeleted()->first();
        if(is_null($data['report']))
        {
            return redirect()->back()->with('error', lang('Dashboard.notFound'));
        }

        $newData = [
            'id'           => $report_id,
            'status'     => 1,
        ];
        $this->contentReportModel->save($newData);

        return redirect()->back()->with('success', lang('Dashboard.reportCheckedSuccessfully'));
    }
}
