<?php
// Api
$routes->group("api-contents", ["namespace" => "\Modules\Addons\Contents\Controllers\Api"], function($routes){
    $routes->group("", function($routes){
        $routes->post("get-all-files", "ApiContentController::get_all_files");
        $routes->post("get-files-by-category", "ApiContentController::get_files_by_category");
        $routes->post("get-special-files", "ApiContentController::get_special_files");
        $routes->post("get-featured-files", "ApiContentController::get_featured_files");
        $routes->post("get-files-by-search", "ApiContentController::get_files_by_search");
        $routes->post("get-one-file", "ApiContentController::get_one_file");
        $routes->post("get-images-gallery", "ApiContentController::get_images_gallery");
        $routes->post("views-plus-one", "ApiContentController::views_plus_one");
        $routes->post("downloads-plus-one", "ApiContentController::downloads_plus_one"); // Not use. Instead use the bellow "dl-clicked" function.
        $routes->post("insert-or-update-contents-downloaded", "ApiContentController::insert_or_update_contents_downloaded");
        $routes->get("dl-clicked/(:num)", "ApiContentController::dl_clicked/$1");

        $routes->post("add-review", "ApiContentController::add_review");
        $routes->post("get-reviews", "ApiContentController::get_reviews");
        $routes->post("send-report-abuse", "ApiContentController::send_report_abuse");

        $routes->post("get-bookmarks", "ApiContentController::get_bookmarks");
        $routes->post("bookmark-status", "ApiContentController::bookmark_status");
        $routes->post("add-to-bookmark", "ApiContentController::add_to_bookmark");
        $routes->post("remove-from-bookmark", "ApiContentController::remove_from_bookmark");
    });
});

// Backend
$routes->group("dashboard", ["namespace" => "\Modules\Addons\Contents\Controllers\Backend", "filter" => "auth"], function($routes){
    $routes->get("files-list", "ContentController::files_list");
    $routes->get("files-list-pending", "ContentController::files_list_pending");
    $routes->get("files-list-user", "ContentController::files_list_user");
    $routes->get("add-app-file", "ContentController::add_app_file");
    $routes->get("add-app-file-user", "ContentController::add_app_file_user");
    $routes->get("add-game-file", "ContentController::add_game_file");
    $routes->get("add-game-file-user", "ContentController::add_game_file_user");
    $routes->post("perform-add-file", "ContentController::perform_add_file");
    $routes->post("perform-add-file-user", "ContentController::perform_add_file_user");
    $routes->get("edit-app-file/(:num)", "ContentController::edit_app_file/$1");
    $routes->get("edit-app-file-user/(:num)", "ContentController::edit_app_file_user/$1");
    $routes->get("edit-game-file/(:num)", "ContentController::edit_game_file/$1");
    $routes->get("edit-game-file-user/(:num)", "ContentController::edit_game_file_user/$1");
    $routes->post("perform-edit-file", "ContentController::perform_edit_file");
    $routes->post("perform-edit-file-user", "ContentController::perform_edit_file_user");
    $routes->get("delete-file/(:num)", "ContentController::delete_file/$1");
    $routes->get('downloaded-files', 'ContentController::downloaded_files');
	
	$routes->get("images-gallery/(:num)", "ContentController::images_gallery/$1");
    $routes->post("perform-add-images-gallery", "ContentController::perform_add_images_gallery");
    $routes->get("delete-images-gallery/(:num)", "ContentController::delete_images_gallery/$1");

    $routes->get('contents-reviews-list', 'ContentController::contents_reviews_list');
    $routes->get('deleted-contents-reviews-list', 'ContentController::deleted_contents_reviews_list');
    $routes->post('perform-approve-unapprove-contents-reviews', 'ContentController::perform_approve_unapprove_contents_reviews');
    $routes->get('delete-contents-review/(:num)', 'ContentController::delete_contents_review/$1');
    $routes->get('restore-contents-review/(:num)', 'ContentController::restore_contents_review/$1');
    $routes->get('hard-delete-contents-review/(:num)', 'ContentController::hard_delete_contents_review/$1');
    $routes->get('edit-contents-review/(:num)', 'ContentController::edit_contents_review/$1');
    $routes->post('perform-edit-contents-review', 'ContentController::perform_edit_contents_review');

    /*$routes->get('pending-contents-reviews-list', 'ContentController::pending_contents_reviews_list');
    $routes->get('approved-contents-reviews-list', 'ContentController::approved_contents_reviews_list');
    $routes->get('unapproved-contents-reviews-list', 'ContentController::unapproved_contents_reviews_list');
    $routes->get('approve-contents-review/(:num)', 'ContentController::approve_contents_review/$1');
    $routes->get('unapproved-contents-review/(:num)', 'ContentController::unapproved_contents_review/$1');*/

    $routes->get('not-checked-report', 'ContentController::not_checked_report');
    $routes->get('checked-report', 'ContentController::checked_report');
    $routes->get('check-the-report/(:num)', 'ContentController::check_the_report/$1');
});

// Frontend
$routes->get('android-apps', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::android_apps');
$routes->get('android-games', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::android_games');
$routes->get('file-details/(:num)/(:any)', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::file_details/$1/$2');
$routes->get('file', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::file'); /* For Deep Link */
$routes->get('dl-clicked/(:num)/(:any)', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::dl_clicked/$1/$2');
$routes->post('add-review', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::add_review');
$routes->get('bookmarks', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::bookmarks');
$routes->get('add-to-bookmark/(:num)', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::add_to_bookmark/$1');
$routes->get('remove-from-bookmark/(:num)', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::remove_from_bookmark/$1');

$routes->get('files-category/(:num)/(:num)/(:any)', '\Modules\Addons\Contents\Controllers\Frontend\ContentController::files_category/$1/$2/$3');


?>