<?php
$this->session = session();
$locale = $this->session->lang;
$user_id = $this->session->id;
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.wallet') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-4">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <!--<form class="form-horizontal" data-form-type="add_funds" data-action="<?= base_url('dashboard/perform-add-funds') ?>">-->
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-add-funds') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="amount" class="col-sm-3 col-form-label"><?= lang('Dashboard.amount') ?> *</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="number" name="amount" id="amount" dir="ltr" class="form-control" required>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"><?= $currenciesData->suffix ?></span>
                                                </div>
                                            </div>
                                            <?php
                                            $min_amount = number_format(100000, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                            $max_amount = number_format(90000000, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                            ?>
                                            <small class="text-info d-none"><?= lang('Dashboard.addFundsMinimumXandMaximumY', [$min_amount, $max_amount]) ?></small>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row mb-3">
                                        <label for="payment_gateway" class="col-sm-3 col-form-label"><?= lang('Dashboard.paymentGateway') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="payment_gateway" id="payment_gateway" required>
                                                <?php
                                                foreach($paymentGateways as $paymentGateway)
                                                {
                                                ?>
                                                <option value="<?= $paymentGateway->id . "|" . $paymentGateway->title ?>"><?= $paymentGateway->description ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row mb-3 d-none" id="cryptoCurrencyCodeContainer">
                                        <label for="pay_currency_code" class="col-sm-3 col-form-label"><?= lang('Dashboard.CryptoCurrency') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="pay_currency_code" id="pay_currency_code">
                                                <?php
                                                foreach($currencies as $currency)
                                                {
                                                ?>
                                                <option value="<?= htmlspecialchars($currency) ?>"><?= htmlspecialchars(ucfirst($currency)) ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                            <?php
                                            $minCryptoCurrency = number_format(30 * getenv('USD_RATE'), $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix
                                            ?>
                                            <small class="text-info"><?= lang('Dashboard.paymentWithDigitalCurrencyIncludes0Fee', [10]) ?></small>
                                        </div>
                                    </div>

                                    <input type="hidden" name="currency_code" id="currency_code" value="<?= $currenciesData->currency_code ?>" readonly required>
                                    <input type="hidden" name="wallet_id" id="wallet_id" value="<?= $walletData->id ?>" readonly required>

                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="terms" id="terms" type="checkbox"> <?= lang('Dashboard.IAgreeToTheTermsOfService', [$settingsData->terms_url]) ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                ?>
                                    <button type="submit" id="submitButton" onclick="return document.getElementById('terms').checked ? true : (Swal.fire({
                                                                                        /*title: '<?= lang('Dashboard.error') ?>',*/
                                                                                        text: '<?= lang('Dashboard.youShouldAcceptTermsOfCondition') ?>',
                                                                                        icon: 'error',
                                                                                        showCloseButton: true,
                                                                                        showConfirmButton: false
                                                                                        }), false)" 
                                            class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.addFunds') ?>"><?= lang('Dashboard.addFunds') ?>
                                    </button>
                                <?php
                                }else{
                                ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.addFunds') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-8">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.transactions') ?> (<?= lang('Dashboard.walletBalance') ?>: <b><span class="text-success"><?= $currenciesData->prefix ?> <?= number_format($walletData->credit, $currenciesData->decimals, '.', ','); ?> <?= $currenciesData->suffix ?></span></b>)</h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/wallet') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-sm table-striped table-hover text-nowrap small">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.orderId') ?></th>
                                        <th><?= lang('Dashboard.gateway') ?></th>
                                        <th><?= lang('Dashboard.amount') ?> (<?= $currenciesData->suffix ?>)</th>
                                        <th><?= lang('Dashboard.transactionTracking') ?></th>
                                        <th><?= lang('Dashboard.description') ?></th>
                                        <th><?= lang('Dashboard.date') ?></th>
                                        
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($walletTransactions as $walletTransaction)
                                    {
                                        if($walletTransaction->transaction_type == "credit")
                                            $text_color = "text-success";
                                        else if($walletTransaction->transaction_type == "debit")
                                            $text_color = "text-danger";
                                        if($walletTransaction->transaction_tracking == null)
                                            $text_color = "text-gray";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $walletTransaction->order_id ?></td>
                                            <td class="align-middle"><?= $walletTransaction->payment_gateway_description ?></td>
                                            <td class="align-middle <?= $text_color ?>"><?= $currenciesData->prefix ?> <?= number_format($walletTransaction->amount, $currenciesData->decimals, '.', ','); ?></td>
                                            <td class="align-middle"><?= $walletTransaction->transaction_tracking ?? "<span class='text-gray small'>" . lang('Dashboard.unsuccessful') . "</span>" ?></td>
                                            <td class="align-middle"><?= $walletTransaction->description ?></td>
                                            <td class="align-middle">
                                                <?php
                                                if($settingsData->calendar_type == "jDate")
                                                {
                                                    $transaction_date = $jdf->jdate('Y/m/d G:i', $walletTransaction->transaction_date, '', $settingsData->timezone);
                                                }else{
                                                    $transaction_date = Time::createFromTimestamp($walletTransaction->transaction_date, $settingsData->timezone, 'en_US');
                                                }
                                                ?>
                                                <?= $transaction_date ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($walletTransactions)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                                
                            </div>
                            <!-- /.card-body -->
                            
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const paymentGatewaySelect = document.getElementById('payment_gateway');
        const cryptoCurrencyCodeContainer = document.getElementById('cryptoCurrencyCodeContainer');

        function toggleCurrencySelect() {
            const selectedValue = paymentGatewaySelect.value;
            if (selectedValue.includes("NowPayments")) {
                cryptoCurrencyCodeContainer.classList.remove('d-none'); // Show the currency select
            } else {
                cryptoCurrencyCodeContainer.classList.add('d-none'); // Hide the currency select
            }
        }

        // Initial check in case a value is already selected
        toggleCurrencySelect();

        // Add event listener for change events
        paymentGatewaySelect.addEventListener('change', toggleCurrencySelect);
    });
</script> 
<?= $this->endSection() ?>