<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/users-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.fullName') ?></th>
                                        <th><?= lang('Dashboard.email') ?></th>
                                        <th><?= lang('Dashboard.mobile') ?></th>
                                        <th><?= lang('Dashboard.role') ?></th>
                                        <th><?= lang('Dashboard.device') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($users as $user)
                                    {
                                        $status = "<span class='badge badge-warning'>".$user->status_title."</span>";
                                        if($user->status_id == 1) $status = "<span class='center badge badge-success'>".$user->status_title."</span>";
                                        if($user->status_id == 2) $status = "<span class='center badge badge-warning'>".$user->status_title."</span>";
                                        if($user->status_id == 3) $status = "<span class='center badge badge-dark'>".$user->status_title."</span>";
                                        if($user->status_id == 4) $status = "<span class='center badge badge-info'>".$user->status_title."</span>";
                                        ?>
                                        <tr>
                                            <td><a href="<?= base_url('dashboard/user-profile/'.$user->id) ?>"><?= $user->first_name." ".$user->last_name; ?></a></td>
                                            <td><?= $user->email ?></td>
                                            <td><?= $user->mobile; ?></td>
                                            <td><?= $user->role_title; ?></td>
                                            <td><?= $user->device_type_title; ?></td>
                                            <td><?= $status ?></td>
                                            <td style="width: 118px;">
                                                <a title="<?= lang('Dashboard.show') ?>" href="<?= base_url('dashboard/user-profile/'.$user->id) ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>
                                                <a title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/user-profile/'.$user->id.'?active_tab=settings') ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>
                                                <a title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-user/'.$user->id); ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" class="text-danger p-1">&nbsp;<i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($users)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>