<?php
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
$session = session();
$encrypter = \Config\Services::encrypter();

$status_color = "success";
if(isset($user->deleted_at))
    $status_color = "danger";
elseif($user->status_id == 1)
    $status_color = "success";
elseif($user->status_id == 2)
    $status_color = "warning";
elseif($user->status_id == 3)
    $status_color = "gray";
elseif($user->status_id == 4)
    $status_color = "info";
elseif($user->status_id == 5)
    $status_color = "warning";


$api_key = bin2hex(random_bytes(16));
$api_id = $api_read = $api_write = $api_status = "";
if(isset($api->api_key))
{
   $api_id = $api->id;
   $api_key = $api->api_key;
   $api_key = $encrypter->decrypt(base64_decode($api_key));
   $api_read = $api->read;
   $api_write = $api->write;
   $api_status = $api->status;
}
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<?php
$active_tab = "";
if(isset($_GET['active_tab']))
    $active_tab = $_GET['active_tab'];
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-3">

                        <!-- Profile Image -->
                        <div class="card card-<?= $status_color ?> card-outline">
                            <div class="card-body box-profile">
                                <div class="text-center">
                                    <img class="profile-user-img img-fluid img-circle"
                                         src="<?= base_url('backend/assets/uploads/users/profile/thumb/'.$user->image) ?>"
                                         alt="User profile picture">
                                </div>

                                <h3 class="profile-username text-center"><?= $user->first_name." ".$user->last_name ?></h3>

                                <p class="text-muted text-center"><?= $user->email ?></p>

                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.status') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><span class='center badge badge-<?=$status_color?>'><?= $user->status_title ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <b><?= $userWallets[0]->title ?? 'Wallet' ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= number_format($userCredit, $userCurrency->decimals ?? 2, '.', ','); ?> <?= $userCurrency->suffix ?? '' ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.userRole') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $user->role_title ?></span>
                                    </li>
                                    <?php
                                    if($user->role_id == 11 && $user->vip_role_expiry_at != null)
                                    {
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.remainingDaysUntilTheVIPUserExpires') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $daysRemaining ?> <?= lang('Dashboard.days') ?></span>
                                    </li>
                                    <?php
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.deviceType') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $user->device_type_title; ?></span>
                                    </li>
                                    <?php
                                    $last_login = lang('Dashboard.notYetEntered');
                                    if(isset($user->last_login))
                                    {
                                        if($settingsData->calendar_type == "jDate")
                                        {
                                            $last_login = $jdf->jdate('Y/m/d G:i', $user->last_login, '', $settingsData->timezone);
                                        }else{
                                            $last_login = Time::createFromTimestamp($user->last_login, $settingsData->timezone, 'en_US');
                                        }
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.lastLogin') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $last_login; ?></span>
                                    </li>
                                    <?php
                                    if($settingsData->calendar_type == "jDate")
                                    {
                                        $member_since = $jdf->jdate('Y/m/d G:i', $user->created_at, '', $settingsData->timezone);
                                    }else{
                                        $member_since = Time::createFromTimestamp($user->created_at, $settingsData->timezone, 'en_US');
                                    }
                                    ?>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.memberSince') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $member_since; ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <?php
                                        $ip = $user->last_login_ip;
                                        if($theRoleID == 9)
                                            $ip = "xx.xx.xx.xx";
                                        ?>
                                        <b><?= lang('Dashboard.lastIP') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $ip ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <b><?= lang('Dashboard.lastAgent') ?></b> <span class="<?= lang('Dashboard.float-xxx') ?>"><?= $user->last_login_agent; ?></span>
                                    </li>
                                </ul>
                                
                                <a href="<?= base_url("dashboard/send-ticket/$user->id") ?>" class="btn btn-primary btn-block"><b><?= lang('Dashboard.sendTicket') ?></b></a>

                                <?php
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    if(! isset($user->deleted_at))
                                    {
                                    ?>
                                    <a href="<?= base_url("dashboard/delete-user/$user->id") ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" class="btn btn-danger btn-block"><b><?= lang('Dashboard.deleteAccount') ?></b></a>
                                    <?php
                                    }else{
                                        echo "<div class='alert alert-danger'><strong>".lang('Dashboard.thisUserHasAlreadyBeenSoftDeleted')."</strong></div>";
                                    }
                                }else{
                                    ?>
                                    <button disabled href="#" onclick="return alert('<?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?>');" class="btn btn-danger btn-block"><b><?= lang('Dashboard.deleteAccount') ?></b></button>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                    <div class="col-md-9">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <div class="card">
                            <div class="card-header p-2">
                                <ul class="nav nav-pills">
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "") echo "active"; ?>" href="#activity" data-toggle="tab"><?= lang('Dashboard.activity') ?></a></li>
                                    <?php
                                    if($role_id <= 2) {
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "withdrawal_deposit") echo "active"; ?>" href="#withdrawal_deposit" data-toggle="tab"><?= lang('Dashboard.withdrawalDeposit') ?></a></li>
                                    <?php
                                    }
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "settings") echo "active"; ?>" href="#settings" data-toggle="tab"><?= lang('Dashboard.settings') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "change_password") echo "active"; ?>" href="#change_password" data-toggle="tab"><?= lang('Dashboard.changePassword') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "change_image") echo "active"; ?>" href="#change_image" data-toggle="tab"><?= lang('Dashboard.changeImage') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "downloaded") echo "active"; ?>" href="#downloaded" data-toggle="tab"><?= lang('Dashboard.downloaded') ?></a></li>
                                    <li class="nav-item d-none"><a class="nav-link <?php if($active_tab == "devices_info") echo "active"; ?>" href="#devices_info" data-toggle="tab"><?= lang('Dashboard.devicesInfo') ?></a></li>
                                    <?php
                                    if($user->api_key_access != 0)
                                    {
                                    ?>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "api_key") echo "active"; ?>" href="#api_key" data-toggle="tab"><?= lang('Dashboard.apiKey') ?></a></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </div><!-- /.card-header -->
                            <div class="card-body">
                                <div class="tab-content">
                                    <div class="<?php if($active_tab == "") echo "active"; ?> tab-pane" id="activity">

                                        <!-- The timeline -->
                                        <div class="timeline timeline-inverse">
                                            <!-- timeline time label -->
                                            <div class="time-label">
                                        <span class="bg-warning">
                                          <?php
                                          if ($settingsData->calendar_type == "jDate") {
                                              echo $today = $jdf->jdate('Y/m/d', now(), '', $settingsData->timezone);
                                          } else {
                                              $today = Time::createFromTimestamp(now(), $settingsData->timezone, 'en_US');
                                              echo $today->getYear()."/".$today->getMonth()."/".$today->getDay();
                                          }
                                          ?>
                                        </span>
                                            </div>
                                            <!-- /.timeline-label -->

                                            <!-- timeline item -->
                                            <?php
                                            foreach ($activities as $activity)
                                            {
                                            ?>
                                                <div>
                                                    <i class="<?= $activity->icon ?> <?= $activity->background ?>"></i>
                                                    <div class="timeline-item">
                                                        <span class="time"><i class="far fa-clock"></i> <?= timespan($activity->time, now(), 2)." ".lang('Date.ago'); //date('Y/m/d H:i:s', $activity->time) ?></span>
                                                        <h3 class="timeline-header"><?= $activity->title ?></h3>
                                                        <div class="timeline-body"><?= $activity->body ?></div>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                            <!-- END timeline item -->

                                            <div>
                                                <i class="far fa-clock bg-gray"></i>
                                            </div>
                                        </div>
                                        <div class="px-2"><?= $activities_pager->Links('activities') ?></div>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <?php
                                    if($role_id <= 2) {
                                    ?>
                                    <div class="<?php if($active_tab == "withdrawal_deposit") echo "active"; ?> tab-pane" id="withdrawal_deposit">

                                        <div class="row">
                                            <div class="col-6">
                                                <p class="text-success"><b><?= lang('Dashboard.addFundsToUserWallet') ?></b><br><br></p>
                                                <form class="form-horizontal" data-form-type="add_funds_to_user_wallet" data-action="<?= base_url('dashboard/perform-add-funds-to-user-wallet') ?>">
                                                    <?= csrf_field() ?>
                                                    <div class="form-group row">
                                                        <label for="amount" class="col-sm-3 col-form-label"><?= lang('Dashboard.amount') ?> *</label>
                                                        <div class="col-sm-8">
                                                            <div class="input-group">
                                                                <input type="number" name="amount" id="amount" dir="ltr" class="form-control" required>
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text"><?= $currenciesData->suffix ?></span>
                                                                </div>
                                                            </div>
                                                            <?php
                                                            $min_amount = number_format(1, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                                            $max_amount = number_format(90000000, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                                            ?>
                                                            <small class="text-info d-none"><?= lang('Dashboard.addFundsMinimumXandMaximumY', [$min_amount, $max_amount]) ?></small>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="form-group row">
                                                        <label for="wallet_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.wallet') ?> *</label>
                                                        <div class="col-sm-8">
                                                            <select class="form-control" name="wallet_id" id="wallet_id" required>
                                                                <?php
                                                                foreach($userWallets as $userWallet)
                                                                {
                                                                ?>
                                                                <option value="<?= $userWallet->id ?>"><?= $userWallet->title ?></option>
                                                                <?php
                                                                }
                                                                ?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-group row">
                                                        <div class="offset-sm-3 col-sm-9">
                                                            <div class="checkbox">
                                                                <label>
                                                                    <input name="iam_sure" id="iam_sure" type="checkbox"> <?= lang('Dashboard.iamSureOfAddingFundsToTheXWallet', [$user->first_name .' '. $user->last_name]) ?>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <input type="hidden" name="app_name" id="app_name" value="<?= $settingsData->app_name ?>" readonly required>
                                                    <input type="hidden" name="user_id" id="user_id" value="<?= $user->id ?>" readonly required>
                                                    <input type="hidden" name="user_full_name" id="user_full_name" value="<?= $user->first_name .' '. $user->last_name ?>" readonly required>
                                                    <input type="hidden" name="user_email" id="user_email" value="<?= $user->email ?>" readonly required>
                                                    <input type="hidden" name="currency_decimals" id="currency_decimals" value="<?= $userCurrency->decimals ?>" readonly required>
                                                    <input type="hidden" name="currency_suffix" id="currency_suffix" value="<?= $userCurrency->suffix ?>" readonly required>

                                                    <div class="form-group row">
                                                        <div class="offset-sm-3 col-sm-8">
                                                            <?php
                                                            $role_id = $session->role_id;
                                                            if($role_id != 9 AND $role_id != 19)
                                                            {
                                                                ?>
                                                                <button type="submit" id="submitButton" onclick="return document.getElementById('iam_sure').checked ? true : (Swal.fire({
                                                                                                /*title: '<?= lang('Dashboard.error') ?>',*/
                                                                                                text: '<?= lang('Dashboard.youNeedToEnableTheCheckBox') ?>',
                                                                                                icon: 'error',
                                                                                                showCloseButton: true,
                                                                                                showConfirmButton: false
                                                                                                }), false)"  class="submitButton btn btn-success" value="<?= lang('Dashboard.addFunds') ?>"><?= lang('Dashboard.addFunds') ?></button>
                                                                <?php
                                                            }else{
                                                                ?>
                                                                <button type="button" disabled class="submitButton btn btn-outline-danger"><?= lang('Dashboard.addFunds') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                                <?php
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>

                                            <div class="col-6">
                                                <p class="text-danger"><b><?= lang('Dashboard.withdrawCashFromTheUsersWallet') ?></b><br><br></p>
                                                <form class="form-horizontal" data-form-type="withdraw_cash_from_user_wallet" data-action="<?= base_url('dashboard/perform-withdraw-cash-from-user-wallet') ?>">
                                                    <?= csrf_field() ?>
                                                    <div class="form-group row">
                                                        <label for="amount" class="col-sm-3 col-form-label"><?= lang('Dashboard.amount') ?> *</label>
                                                        <div class="col-sm-8">
                                                            <div class="input-group">
                                                                <input type="number" name="amount" id="amount" dir="ltr" class="form-control" required>
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text"><?= $currenciesData->suffix ?></span>
                                                                </div>
                                                            </div>
                                                            <?php
                                                            $min_amount = number_format(1, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                                            $max_amount = number_format(90000000, $currenciesData->decimals, '.', ',') . " " . $currenciesData->suffix;
                                                            ?>
                                                            <small class="text-info d-none"><?= lang('Dashboard.addFundsMinimumXandMaximumY', [$min_amount, $max_amount]) ?></small>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="form-group row">
                                                        <label for="wallet_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.wallet') ?> *</label>
                                                        <div class="col-sm-8">
                                                            <select class="form-control" name="wallet_id" id="wallet_id" required>
                                                                <?php
                                                                foreach($userWallets as $userWallet)
                                                                {
                                                                ?>
                                                                <option value="<?= $userWallet->id ?>"><?= $userWallet->title ?></option>
                                                                <?php
                                                                }
                                                                ?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-group row">
                                                        <div class="offset-sm-3 col-sm-9">
                                                            <div class="checkbox">
                                                                <label>
                                                                    <input name="iam_sure2" id="iam_sure2" type="checkbox"> <?= lang('Dashboard.iamSureOfWithdrawingCashFrom0Wallet', [$user->first_name .' '. $user->last_name]) ?>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <input type="hidden" name="app_name" id="app_name" value="<?= $settingsData->app_name ?>" readonly required>
                                                    <input type="hidden" name="user_id" id="user_id" value="<?= $user->id ?>" readonly required>
                                                    <input type="hidden" name="user_full_name" id="user_full_name" value="<?= $user->first_name .' '. $user->last_name ?>" readonly required>
                                                    <input type="hidden" name="user_email" id="user_email" value="<?= $user->email ?>" readonly required>
                                                    <input type="hidden" name="currency_decimals" id="currency_decimals" value="<?= $userCurrency->decimals ?>" readonly required>
                                                    <input type="hidden" name="currency_suffix" id="currency_suffix" value="<?= $userCurrency->suffix ?>" readonly required>

                                                    <div class="form-group row">
                                                        <div class="offset-sm-3 col-sm-8">
                                                            <?php
                                                            $role_id = $session->role_id;
                                                            if($role_id != 9 AND $role_id != 19)
                                                            {
                                                                ?>
                                                                <button type="submit" id="submitButton" onclick="return document.getElementById('iam_sure2').checked ? true : (Swal.fire({
                                                                                                /*title: '<?= lang('Dashboard.error') ?>',*/
                                                                                                text: '<?= lang('Dashboard.youNeedToEnableTheCheckBox') ?>',
                                                                                                icon: 'error',
                                                                                                showCloseButton: true,
                                                                                                showConfirmButton: false
                                                                                                }), false)"  class="submitButton btn btn-danger" value="<?= lang('Dashboard.cashWithdrawal') ?>"><?= lang('Dashboard.cashWithdrawal') ?></button>
                                                                <?php
                                                            }else{
                                                                ?>
                                                                <button type="button" disabled class="submitButton btn btn-outline-danger"><?= lang('Dashboard.cashWithdrawal') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                                <?php
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- /.tab-pane -->
                                    <?php
                                    }
                                    ?>

                                    <div class="<?php if($active_tab == "settings") echo "active"; ?> tab-pane" id="settings">
                                        <form class="form-horizontal" data-form-type="update_user_profile" data-action="<?= base_url('dashboard/perform-update-user-profile') ?>">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="first_name" class="col-sm-2 col-form-label"><?= lang('Dashboard.firstName') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?= lang('Dashboard.firstName') ?>" value="<?= $user->first_name ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="last_name" class="col-sm-2 col-form-label"><?= lang('Dashboard.lastName') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?= lang('Dashboard.lastName') ?>" value="<?= $user->last_name ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="gender" class="col-sm-2 col-form-label"><?= lang('Dashboard.gender') ?> *</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="gender" id="gender" required>
                                                        <?php
                                                        $selected1 = $selected2 = "";
                                                        if($user->gender == 1) $selected1 = "selected";
                                                        if($user->gender == 2) $selected2 = "selected";
                                                        ?>
                                                        <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                        <option <?= $selected1 ?> value="1"><?= lang('Dashboard.male') ?></option>
                                                        <option <?= $selected2 ?> value="2"><?= lang('Dashboard.female') ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="email" class="col-sm-2 col-form-label"><?= lang('Dashboard.email') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="email" class="form-control" name="email" id="email" placeholder="<?= lang('Dashboard.email') ?>" value="<?= $user->email ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="phone" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="phone" id="phone" placeholder="<?= lang('Dashboard.phone') ?>" value="<?= $user->phone ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="mobile" class="col-sm-2 col-form-label"><?= lang('Dashboard.mobile') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="mobile" id="mobile" placeholder="<?= lang('Dashboard.mobile') ?>" value="<?= $user->mobile ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="address" class="col-sm-2 col-form-label"><?= lang('Dashboard.address') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="address" id="address" placeholder="<?= lang('Dashboard.address') ?>" value="<?= $user->address ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="postcode" class="col-sm-2 col-form-label"><?= lang('Dashboard.postcode') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="postcode" id="postcode" placeholder="<?= lang('Dashboard.postcode') ?>" value="<?= $user->postcode ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="dark_mode" class="col-sm-2 col-form-label"><?= lang('Dashboard.showMode') ?></label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="dark_mode" id="dark_mode" required>
                                                        <?php
                                                        $selected1 = $selected2 = "";
                                                        if($user->dark_mode == 0) $selected1 = "selected";
                                                        if($user->dark_mode == 1) $selected2 = "selected";
                                                        ?>
                                                        <option <?= $selected1 ?> value="0"><?= lang('Dashboard.lightMode') ?></option>
                                                        <option <?= $selected2 ?> value="1"><?= lang('Dashboard.darkMode') ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="role_id" class="col-sm-2 col-form-label"><?= lang('Dashboard.userRole') ?> *</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="role_id" id="role_id" required>
                                                        <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                        <?php
                                                        foreach ($roles as $role)
                                                        {
                                                            $selected = "";
                                                            if($role->id == $user->role_id)
                                                                $selected = "selected";
                                                            ?>
                                                            <option <?= $selected ?> value="<?= $role->id ?>"><?= $role->title ?></option>
                                                            <?php
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--<div class="form-group row d-none" id="vip_duration_container">
                                                <label for="vip_duration" class="col-sm-2 col-form-label"><?= lang('Dashboard.vipDuration') ?> *</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="vip_duration" id="vip_duration" required>
                                                        <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                        <?php
                                                        foreach ($vipUsersPackages as $package)
                                                        {
                                                        ?>
                                                            <option value="<?= $package->days ?>"><?= $package->title ?></option>
                                                        <?php
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>-->
                                            <div class="form-group row">
                                                <label for="status_id" class="col-sm-2 col-form-label"><?= lang('Dashboard.status') ?> *</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control" name="status_id" id="status_id" required>
                                                        <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                        <?php
                                                        foreach ($statuses as $status)
                                                        {
                                                            $selected = "";
                                                            if($status->id == $user->status_id)
                                                                $selected = "selected";
                                                            ?>
                                                            ?>
                                                            <option <?= $selected ?> value="<?= $status->id ?>"><?= $status->title ?></option>
                                                            <?php
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="user_note" class="col-sm-2 col-form-label"><?= lang('Dashboard.note') ?></label>
                                                <div class="col-sm-10">
                                                    <textarea class="form-control" rows="3" name="user_note" id="user_note" placeholder="<?= lang('Dashboard.note') ?>"><?= $user->user_note ?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="admin_note" class="col-sm-2 col-form-label"><?= lang('Dashboard.adminNote') ?></label>
                                                <div class="col-sm-10">
                                                    <textarea class="form-control" rows="3" name="admin_note" id="admin_note" placeholder="<?= lang('Dashboard.adminNote') ?>"><?= $user->admin_note ?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $checked = "";
                                                            if($user->api_key_access == 1) $checked = "checked";
                                                            ?>
                                                            <input <?= $checked ?> name="api_key_access" type="checkbox"> <?= lang('Dashboard.accessAndManageTheApiKeyByUser') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <input type="hidden" name="user_id" value="<?= service('uri')->getSegment(3); ?>" readonly>
                                                        <button type="submit" id="submitButton" class="submitButton btn btn-outline-primary" value="<?= lang('Dashboard.edit') ?>"><?= lang('Dashboard.edit') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.edit') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "change_password") echo "active"; ?> tab-pane" id="change_password">
                                        <form class="form-horizontal" action="<?= base_url('dashboard/perform-change-user-password') ?>" method="post" onsubmit="buttonLoading2()">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="password" class="col-sm-2 col-form-label"><?= lang('Dashboard.newPassword') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?= lang('Dashboard.newPassword') ?>" value="" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input name="send_user_info" type="checkbox"> <?= lang('Dashboard.accountDetailsShouldBeSentToTheUsersEmail') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <input type="hidden" name="first_name" value="<?= $user->first_name; ?>" readonly>
                                                        <input type="hidden" name="last_name" value="<?= $user->last_name; ?>" readonly>
                                                        <input type="hidden" name="email" value="<?= $user->email; ?>" readonly>
                                                        <input type="hidden" name="user_id" value="<?= service('uri')->getSegment(3); ?>" readonly>
                                                        <button type="submit" id="submitButton2" class="btn btn-outline-primary" value="<?= lang('Dashboard.changePassword') ?>"><?= lang('Dashboard.changePassword') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.changePassword') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "change_image") echo "active"; ?> tab-pane" id="change_image">

                                        <form method="POST" enctype="multipart/form-data" class="form-horizontal" action="<?= base_url('dashboard/perform-change-user-image'); ?>" accept-charset="UTF-8" onsubmit="buttonLoading3()">
                                            <?= csrf_field() ?>
                                            <div class="form-group row">
                                                <label for="image" class="col-sm-2 col-form-label"><?= lang('Dashboard.newImage') ?> *</label>
                                                <div class="col-sm-10">
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" name="image" required>
                                                            <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                        </div>
                                                    </div>
                                                    <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                                    <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 300, 300 ]) ?></small><br>
                                                    <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 2048 ]) ?></small>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <input type="hidden" readonly name="old_image" value="<?= $user->image; ?>">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                    ?>
                                                        <input type="hidden" name="user_id" value="<?= service('uri')->getSegment(3); ?>" readonly>
                                                        <button id="submitButton3" type="submit" class="btn btn-outline-primary" value="<?= lang('Dashboard.changeImage') ?>"><?= lang('Dashboard.changeImage') ?></button>
                                                    <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.changeImage') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "downloaded") echo "active"; ?> tab-pane" id="downloaded">
                                        <div class="card-body table-responsive p-0">
                                            <table class="table table-hover text-nowrap">
                                                <thead>
                                                <tr>
                                                    <th><?= lang('Dashboard.file') ?></th>
                                                    <th><?= lang('Dashboard.device') ?></th>
                                                    <th><?= lang('Dashboard.ip') ?></th>
                                                    <th><?= lang('Dashboard.firstDownload') ?></th>
                                                    <th><?= lang('Dashboard.lastDownload') ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                foreach ($downloaded as $dl)
                                                {
                                                    if($settingsData->calendar_type == "jDate")
                                                    {
                                                        $created_at = $jdf->jdate('Y/m/d G:i', $dl->created_at, '', $settingsData->timezone);
                                                        $updated_at = $jdf->jdate('Y/m/d G:i', $dl->updated_at, '', $settingsData->timezone);
                                                    }else{
                                                        $created_at = Time::createFromTimestamp($dl->created_at, $settingsData->timezone, 'en_US');
                                                        $updated_at = Time::createFromTimestamp($dl->updated_at, $settingsData->timezone, 'en_US');
                                                    }
                                                    $dl_ip = $dl->ip;
                                                    if($theRoleID == 9)
                                                        $dl_ip = 'xx.xx.xx.xx';
                                                    ?>
                                                    <tr>
                                                        <td><a target="_blank" title="<?= $dl->file_title ?>" href="<?= base_url("file-details/$dl->content_id/$dl->file_title_slug?id=$dl->content_id") ?>"</a><?= $dl->file_title ?></td>
                                                        <td><?= $dl->device_type_title; ?></td>
                                                        <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $dl_ip ?>" title="<?= $dl->agent ?>"><?= $dl_ip ?></a></td>
                                                        <td><?= $created_at; ?></td>
                                                        <td><?= $updated_at; ?></td>
                                                    </tr>
                                                    <?php
                                                }
                                                ?>
                                                </tbody>
                                            </table>
                                            <?php
                                            if(empty($downloaded)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                            ?>
                                            <br>
                                            <div class="px-0 text-center">
                                                <?php
                                                if(!empty($downloaded)) { ?>
                                                    <a type="button" class="btn btn-sm btn-outline-success" href="<?= base_url("dashboard/downloaded-files?keyword=$user->email") ?>" ><?= lang('Dashboard.seeMore') ?></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "devices_info") echo "active"; ?> tab-pane" id="devices_info">
                                        <div class="card-body table-responsive p-0">
                                            <table class="table table-hover text-nowrap small">
                                                <thead>
                                                <tr>
                                                    <th><?= lang('Dashboard.imei') ?></th>
                                                    <th><?= lang('Dashboard.androidId') ?></th>
                                                    <th><?= lang('Dashboard.uuid') ?></th>
                                                    <!--<th><?= lang('Dashboard.buildSerialNumber') ?></th>-->
                                                    <th><?= lang('Dashboard.buildModel') ?></th>
                                                    <th><?= lang('Dashboard.buildManufacturer') ?></th>
                                                    <th><?= lang('Dashboard.buildProduct') ?></th>
                                                    <!--<th><?= lang('Dashboard.macAddress') ?></th>-->
                                                    <th><?= lang('Dashboard.ip') ?></th>
                                                    <th><?= lang('Dashboard.created') ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                foreach ($devicesInfo as $device)
                                                {
                                                    if($settingsData->calendar_type == "jDate")
                                                    {
                                                        $created_at = $jdf->jdate('Y/m/d G:i', $device->created_at, '', $settingsData->timezone);
                                                    }else{
                                                        $created_at = Time::createFromTimestamp($device->created_at, $settingsData->timezone, 'en_US');
                                                    }
                                                    $user_ip = $device->user_ip;
                                                    if($theRoleID == 9)
                                                        $user_ip = 'xx.xx.xx.xx';
                                                    ?>
                                                    <tr>
                                                        <td><?= $device->imei; ?></td>
                                                        <td><?= $device->android_id; ?></td>
                                                        <td><?= $device->uuid; ?></td>
                                                        <!--<td><?= $device->build_serial_number; ?></td>-->
                                                        <td><?= $device->build_model; ?></td>
                                                        <td><?= $device->build_manufacturer; ?></td>
                                                        <td><?= $device->build_product; ?></td>
                                                        <!--<td><?= $device->mac_address; ?></td>-->
                                                        <td><a target="_blank" href="https://extreme-ip-lookup.com/<?= $user_ip ?>" title="<?= $device->user_agent ?>"><?= $user_ip ?></a></td>
                                                        <td><?= $created_at; ?></td>
                                                    </tr>
                                                    <?php
                                                }
                                                ?>
                                                </tbody>
                                            </table>
                                            <?php
                                            if(empty($devicesInfo)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                            ?>
                                            <br>
                                            
                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "api_key") echo "active"; ?> tab-pane" id="api_key">

                                        <form method="POST" enctype="multipart/form-data" class="form-horizontal" action="<?= base_url('dashboard/perform-update-user-api-key'); ?>" accept-charset="UTF-8" onsubmit="buttonLoading4()">
                                            <?= csrf_field() ?>

                                            <div class="form-group row">
                                                <label for="id" class="col-sm-2 col-form-label"><?= lang('Dashboard.apiId') ?></label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="id" id="id" disabled readonly placeholder="<?= lang('Dashboard.apiId') ?>" value="<?= $api_id ?>" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="api_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.apiKey') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="api_key" id="api_key" placeholder="<?= lang('Dashboard.apiKey') ?>" value="<?= $api_key ?>" required>
                                                    <small class="text-info"><?= lang('Dashboard.minimumOf32CharactersAndMaximumOf64Characters') ?></small>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <?php
                                                            $checked_read = $checked_write = $checked_status = "";
                                                            if($api_read == 1) $checked_read = "checked";
                                                            if($api_write == 1) $checked_write = "checked";
                                                            if($api_status == 1) $checked_status = "checked";
                                                            ?>
                                                            <input <?= $checked_read ?> name="read" type="checkbox"> <?= lang('Dashboard.readAbility') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input <?= $checked_write ?> name="write" type="checkbox"> <?= lang('Dashboard.writeAbility') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input <?= $checked_status ?> name="status" type="checkbox"> <?= lang('Dashboard.enableApiKey') ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="offset-sm-2 col-sm-10">
                                                    <?php
                                                    $role_id = $session->role_id;
                                                    if($role_id != 9 AND $role_id != 19 AND $user->api_key_access != 0)
                                                    {
                                                        ?>
                                                        <input type="hidden" readonly class="form-control" name="id" id="id" value="<?= $api_id ?>">
                                                        <input type="hidden" name="user_id" value="<?= service('uri')->getSegment(3); ?>" readonly>
                                                        <button id="submitButton4" type="submit" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                    <!-- /.tab-pane -->
                                </div>
                                <!-- /.tab-content -->
                            </div><!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
    var roleSelect = document.getElementById('role_id');
    var vipDurationContainer = document.getElementById('vip_duration_container');
    var vipDurationSelect = document.getElementById('vip_duration');

    function toggleVipDuration() {
        var selectedRoleId = roleSelect.value;

        if (selectedRoleId == '11') {
            vipDurationContainer.classList.remove('d-none');
            vipDurationSelect.setAttribute('required', 'required');
        } else {
            vipDurationContainer.classList.add('d-none');
            vipDurationSelect.removeAttribute('required');
        }
    }

    // Event listener for role_id change
    roleSelect.addEventListener('change', toggleVipDuration);

    // Initial check if the role_id is already selected (in case of form reloading)
    if (roleSelect.value == '11') {
        toggleVipDuration();
    }
});
</script>
<?= $this->endSection() ?>