<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersPackages') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/users-packages') ?>" class="dropdown-item"><?= lang('Dashboard.usersPackages') ?></a>
                                            <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" data-form-type="edit_users_package" data-action="<?= base_url('dashboard/perform-edit-users-package') ?>">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" value="<?= $packageContent->title ?>" placeholder="<?= lang('Dashboard.title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="days" class="col-sm-3 col-form-label"><?= lang('Dashboard.days') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="days" value="<?= $packageContent->days ?>" placeholder="<?= lang('Dashboard.days') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="price" class="col-sm-3 col-form-label"><?= lang('Dashboard.priceX', [$currenciesData->suffix]) ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="price" value="<?= number_format($packageContent->price, $currenciesData->decimals, '.', ''); ?>" placeholder="<?= lang('Dashboard.priceX', [$currenciesData->suffix]) ?>" required>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label for="status" class="col-sm-3 col-form-label"></label>
                                        <div class="col-sm-9">
                                            <div class="custom-control custom-checkbox">
                                                <?php
                                                $checked = "";
                                                if($packageContent->status == 1) $checked = "checked";
                                                ?>
                                                <input type="checkbox" class="custom-control-input" name="status" id="status" <?= $checked ?>>
                                                <label for="status" class="custom-control-label"><?= lang('Dashboard.enableThisPackage') ?></label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="id" readonly required value="<?= service('uri')->getSegment(3) ?>">
                                    <button type="submit" id="submitButton" class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="submitButton btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>