<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('tags-input-header') ?>
    <!-- Tags Input: https://github.com/erwinheldy/tagin -->
    <link rel="stylesheet" href="<?= base_url('backend/assets/dist/css/tagin/tagin.min.css'); ?>">
<?= $this->endSection() ?>

<?= $this->section('tags-input-footer') ?>
    <!-- Tags Input -->
    <script src="<?= base_url('backend/assets/dist/js/tagin/tagin.min.js'); ?>"></script>
    <script>
        document.querySelectorAll('.tagin:not([id])').forEach((el) => {
            if (el instanceof HTMLInputElement) {
                const tagin = new Tagin(el)
            }
        })

        const testAdd = new Tagin(document.getElementById('test-add'))
        document.getElementById('add1').addEventListener('click', function () {
            testAdd.addTag('yellow')
            this.remove()
        })
        document.getElementById('add2').addEventListener('click', function () {
            testAdd.addTag(['cyan', 'black'])
            this.remove()
        })

        const testValue = new Tagin(document.getElementById('test-value'))
        document.getElementById('get').addEventListener('click', function () {
            const value = testValue.getTag()
            const values = JSON.stringify(testValue.getTags())
            document.getElementById('value-container').innerHTML = `${value}<br>${values}`
        })


        // Example starter JavaScript for disabling form submissions if there are invalid fields
        void (function() {
            document.querySelectorAll('.needs-validation').forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }

                    form.classList.add('was-validated')
                })
            })
        })()
    </script>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-7">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/user-roles') ?>" class="dropdown-item"><?= lang('Dashboard.userRoles') ?></a>
                                            <a href="<?= base_url('dashboard/create-new-user') ?>" class="dropdown-item"><?= lang('Dashboard.createNewUser') ?></a>
                                            <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-role') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-2 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="title" value="<?= $roleContent->title ?>" placeholder="<?= lang('Dashboard.title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="permission" class="col-sm-2 col-form-label"><?= lang('Dashboard.permission') ?> *</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control shadow-none tagin" style="direction: ltr; text-align: left" name="permission" required data-tagin-enter placeholder="<?= lang('Dashboard.permission') ?>" data-tagin-placeholder="<?= lang('Dashboard.permission').' '.lang('Dashboard.separateWithAComma') ?>" value="<?= $roleContent->permission ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="name" class="col-sm-2 col-form-label"></label>
                                        <div class="col-sm-10">
                                            <div class="custom-control custom-checkbox">
                                                <?php
                                                $checked = "";
                                                if($roleContent->active == 1) $checked = "checked";
                                                ?>
                                                <input type="checkbox" class="custom-control-input" name="active" id="active" <?= $checked ?>>
                                                <label for="active" class="custom-control-label"><?= lang('Dashboard.enableThisUserRole') ?></label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="id" readonly required value="<?= service('uri')->getSegment(3) ?>">
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.guide') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <p><?= lang('Dashboard.editRoleGuideText') ?></p>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>