<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.usersManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <span class="responseMessage" id="responseMessage"></span>
                <div class="row">
                    <div class="col-md-6">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/users-list') ?>" class="dropdown-item"><?= lang('Dashboard.usersList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" data-form-type="create_new_user" data-action="<?= base_url('dashboard/perform-create-new-user') ?>">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="first_name" class="col-sm-3 col-form-label"><?= lang('Dashboard.firstName') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?= lang('Dashboard.firstName') ?>" value="<?= old('first_name') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="last_name" class="col-sm-3 col-form-label"><?= lang('Dashboard.lastName') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?= lang('Dashboard.lastName') ?>" value="<?= old('last_name') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="email" class="col-sm-3 col-form-label"><?= lang('Dashboard.email') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" name="email" id="email" placeholder="<?= lang('Dashboard.email') ?>" value="<?= old('email') ?>" autocomplete="off" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="postcode" class="col-sm-3 col-form-label"><?= lang('Dashboard.password') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="password" class="form-control" name="password" id="password" placeholder="<?= lang('Dashboard.password') ?>" autocomplete="new-password" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="mobile" class="col-sm-3 col-form-label"><?= lang('Dashboard.mobile') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="mobile" id="mobile" placeholder="<?= lang('Dashboard.mobile') ?>" value="<?= old('mobile') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="role_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.userRole') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="role_id" id="role_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($roles as $role)
                                                {
                                                ?>
                                                    <option value="<?= $role->id ?>"><?= $role->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row d-none" id="vip_duration_container">
                                        <label for="vip_duration" class="col-sm-3 col-form-label"><?= lang('Dashboard.vipDuration') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="vip_duration" id="vip_duration" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($vipUsersPackages as $package)
                                                {
                                                ?>
                                                    <option value="<?= $package->days ?>"><?= $package->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="status_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.status') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="status_id" id="status_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($statuses as $status)
                                                {
                                                ?>
                                                    <option value="<?= $status->id ?>"><?= $status->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="send_user_info" type="checkbox"> <?= lang('Dashboard.accountDetailsShouldBeSentToTheUsersEmail') ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="submitButton btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.createNewUser') ?>"><?= lang('Dashboard.createNewUser') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.createNewUser') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                                
                            </div>
                            <!-- /.card-footer-->
                            
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                    
                    <div id="newDataContainer" class="d-none" style="display: none;">
                        <div>{{first_name}}</span>
                        <div>{{last_name}}</div>
                        <div>{{email}}</div>
                    </div>

                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<script>
document.addEventListener('DOMContentLoaded', function() {
    var roleSelect = document.getElementById('role_id');
    var vipDurationContainer = document.getElementById('vip_duration_container');
    var vipDurationSelect = document.getElementById('vip_duration');

    function toggleVipDuration() {
        var selectedRoleId = roleSelect.value;

        if (selectedRoleId == '11') {
            vipDurationContainer.classList.remove('d-none');
            vipDurationSelect.setAttribute('required', 'required');
        } else {
            vipDurationContainer.classList.add('d-none');
            vipDurationSelect.removeAttribute('required');
        }
    }

    // Event listener for role_id change
    roleSelect.addEventListener('change', toggleVipDuration);

    // Initial check if the role_id is already selected (in case of form reloading)
    if (roleSelect.value == '11') {
        toggleVipDuration();
    }
});
</script>
<?= $this->endSection() ?>