<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<?php
$session = session();
$role_id = $session->role_id;
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">

                    <div class="col-lg-4">
                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanSessionFiles'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-session-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.youMayLogoutFromTheAdminDashboardAfterCleaningTheSession') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-cyan card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanLogFiles'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-logs-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                    <option value="7776000"><?= lang('Dashboard.threeMonthsBefore'); ?></option>
                                                    <option value="15552000"><?= lang('Dashboard.sixMonthsBefore'); ?></option>
                                                    <option value="31104000"><?= lang('Dashboard.oneYearBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.logFilesAreEssentialForTroubleshooting') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-green card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanDebugBarFiles'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-debugbar-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                    <option value="7776000"><?= lang('Dashboard.threeMonthsBefore'); ?></option>
                                                    <option value="15552000"><?= lang('Dashboard.sixMonthsBefore'); ?></option>
                                                    <option value="31104000"><?= lang('Dashboard.oneYearBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.debugBarFilesAreEssentialForTroubleshooting') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-orange card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanCacheFiles'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-cache-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                    <option value="7776000"><?= lang('Dashboard.threeMonthsBefore'); ?></option>
                                                    <option value="15552000"><?= lang('Dashboard.sixMonthsBefore'); ?></option>
                                                    <option value="31104000"><?= lang('Dashboard.oneYearBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.cacheFilesAreEssentialForSpeedingUpYourWebsite') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-purple card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanUsersActivity'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-users-activity-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                    <option value="7776000"><?= lang('Dashboard.threeMonthsBefore'); ?></option>
                                                    <option value="15552000"><?= lang('Dashboard.sixMonthsBefore'); ?></option>
                                                    <option value="31104000"><?= lang('Dashboard.oneYearBefore'); ?></option>
                                                    <option value="62208000"><?= lang('Dashboard.twoYearBefore'); ?></option>
                                                    <option value="93312000"><?= lang('Dashboard.threeYearsBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.thisWillDeleteTheUsersActivityLog') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-pink card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.cleanDownloadedFiles'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" action="<?= base_url('dashboard/perform-downloaded-files-cleanup'); ?>" accept-charset="UTF-8" onsubmit="cleanSessionFiles.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><?= lang('Dashboard.cleanupBefore'); ?></label>
                                        <div class="input-group">
                                            <div class="input-group">
                                                <select name="cleanup" class="form-control" required>
                                                    <option disabled selected><?= lang('Dashboard.pleaseSelect'); ?></option>
                                                    <option value="0"><?= lang('Dashboard.nowBefore'); ?></option>
                                                    <option value="86400"><?= lang('Dashboard.oneDayBefore'); ?></option>
                                                    <option value="259200"><?= lang('Dashboard.threeDaysBefore'); ?></option>
                                                    <option value="604800"><?= lang('Dashboard.oneWeekBefore'); ?></option>
                                                    <option value="2592000"><?= lang('Dashboard.oneMonthBefore'); ?></option>
                                                    <option value="7776000"><?= lang('Dashboard.threeMonthsBefore'); ?></option>
                                                    <option value="15552000"><?= lang('Dashboard.sixMonthsBefore'); ?></option>
                                                    <option value="31104000"><?= lang('Dashboard.oneYearBefore'); ?></option>
                                                    <option value="62208000"><?= lang('Dashboard.twoYearBefore'); ?></option>
                                                    <option value="93312000"><?= lang('Dashboard.threeYearsBefore'); ?></option>
                                                </select>
                                                <div class="input-group-append">
                                                    <?php
                                                    if($role_id != 9 AND $role_id != 19)
                                                    {
                                                        ?>
                                                        <button type="submit" id="cleanSessionFiles" class="btn btn-primary" value="<?= lang('Dashboard.cleanup') ?>"><?= lang('Dashboard.cleanup') ?></button>
                                                        <?php
                                                    }else{
                                                        ?>
                                                        <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.cleanup') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <small class="mt-2 text-info"><?= lang('Dashboard.thisWillDeleteTheDownloadedFilesLog') ?></small>
                                        </div>



                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>