<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-12">
                        <!-- Default box -->
                        <div class="card" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                        <i class="fas fa-expand"></i>
                                    </button>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                <?php
                                foreach($scanDirectory as $folder)
                                {
                                    if (!is_dir($folder))
                                    {
                                        $active = "";
                                        $status = "primary";
                                        if($settingsData->template_name == $folder)
                                        {
                                            $status = "success";
                                            $active = "<span class='center badge badge-info'>".lang('Dashboard.active')."</span>";
                                        }
                                        if($folder == "Mobile") continue;
                                    ?>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card">
                                            <img class="card-img-top" src="<?= base_url("frontend/$folder/poster.png") ?>" alt="<?= $folder ?>">
                                            <div class="card-body">
                                                <br>
                                                <h4 class="card-title"><?= $folder ?> <?= $active ?></h4>
                                                <p class="card-text"></p>
                                                <a href="<?= base_url("dashboard/select-template/$folder") ?>" class="btn btn-<?=$status?> btn-block"><?= lang('Dashboard.selectThisTemplate') ?></a>
                                            </div>

                                        </div>
                                    </div>
                                    <?php
                                    }
                                }
                                ?>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card">
                                            <img class="card-img-top" src="<?= base_url("frontend/poster.png") ?>" alt="poster">
                                            <div class="card-body">
                                                <br>
                                                <h4 class="card-title"><?= lang('Dashboard.lookingForNewTemplate') ?></h4>
                                                <p class="card-text"></p>
                                                <a target="_blank" href="https://www.rtl-theme.com/dashboard/#/ticket-send" class="btn btn-dark btn-block"><?= lang('Dashboard.requestNewTemplate') ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>