<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.versionControl') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-version') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                    <?= csrf_field() ?>
                <div class="row">
                    <div class="col-md-9">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/version-control') ?>" class="dropdown-item"><?= lang('Dashboard.versionControl') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>

                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.title') ?> *</label>
                                                <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= $version->title ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.versionCode') ?> *</label>
                                                <input type="number" class="form-control" name="version_code" id="version_code" placeholder="1" value="<?= $version->version_code ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.versionName') ?> *</label>
                                                <input type="text" class="form-control" name="version_name" id="version_name" placeholder="1.0.0" value="<?= $version->version_name ?>" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.releaseNotes') ?> *</label>
                                                <br>
                                                <textarea name="release_notes" id="summernote" required><?= $version->release_notes ?></textarea>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.changelog') ?> *</label>
                                                <br>
                                                <textarea name="changelog" id="summernote2" required><?= $version->changelog ?></textarea>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.upgradeInstructions') ?> *</label>
                                                <br>
                                                <textarea name="upgrade_instructions" id="summernote3" required><?= $version->upgrade_instructions ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <br>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label for="download_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.downloadURL') ?> *</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="download_url" id="download_url" required placeholder="https://www.domain.com/release.zip" value="<?= $version->download_url ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-3">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.publish'); ?></h3>
                                <div class="card-tools">
                                </div>
                            </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.releaseDate') ?></label>
                                                <input type="text" class="form-control" name="release_date" id="release_date" placeholder="12 June 2023" value="<?= $version->release_date ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label><?= lang('Dashboard.upgradeAlarm') ?></label>

                                                <div class="form-group">
                                                    <div class="custom-control custom-radio">
                                                    <?php
                                                    $checked1 = $checked2 = "";
                                                    if ($version->upgrade_alarm == 0)
                                                        $checked1 = "checked";
                                                    elseif ($version->upgrade_alarm == 1)
                                                        $checked2 = "checked";
                                                    ?>
                                                        <input class="custom-control-input" type="radio" id="upgrade_alarm1" value="0" name="upgrade_alarm" <?= $checked1 ?>>
                                                        <label for="upgrade_alarm1" class="custom-control-label" style="font-weight: 400;"><?= lang('Dashboard.onlyShowTheAlarm') ?></label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input class="custom-control-input" type="radio" id="upgrade_alarm2" value="1" name="upgrade_alarm" <?= $checked2 ?>>
                                                        <label for="upgrade_alarm2" class="custom-control-label" style="font-weight: 400;"><?= lang('Dashboard.showTheAlarmAndForceToUpgrade') ?></label>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="form-group">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $status_checked = "";
                                                    if ($version->status == 1)
                                                        $status_checked = "checked"
                                                    ?>
                                                    <input class="custom-control-input" type="checkbox" id="status" name="status" <?= $status_checked ?>>
                                                    <label for="status" class="custom-control-label"><?= lang('Dashboard.enableThisVersion') ?></label>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    <?php
                                    $session = session();
                                    $role_id = $session->role_id;
                                    if($role_id != 9 AND $role_id != 19)
                                    {
                                        ?>
                                        <input type="hidden" readonly name="id" value="<?= $version->id ?>" required>
                                        <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.editVersion') ?>"><?= lang('Dashboard.editVersion') ?></button>
                                        <?php
                                    }else{
                                        ?>
                                        <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.editVersion') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <!-- /.card-footer-->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
            </form>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>