<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-4">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-update-language') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" value="<?= $language->title ?>" placeholder="<?= lang('Dashboard.title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="locale" class="col-sm-3 col-form-label"><?= lang('Dashboard.languageCode') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="locale" value="<?= $language->locale ?>" dir="ltr" placeholder="en" disabled readonly required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="flag" class="col-sm-3 col-form-label"><?= lang('Dashboard.flag') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="flag" value="<?= $language->flag ?>" dir="ltr" placeholder="flag-icon-us" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="direction" class="col-sm-3 col-form-label"><?= lang('Dashboard.direction') ?> *</label>
                                        <div class="col-sm-9">
                                            <?php
                                            $selected1 = $selected2 = "";
                                            if($language->direction == 'ltr') $selected1 = "selected";
                                            if($language->direction == 'rtl') $selected2 = "selected";
                                            ?>
                                            <select class="form-control" name="direction" id="direction" required>
                                                <option <?= $selected1 ?> value="ltr">LTR</option>
                                                <option <?= $selected2 ?> value="rtl">RTL</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="status" class="col-sm-3 col-form-label"></label>
                                        <div class="col-sm-9">
                                            <div class="custom-control custom-checkbox">
                                                <?php
                                                $checked = "";
                                                if($language->status == '1') $checked = "checked";
                                                ?>
                                                <input <?= $checked ?> type="checkbox" class="custom-control-input" name="status" id="status">
                                                <label for="status" class="custom-control-label"><?= lang('Dashboard.thisLanguageIsEnabled') ?></label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="id" value="<?= $language->id ?>" readonly required>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>