<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>
<?php
$session = session();
$role_id = $session->role_id;
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.dashboardLogo'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-dashboard-logo'); ?>" accept-charset="UTF-8" onsubmit="updateDashboardLogo.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->dashboard_logo) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="dashboard_logo" required>
                                                <label class="custom-file-label" for="dashboard_logo"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateDashboardLogo" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 128, 128 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 200 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-orange card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.lightWebsiteLogo'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-light-logo-website'); ?>" accept-charset="UTF-8" onsubmit="updateLightLogoWebsite.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->light_logo_website) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="light_logo_website" required>
                                                <label class="custom-file-label" for="light_logo_website"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateLightLogoWebsite" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 600, 180 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-info card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.darkWebsiteLogo'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-dark-logo-website'); ?>" accept-charset="UTF-8" onsubmit="updateDarkLogoWebsite.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->dark_logo_website) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="dark_logo_website" required>
                                                <label class="custom-file-label" for="dark_logo_website"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateDarkLogoWebsite" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 600, 180 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-gray card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.lightMobileLogo'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-light-logo-mobile'); ?>" accept-charset="UTF-8" onsubmit="updateLightLogoMobile.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->light_logo_mobile) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="light_logo_mobile" required>
                                                <label class="custom-file-label" for="light_logo_mobile"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateLightLogoMobile" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 600, 180 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-gray-dark card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.darkMobileLogo'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-dark-logo-mobile'); ?>" accept-charset="UTF-8" onsubmit="updateDarkLogoMobile.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->dark_logo_mobile) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="dark_logo_mobile" required>
                                                <label class="custom-file-label" for="dark_logo_mobile"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateDarkLogoMobile" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 600, 180 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.breadcrumbsImage'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-breadcrumbs-image'); ?>" accept-charset="UTF-8" onsubmit="updateBreadcrumbsImage.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->breadcrumbs_image) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="breadcrumbs_image" required>
                                                <label class="custom-file-label" for="breadcrumbs_image"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateBreadcrumbsImage" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 1920, 440 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 2048 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-fuchsia card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.lightIcLauncher'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-light-ic-launcher'); ?>" accept-charset="UTF-8" onsubmit="updateIcLauncher.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->light_ic_launcher) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="light_ic_launcher" required>
                                                <label class="custom-file-label" for="light_ic_launcher"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateIcLauncher" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 512, 512 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-purple card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.darkIcLauncher'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-dark-ic-launcher'); ?>" accept-charset="UTF-8" onsubmit="updateIcLauncher.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->dark_ic_launcher) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="dark_ic_launcher" required>
                                                <label class="custom-file-label" for="dark_ic_launcher"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateIcLauncher" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 512, 512 ]) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 1024 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-green card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.favicon'); ?></h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                                    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                            <div class="card-body">

                                <form method="POST" enctype="multipart/form-data" action="<?= base_url('dashboard/update-favicon'); ?>" accept-charset="UTF-8" onsubmit="updateFavicon.disabled = true; return true;">
                                    <?= csrf_field() ?>
                                    <div class="form-group">
                                        <label><a target="_blank" href="<?= base_url('backend/assets/uploads/admins/images/'.$settings->favicon) ?>"><?= lang('Dashboard.showImage') ?></a></label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="favicon" required>
                                                <label class="custom-file-label" for="favicon"><?= lang('Dashboard.chooseImage'); ?></label>
                                            </div>
                                            <div class="input-group-append">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="updateFavicon" class="btn btn-primary" value="<?= lang('Dashboard.upload') ?>"><?= lang('Dashboard.upload') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-danger"><?= lang('Dashboard.upload') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <small class="text-info"><?= lang('Dashboard.onlyImageWithIcoExtensionAreSupported') ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.youCanGenerateFaviconFrom', ['www.favicon.io']) ?></small><br>
                                        <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 100 ]) ?></small>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>