<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-4">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-create-language') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" value="<?= old('title') ?>" placeholder="<?= lang('Dashboard.title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="locale" class="col-sm-3 col-form-label"><?= lang('Dashboard.languageCode') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="locale" value="<?= old('locale') ?>" dir="ltr" placeholder="en" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="flag" class="col-sm-3 col-form-label"><?= lang('Dashboard.flag') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="flag" value="<?= old('flag') ?>" dir="ltr" placeholder="flag-icon-us" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="direction" class="col-sm-3 col-form-label"><?= lang('Dashboard.direction') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="direction" id="direction" required>
                                                <option value="ltr">LTR</option>
                                                <option value="rtl">RTL</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="status" class="col-sm-3 col-form-label"></label>
                                        <div class="col-sm-9">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" name="status" id="status">
                                                <label for="status" class="custom-control-label"><?= lang('Dashboard.thisLanguageIsEnabled') ?></label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.createALanguage') ?>"><?= lang('Dashboard.createALanguage') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.createALanguage') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-8">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.languagesList') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.languageCode') ?></th>
                                        <th><?= lang('Dashboard.flag') ?></th>
                                        <th><?= lang('Dashboard.direction') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($languages as $language)
                                    {
                                        $status = "<span class='badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($language->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.active')."</span>";
                                        ?>
                                        <tr>
                                            <td><?= $language->title; ?></td>
                                            <td><?= $language->locale; ?></td>
                                            <td><i class="flag-icon <?= $language->flag; ?>"></i></td>
                                            <td><?= $language->direction; ?></td>
                                            <td><?= $status ?></td>
                                            <td style="width: 108px;">
                                                <a title="<?= lang('Dashboard.update') ?>" href="<?= base_url('dashboard/update-language/'.$language->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>
                                                <a title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-language/'.$language->id); ?>" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');" class="text-danger p-1">&nbsp;<i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table><br>
                                <?php
                                if(empty($languages)) echo "<p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <div class="px-2"><?= $pager->Links() ?></div>

                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <small class="text-info"><?= lang('Dashboard.txtLanguagesGuide') ?></small>
                            </div>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>