<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

<?php
$active_tab = "";
if(isset($_GET['active_tab']))
    $active_tab = $_GET['active_tab'];
$session = session();
?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <div class="card">
                            <div class="card-header p-2">
                                <ul class="nav nav-pills">
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "") echo "active"; if($active_tab == "configuration") echo "active"; ?>" href="#configuration" data-toggle="tab"><?= lang('Dashboard.configuration') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "social_media") echo "active"; ?>" href="#social_media" data-toggle="tab"><?= lang('Dashboard.socialMedia') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "third_party_apps") echo "active"; ?>" href="#third_party_apps" data-toggle="tab"><?= lang('Dashboard.thirdPartyApps') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "captcha") echo "active"; ?>" href="#captcha" data-toggle="tab"><?= lang('Dashboard.captchaProtection') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "maintenance") echo "active"; ?>" href="#maintenance" data-toggle="tab"><?= lang('Dashboard.maintenance') ?></a></li>
                                    <li class="nav-item"><a class="nav-link <?php if($active_tab == "seo_tools") echo "active"; ?>" href="#seo_tools" data-toggle="tab"><?= lang('Dashboard.seoTools') ?></a></li>
                                </ul>
                            </div><!-- /.card-header -->
                            <div class="card-body">
                                <div class="tab-content">

                                    <div class="<?php if($active_tab == "") echo "active"; if($active_tab == "configuration") echo "active";?> tab-pane" id="configuration">
                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading()'];
                                        echo form_open('dashboard/update-configuration', $attributes);
                                        // To upload file: form_open_multipart
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="app_name" class="col-sm-2 col-form-label"><?= lang('Dashboard.appTitle') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="app_name" id="app_name" required value="<?= $settings->app_name ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="app_description" class="col-sm-2 col-form-label"><?= lang('Dashboard.appDescription') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="app_description" id="app_description" required value="<?= $settings->app_description ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="website_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.websiteUrl') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="website_url" id="website_url" placeholder="http://www.Domain.com" required value="<?= $settings->website_url ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="installation_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.installationUrl') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="installation_url" id="installation_url" placeholder="http://www.Domain.com" required value="<?= $settings->installation_url ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="terms_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.termsUrl') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="terms_url" id="terms_url" placeholder="http://www.Domain.com" required value="<?= $settings->terms_url ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="android_app_dl_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.androidAppDlUrl') ?></label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="android_app_dl_url" id="android_app_dl_url" placeholder="http://www.Domain.com/dl/app.apk" required value="<?= $settings->android_app_dl_url ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="android_app_dl_url2" class="col-sm-2 col-form-label"><?= lang('Dashboard.androidAppDlUrl') ?>2</label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="android_app_dl_url2" id="android_app_dl_url2" placeholder="http://www.MirrorDomain.com/dl/app.apk" value="<?= $settings->android_app_dl_url2 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email_address" class="col-sm-2 col-form-label"><?= lang('Dashboard.emailAddress') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="email" class="form-control" name="email_address" id="email_address" placeholder="info@YourDomain.com" required value="<?= $settings->email_address ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone1" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone1') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="phone1" id="phone1" value="<?= $settings->phone1 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone2" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone2') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="phone2" id="phone2" value="<?= $settings->phone2 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone3" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone3') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="phone3" id="phone3" value="<?= $settings->phone3 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone4" class="col-sm-2 col-form-label"><?= lang('Dashboard.phone4') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="phone4" id="phone4" value="<?= $settings->phone4 ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="working_hours" class="col-sm-2 col-form-label"><?= lang('Dashboard.workingHours') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="working_hours" id="working_hours" value="<?= $settings->working_hours ?>">
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="form-group row">
                                            <label for="address" class="col-sm-2 col-form-label"><?= lang('Dashboard.address') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="address" id="address" value="<?= $settings->address ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="latitude" class="col-sm-2 col-form-label"><?= lang('Dashboard.latitude') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="latitude" id="latitude" placeholder="Latitude" value="<?= $settings->latitude ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="longitude" class="col-sm-2 col-form-label"><?= lang('Dashboard.longitude') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="longitude" id="longitude" placeholder="Longitude" value="<?= $settings->longitude ?>">
                                                <small class="text-info"><?= lang('Dashboard.youCanUseAboveWebsiteToGenerateLocation', ['www.LatLong.net']) ?></small>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="longitude" class="col-sm-2 col-form-label"><?= lang('Dashboard.timezone') ?> *</label>
                                            <div class="col-sm-10">
                                                <?= timezone_select('form-control select2bs4', $settings->timezone); ?>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="calendar_type" class="col-sm-2 col-form-label"><?= lang('Dashboard.calendarType') ?>* </label>
                                            <div class="col-sm-10">
                                                <?php
                                                $selected1 = $selected2 = "";
                                                if($settings->calendar_type == "Date") $selected1 = "selected";
                                                if($settings->calendar_type == "jDate") $selected2 = "selected";
                                                ?>
                                                <select class="form-control select2bs4" name="calendar_type" id="calendar_type" required>
                                                    <option <?= $selected1 ?> value="Date"><?= lang('Dashboard.gregorianCalendar') ?></option>
                                                    <option <?= $selected2 ?> value="jDate"><?= lang('Dashboard.solarCalendar') ?></option>
                                                </select>
                                            </div>
                                        </div>

                                        <hr>
                                        <div class="form-group row">
                                            <label for="vat_rate" class="col-sm-2 col-form-label"><?= lang('Dashboard.vatRate') ?> (<?= lang('Dashboard.percentage') ?>) *</label>
                                            <div class="col-sm-10">

                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><strong>%</strong></span>
                                                    </div>
                                                    <input type="text" class="form-control" name="vat_rate" id="vat_rate" placeholder="vat_rate" value="<?= $settings->vat_rate ?>" required>
                                                </div>
                                                <small class="text-info"><?= lang('Dashboard.enterZeroToDeactivateThisSection', ['www.LatLong.net']) ?></small>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="vat_payable" class="col-sm-2 col-form-label"><?= lang('Dashboard.vatPayable') ?> *</label>
                                            <div class="col-sm-10">
                                                <?php
                                                $selected1 = $selected2 = "";
                                                if($settings->vat_payable == "1") $selected1 = "selected";
                                                if($settings->vat_payable == "2") $selected2 = "selected";
                                                ?>
                                                <select class="form-control" name="vat_payable" id="vat_payable" required>
                                                    <option <?= $selected1 ?> value="1"><?= lang('Dashboard.user') ?></option>
                                                    <option <?= $selected2 ?> value="2"><?= lang('Dashboard.owner') ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="form-group row">
                                            <label for="bank_account" class="col-sm-2 col-form-label"><?= lang('Dashboard.bankAccount') ?></label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" name="bank_account" rows="3" dir="ltr"><?= $settings->bank_account ?></textarea>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="form-group row">
                                            <label for="licenses_and_certificates" class="col-sm-2 col-form-label"><?= lang('Dashboard.licensesAndCertificates') ?></label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" name="licenses_and_certificates" rows="3" dir="ltr"><?= $settings->licenses_and_certificates ?></textarea>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="form-group row">
                                            <label for="show_advertising" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->show_advertising == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="show_advertising" id="show_advertising" <?= $checked ?>>
                                                    <label for="show_advertising" class="custom-control-label"><?= lang('Dashboard.showInternalAdvertising') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="switch_language" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->switch_language == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="switch_language" id="switch_language" <?= $checked ?>>
                                                    <label for="switch_language" class="custom-control-label"><?= lang('Dashboard.languageSwitchFeatureEnabled') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email_verification" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->email_verification == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="email_verification" id="email_verification" <?= $checked ?>>
                                                    <label for="email_verification" class="custom-control-label"><?= lang('Dashboard.usersShouldVerifyTheirEmailAddressBeforeLoggingIn') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="registration" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->registration == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="registration" id="registration" <?= $checked ?>>
                                                    <label for="registration" class="custom-control-label"><?= lang('Dashboard.newUserMembershipEnabled') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="configuration">
                                                <?php
                                                $role_id = $session->role_id;
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                                <p class="pt-2 i-text-small text-info"><?= lang('Dashboard.thisDataWillBeUpdatedForXLanguageOnly', [$defaultLanguage->title]) ?></p>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->
                                    <div class="<?php if($active_tab == "social_media") echo "active"; ?> tab-pane" id="social_media">

                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading2()'];
                                        echo form_open('dashboard/update-social-media', $attributes);
                                        // To upload file: form_open_multipart
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="facebook" class="col-sm-2 col-form-label"><?= lang('Dashboard.facebook') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="facebook" id="facebook" value="<?= $settings->facebook ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="instagram" class="col-sm-2 col-form-label"><?= lang('Dashboard.instagram') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="instagram" id="instagram" value="<?= $settings->instagram ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="whatsapp" class="col-sm-2 col-form-label"><?= lang('Dashboard.whatsapp') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="whatsapp" id="facebook" value="<?= $settings->whatsapp ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="telegram" class="col-sm-2 col-form-label"><?= lang('Dashboard.telegram') ?></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="telegram" id="telegram" value="<?= $settings->telegram ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="skype" class="col-sm-2 col-form-label"><?= lang('Dashboard.skype') ?></label>
                                            <div class="col-sm-10">
                                                <input type="skype" class="form-control" name="skype" id="skype" value="<?= $settings->skype ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="twitter" class="col-sm-2 col-form-label"><?= lang('Dashboard.twitter') ?></label>
                                            <div class="col-sm-10">
                                                <input type="twitter" class="form-control" name="twitter" id="twitter" value="<?= $settings->twitter ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="linkedin" class="col-sm-2 col-form-label"><?= lang('Dashboard.linkedin') ?></label>
                                            <div class="col-sm-10">
                                                <input type="linkedin" class="form-control" name="linkedin" id="linkedin" value="<?= $settings->linkedin ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="custom" class="col-sm-2 col-form-label"><?= lang('Dashboard.custom') ?></label>
                                            <div class="col-sm-10">
                                                <input type="skype" class="form-control" name="custom" id="custom" value="<?= $settings->custom ?>">
                                            </div>
                                        </div>

                                        <br>

                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="social_media">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton2" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                                <p class="pt-2 i-text-small text-info"><?= lang('Dashboard.thisDataWillBeUpdatedForXLanguageOnly', [$defaultLanguage->title]) ?></p>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->
                                    <div class="<?php if($active_tab == "third_party_apps") echo "active"; ?> tab-pane" id="third_party_apps">

                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading3()'];
                                        echo form_open('dashboard/update-third-party-apps', $attributes);
                                        // To upload file: form_open_multipart
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="onesignal_app_id" class="col-sm-2 col-form-label"><?= lang('Dashboard.oneSignalAppId') ?></label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="onesignal_app_id" id="onesignal_app_id" value="<?= $settings->onesignal_app_id ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="onesignal_rest_api_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.oneSignalRestApiKey') ?></label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="onesignal_rest_api_key" id="onesignal_rest_api_key" value="<?= $settings->onesignal_rest_api_key ?>">
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="form-group row">
                                            <label for="youtube_api_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.youtubeApiKey') ?></label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="youtube_api_key" id="youtube_api_key" value="<?= $settings->youtube_api_key ?>">
                                                <small class="text-info"><?= lang('Dashboard.generateYouTubeApiKeyFrom', ['https://console.developers.google.com']) ?></small>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="form-group row">
                                            <label for="google_map_api_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.googleMapApiKey') ?></label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="google_map_api_key" id="google_map_api_key" value="<?= $settings->google_map_api_key ?>">
                                                <small class="text-info"><?= lang('Dashboard.generateGoogleMapApiKeyFrom', ['https://console.developers.google.com']) ?></small>
                                            </div>
                                        </div>

                                        <br>

                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="third_party_apps">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton3" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "captcha") echo "active"; ?> tab-pane" id="captcha">

                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading4()'];
                                        echo form_open('dashboard/update-captcha-protection', $attributes);
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="captcha_protection" class="col-sm-2 col-form-label"><?= lang('Dashboard.enableCaptcha') ?></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($captchaProtection->captcha_protection_website == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="captcha_protection_website" id="captcha_protection_website" <?= $checked ?>>
                                                    <label for="captcha_protection_website" class="custom-control-label"><?= lang('Dashboard.enableCaptchaFormsProtection') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="captcha_type" class="col-sm-2 col-form-label"><?= lang('Dashboard.captchaType') ?> *</label>
                                            <div class="col-sm-10">
                                                <?php
                                                $checked1 = $checked2 = $checked3 = "";
                                                if($captchaProtection->captcha_type == 1) $checked1 = "checked";
                                                if($captchaProtection->captcha_type == 2) $checked2 = "checked";
                                                if($captchaProtection->captcha_type == 3) $checked3 = "checked";
                                                ?>
                                                <div class="row">
                                                    <div class="col">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" class="custom-control-input" name="captcha_type" id="1" value="1" disabled <?= $checked1 ?>>
                                                            <label for="1" class="custom-control-label"><?= lang('Dashboard.classicCaptcha') ?></label>
                                                            <br>
                                                            <img src="<?= base_url("backend/assets/images/captcha.png") ?>" alt="Classic CAPTCHA" width="267" height="71"> 
                                                        </div>
                                                    </div>
                                                    <div class="col">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" class="custom-control-input" name="captcha_type" id="2" value="2" <?= $checked2 ?>>
                                                            <label for="2" class="custom-control-label"><?= lang('Dashboard.googleReCaptchaV2') ?></label>
                                                            <br>
                                                            <img src="<?= base_url("backend/assets/images/recaptcha_v2.gif") ?>" alt="Google reCAPTCHA v2" width="267" height="70"> 
                                                        </div>
                                                    </div>
                                                    <div class="col">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" class="custom-control-input" name="captcha_type" id="3" value="3" <?= $checked3 ?>>
                                                            <label for="3" class="custom-control-label"><?= lang('Dashboard.googleReCaptchaV3') ?></label>
                                                            <br>
                                                            <img src="<?= base_url("backend/assets/images/recaptcha_v3.png") ?>" alt="Google reCAPTCHA v3" width="267" height="70"> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="recaptcha_v2_site_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.recaptchaV2SiteKey') ?> <span id="site_key_v2_star" class="text-danger d-none">*</span></label>

                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="recaptcha_v2_site_key" id="recaptcha_v2_site_key" value="<?= $captchaProtection->recaptcha_v2_site_key ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="recaptcha_v2_secret_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.recaptchaV2SecretKey') ?> <span id="secret_key_v2_star" class="text-danger d-none">*</span></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="recaptcha_v2_secret_key" id="recaptcha_v2_secret_key" value="<?= base64_decode(strrev(base64_decode($captchaProtection->recaptcha_v2_secret_key))) ?>">
                                                <small class="text-info"><?= lang('Dashboard.registerAreCaptchaV2', ['www.google.com/recaptcha/admin/create']) ?></small>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="recaptcha_v3_site_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.recaptchaV3SiteKey') ?> <span id="site_key_v3_star" class="text-danger d-none">*</span></label>

                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="recaptcha_v3_site_key" id="recaptcha_v3_site_key" value="<?= $captchaProtection->recaptcha_v3_site_key ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="recaptcha_v3_secret_key" class="col-sm-2 col-form-label"><?= lang('Dashboard.recaptchaV3SecretKey') ?> <span id="secret_key_v3_star" class="text-danger d-none">*</span></label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="recaptcha_v3_secret_key" id="recaptcha_v3_secret_key" value="<?= base64_decode(strrev(base64_decode($captchaProtection->recaptcha_v3_secret_key))) ?>">
                                                <small class="text-info"><?= lang('Dashboard.registerAreCaptchaV3', ['www.google.com/recaptcha/admin/create']) ?></small>
                                            </div>
                                        </div>

                                        <br>

                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="captcha">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton4" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->

                                    <div class="<?php if($active_tab == "maintenance") echo "active"; ?> tab-pane" id="maintenance">

                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading5()'];
                                        echo form_open('dashboard/update-maintenance-mode', $attributes);
                                        // To upload file: form_open_multipart
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="maintenance_text" class="col-sm-2 col-form-label"><?= lang('Dashboard.maintenanceText') ?> *</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="3" name="maintenance_text" id="maintenance_text" required><?= $settings->maintenance_text ?></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="maintenance_force_url" class="col-sm-2 col-form-label"><?= lang('Dashboard.maintenanceForceUrl') ?></label>
                                            <div class="col-sm-10">
                                                <input type="url" class="form-control" name="maintenance_force_url" id="maintenance_force_url" placeholder="example: https://www.Domain.com/maintenance-mode" value="<?= $settings->maintenance_force_url ?>">
                                                <small class="text-info"><?= lang('Dashboard.onlyEnterIfYouWantTheUserToBeTransferredDirectlyToAnotherUrl') ?></small>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="maintenance_website" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->maintenance_website == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="maintenance_website" id="maintenance_website" <?= $checked ?>>
                                                    <label for="maintenance_website" class="custom-control-label"><?= lang('Dashboard.enableMaintenanceModeForWebsiteVersion') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="maintenance_mobile" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->maintenance_mobile == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="maintenance_mobile" id="maintenance_mobile" <?= $checked ?>>
                                                    <label for="maintenance_mobile" class="custom-control-label"><?= lang('Dashboard.enableMaintenanceModeForMobileVersion') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="maintenance_android" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->maintenance_android == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="maintenance_android" id="maintenance_android" <?= $checked ?>>
                                                    <label for="maintenance_android" class="custom-control-label"><?= lang('Dashboard.enableMaintenanceModeForAndroidVersion') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="maintenance_ios" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->maintenance_ios == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="maintenance_ios" id="maintenance_ios" <?= $checked ?>>
                                                    <label for="maintenance_ios" class="custom-control-label"><?= lang('Dashboard.enableMaintenanceModeForIosVersion') ?></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="maintenance_other" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="custom-control custom-checkbox">
                                                    <?php
                                                    $checked = "";
                                                    if($settings->maintenance_other == 1) $checked = "checked";
                                                    ?>
                                                    <input type="checkbox" class="custom-control-input" name="maintenance_other" id="maintenance_other" <?= $checked ?>>
                                                    <label for="maintenance_other" class="custom-control-label"><?= lang('Dashboard.enableMaintenanceModeForOtherVersion') ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <br>
                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="maintenance">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton5" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                                <p class="pt-2 i-text-small text-info"><?= lang('Dashboard.thisDataWillBeUpdatedForXLanguageOnly', [$defaultLanguage->title]) ?></p>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->                                    

                                    <div class="<?php if($active_tab == "seo_tools") echo "active"; ?> tab-pane" id="seo_tools">

                                        <?php
                                        $attributes = ['class' => 'form-horizontal', 'onsubmit' => 'buttonLoading6()'];
                                        echo form_open('dashboard/update-seo-tools', $attributes);
                                        // To upload file: form_open_multipart
                                        ?>
                                        <?= csrf_field() ?>

                                        <div class="form-group row">
                                            <label for="seo_meta_description" class="col-sm-2 col-form-label"><?= lang('Dashboard.metaTagDescription') ?> *</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="3" name="seo_meta_description" id="seo_meta_description" placeholder="<?= lang('Dashboard.Description2_3SentencesAndDoNotUseLineBreaksAndAtLeast70To150Characters') ?>" required><?= $settings->seo_meta_description ?></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="seo_meta_keywords" class="col-sm-2 col-form-label"><?= lang('Dashboard.metaTagKeywords') ?> *</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="3" name="seo_meta_keywords" id="seo_meta_keywords" placeholder="<?= lang('Dashboard.keywordsSeparatedByCommasUpTo255Characters') ?>" required><?= $settings->seo_meta_keywords ?></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="seo_meta_author" class="col-sm-2 col-form-label"><?= lang('Dashboard.metaTagAuthor') ?> *</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="seo_meta_author" id="seo_meta_author" placeholder="<?= lang('Dashboard.authorForPage') ?>" value="<?= $settings->seo_meta_author ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <input type="hidden" readonly name="active_tab" value="seo_tools">
                                                <?php
                                                if($role_id != 9 AND $role_id != 19)
                                                {
                                                    ?>
                                                    <button type="submit" id="submitButton6" class="btn btn-outline-primary" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                                    <?php
                                                }else{
                                                    ?>
                                                    <button type="button" disabled class="btn btn-outline-danger"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                                    <?php
                                                }
                                                ?>
                                                <p class="pt-2 i-text-small text-info"><?= lang('Dashboard.thisDataWillBeUpdatedForXLanguageOnly', [$defaultLanguage->title]) ?></p>
                                            </div>
                                        </div>

                                        <?= form_close(); ?>

                                    </div>
                                    <!-- /.tab-pane -->
                                     
                                </div>
                                <!-- /.tab-content -->
                            </div><!-- /.card-body -->
                        </div>
                        <!-- /.nav-tabs-custom -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Function to handle the visibility of required stars and setting input as required
    function updateCaptchaFields() {
        const captchaType = document.querySelector('input[name="captcha_type"]:checked').value;

        // Get input elements
        const recaptchaV2SiteKeyInput = document.getElementById('recaptcha_v2_site_key');
        const recaptchaV2SecretKeyInput = document.getElementById('recaptcha_v2_secret_key');
        const recaptchaV3SiteKeyInput = document.getElementById('recaptcha_v3_site_key');
        const recaptchaV3SecretKeyInput = document.getElementById('recaptcha_v3_secret_key');

        // Hide all stars and remove required attribute by default
        document.getElementById('site_key_v2_star').classList.add('d-none');
        document.getElementById('secret_key_v2_star').classList.add('d-none');
        document.getElementById('site_key_v3_star').classList.add('d-none');
        document.getElementById('secret_key_v3_star').classList.add('d-none');

        recaptchaV2SiteKeyInput.required = false;
        recaptchaV2SecretKeyInput.required = false;
        recaptchaV3SiteKeyInput.required = false;
        recaptchaV3SecretKeyInput.required = false;

        // Show relevant stars and set required attribute based on selected captcha type
        if (captchaType == '2') {
            document.getElementById('site_key_v2_star').classList.remove('d-none');
            document.getElementById('secret_key_v2_star').classList.remove('d-none');
            recaptchaV2SiteKeyInput.required = true;
            recaptchaV2SecretKeyInput.required = true;
        } else if (captchaType == '3') {
            document.getElementById('site_key_v3_star').classList.remove('d-none');
            document.getElementById('secret_key_v3_star').classList.remove('d-none');
            recaptchaV3SiteKeyInput.required = true;
            recaptchaV3SecretKeyInput.required = true;
        }
    }

    // Attach event listeners to radio buttons
    document.querySelectorAll('input[name="captcha_type"]').forEach(function (radio) {
        radio.addEventListener('change', updateCaptchaFields);
    });

    // Initial call to set the correct stars and required attributes based on the initial selected value
    updateCaptchaFields();
});

</script>
<?= $this->endSection() ?>