<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    
                    <div class="col-md-12">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.description') ?></th>
                                        <th><?= lang('Dashboard.image') ?></th>
                                        <th><?= lang('Dashboard.order') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th style="width: 90px; min-width: 90px;"><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($gateways as $gateway)
                                    {
                                        $status = "<span class='badge badge-warning'>".lang('Dashboard.inactive')."</span>";
                                        if($gateway->status == 1) $status = "<span class='center badge badge-success'>".lang('Dashboard.active')."</span>";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $gateway->title; ?></td>
                                            <td class="align-middle"><?= $gateway->description; ?></td>
                                            <td class="align-middle"><img width="50px" height="auto" src="<?= base_url("backend/assets/uploads/admins/payment_gateways/$gateway->image"); ?>" class="img-rounded" alt="<?= $gateway->description ?>"></td>
                                            <td class="align-middle"><?= $gateway->order; ?></td>
                                            <td class="align-middle"><?= $status ?></td>
                                            
                                            <td class="align-middle">
                                                <div class="dropdown">
                                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown">
                                                        <?= lang('Dashboard.action') ?>
                                                    </button>
                                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>">
                                                        <a class="dropdown-item" title="<?= lang('Dashboard.editGateway') ?>" href="<?= base_url('dashboard/edit-payment-gateway/'.$gateway->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i> <?= lang('Dashboard.editGateway') ?></a>
                                                        <a class="dropdown-item" title="<?= lang('Dashboard.editMerchantKey') ?>" href="<?= base_url('dashboard/edit-merchant-key/'.$gateway->title) ?>" class="text-success p-1"><i class="fas fa-edit"></i> <?= lang('Dashboard.editMerchantKey') ?></a>
                                                        <div class="dropdown-divider"></div> 
                                                        <a class="dropdown-item text-danger" title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-gateway/'.$gateway->id); ?>" onclick="confirmAction(event, '<?= lang('Dashboard.delete') ?>', '<?= lang('Dashboard.areYouSureYouWantToDeleteX', [$gateway->description]) ?>', 'warning', this);"><i class="fas fa-trash-alt"></i> <?= lang('Dashboard.delete') ?></a>
                                                    </div>
                                                </div> 
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table><br>
                                <?php
                                if(empty($gateways)) echo "<p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>

                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
<script>
// Pass language variables to confirmAction function.
var lang_yes = "<?= lang('Dashboard.yes') ?>";
var lang_no = "<?= lang('Dashboard.no') ?>";
</script>
<?= $this->endSection() ?>