<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.settings') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-md-7">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/general-settings') ?>" class="dropdown-item"><?= lang('Dashboard.generalSettings') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-email-settings') ?>" method="post" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="protocol" class="col-sm-3 col-form-label"><?= lang('Dashboard.protocol') ?> *</label>
                                        <div class="col-sm-9">
                                            <?php
                                            $selected1 = $selected2 = $selected3 = "";
                                            if($emailSettings->protocol == "mail") $selected1 = "selected";
                                            if($emailSettings->protocol == "sendmail") $selected2 = "selected";
                                            if($emailSettings->protocol == "smtp") $selected3 = "selected";
                                            ?>
                                            <select class="form-control" name="protocol" id="protocol" required>
                                                <option <?= $selected1 ?> value="mail">mail</option>
                                                <option <?= $selected2 ?> value="sendmail">sendmail</option>
                                                <option <?= $selected3 ?> value="smtp">smtp</option>
                                            </select>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="from_email" class="col-sm-3 col-form-label"><?= lang('Dashboard.fromEmail') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" name="from_email" value="<?= $emailSettings->from_email ?>" placeholder="<?= lang('Dashboard.fromEmail') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="no_reply_email" class="col-sm-3 col-form-label"><?= lang('Dashboard.noReplyFromEmail') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control" name="no_reply_email" value="<?= $emailSettings->no_reply_email ?>" placeholder="<?= lang('Dashboard.noReplyFromEmail') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="from_name" class="col-sm-3 col-form-label"><?= lang('Dashboard.fromName') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="from_name" value="<?= $emailSettings->from_name ?>" placeholder="<?= lang('Dashboard.fromName') ?>" required>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <label for="smtp_host" class="col-sm-3 col-form-label"><?= lang('Dashboard.smtpHost') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="smtp_host" value="<?= $emailSettings->smtp_host ?>" placeholder="<?= lang('Dashboard.smtpHost') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="smtp_user" class="col-sm-3 col-form-label"><?= lang('Dashboard.smtpUser') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="smtp_user" value="<?= $emailSettings->smtp_user ?>" placeholder="<?= lang('Dashboard.smtpUser') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="smtp_pass" class="col-sm-3 col-form-label"><?= lang('Dashboard.smtpPass') ?></label>
                                        <div class="col-sm-9">
                                            <input type="password" class="form-control" name="smtp_pass" value="<?= base64_decode(strrev(base64_decode($emailSettings->smtp_pass))) ?>" placeholder="<?= lang('Dashboard.smtpPass') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="smtp_port" class="col-sm-3 col-form-label"><?= lang('Dashboard.smtpPort') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="smtp_port" value="<?= $emailSettings->smtp_port ?>" placeholder="<?= lang('Dashboard.smtpPort') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="smtp_crypto" class="col-sm-3 col-form-label"><?= lang('Dashboard.smtpCrypto') ?></label>
                                        <div class="col-sm-9">
                                            <?php
                                            $selected1 = $selected2 = "";
                                            if($emailSettings->smtp_crypto == "tls") $selected1 = "selected";
                                            if($emailSettings->smtp_crypto == "ssl") $selected2 = "selected";
                                            ?>
                                            <select class="form-control" name="smtp_crypto" id="smtp_crypto" required>
                                                <option <?= $selected1 ?> value="tls">tls</option>
                                                <option <?= $selected2 ?> value="ssl">ssl</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-md-5">
                        <!-- Default box -->
                        <div class="card card-outline card-info" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.guide') ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">

                                    </div>

                                </div>
                            </div>
                            <div class="card-body">
                                <h5><?= lang('Dashboard.mailSendmailProtocol') ?></h5>
                                <p><?= lang('Dashboard.mailProtocolGuideText') ?></p>
                                <hr>
                                <h5><?= lang('Dashboard.smtpProtocol') ?></h5>
                                <p><?= lang('Dashboard.smtpProtocolGuideText') ?></p>
                                <hr>
                                <h5><?= lang('Dashboard.defaultGmailSettings') ?></h5>
                                <p class="text-left text-muted">SMTP Host: smtp.googlemail.com<br>
                                    SMTP User: YourEmail@gmail.com<br>
                                    SMTP Pass: Your Gmail Password<br>
                                    SMTP Port: 465<br>
                                    SMTP Crypto: ssl
                                </p>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>