<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="i-text-extrabold"><?= $pageSubTitle; ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                        <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                        <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <?= view('App\Views\backend\common\notifications_view'); ?>
        </div>
    </section>
    <!-- /.content -->

    <!-- User Note / Users Activity -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <!-- Default box -->
                    <div class="card card-outline card-primary" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.activity') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                        <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-body p-0">
                            <div style="height: 246px; overflow-y: scroll;">
                                <table class="table table-hover table-striped table-sm">
                                    <thead>
                                    <tr>
                                        <th><?= lang('Dashboard.title') ?></th>
                                        <th><?= lang('Dashboard.activity') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.time') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($activities as $activity)
                                    {
                                        ?>
                                        <tr class="i-text-small">
                                            <td><?= $activity->title; ?></td>
                                            <td><?= $activity->body; ?></td>
                                            <td><?= $activity->ip; ?></td>
                                            <td><?= timespan($activity->time, time(), 2)." ".lang('Date.ago'); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>

                <div class="col-md-4">
                    <!-- Default box -->
                    <div class="card card-outline card-info" id="myCard">
                        <div class="card-header">
                            <h3 class="card-title"><?= lang('Dashboard.note') ?></h3>
                            <div class="card-tools">
                                <div class="btn-group">

                                </div>

                            </div>
                        </div>
                        <form class="form-horizontal" data-form-type="edit_user_note" data-action="<?= base_url('dashboard/perform-edit-user-note') ?>">
                            <?= csrf_field() ?>
                            <div class="card-body">
                                <div class="form-group row">
                                    <textarea rows="5" class="form-control" name="user_note" placeholder="<?= lang('Dashboard.note') ?>"><?= $userNote->user_note ?></textarea>
                                </div>
                            </div>

                        <div class="card-footer">
                            <?php
                            $session = session();
                            $role_id = $session->role_id;
                            if($role_id != 9 AND $role_id != 19)
                            {
                                ?>
                                <input type="hidden" name="id" readonly required value="<?= service('uri')->getSegment(3) ?>">
                                <button type="submit" id="submitButton" class="submitButton btn btn-sm btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.update') ?>"><?= lang('Dashboard.update') ?></button>
                                <?php
                            }else{
                                ?>
                                <button type="button" disabled class="submitButton btn btn-sm btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.update') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                <?php
                            }
                            ?>
                        </div>
                        </form>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?= $this->endSection() ?>