<?php
$db = db_connect();
// Total ticket (not closed)
$query = $db->table('mod_support_tickets_tbl');
$totalTickets = $query->where('user_id', $userId)->where('status !=', 'Closed')->where('status !=', 'Open')->where('status !=', 'User_Reply')->where('read_by_user', 'No')->where('deleted_at', null)->countAllResults();

$db->close();

$totalNotifications = 0;
if($totalTickets > 0)
    $totalNotifications = $totalNotifications + 1;
?>
<!-- Navbar -->
<nav class="main-header navbar navbar-expand <?php $session = session(); if($session->dark_mode == 1) echo "navbar-dark"; else echo "navbar-dark"; ?> ">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a target="_blank" href="<?= base_url() ?>" class="nav-link"><?= lang('Dashboard.website') ?></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="<?= base_url('auth/logout') ?>" class="nav-link"><?= lang('Dashboard.logout') ?></a>
        </li>
    </ul>
	
	<div class="d-flex justify-content-center w-100">
        <div id="navbarLoadingSpinner" class="spinner-border text-light d-none" role="status">
            <span class="sr-only"><?= lang('Dashboard.loading') ?></span>
        </div>
    </div>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <!-- Full Screen -->
        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>

        <!-- Notifications Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell"></i>
                <?php
                if($totalNotifications > 0)
                {
                ?>
                <span class="badge badge-warning navbar-badge"><?= $totalNotifications ?></span>
                <?php
                }
                ?>
            </a>
            <div class="dropdown-menu dropdown-menu-lg <?= lang('Dashboard.dropdown-menu-xxx') ?>">
                <span class="dropdown-item dropdown-header my-navbar-margin-t"><?= lang('Dashboard.notifications', [$totalNotifications]) ?></span>
                <div class="dropdown-divider"></div>
                
                <?php
                if($totalTickets > 0)
                {
                ?>
                <small>
                    <a href="<?= base_url('dashboard/my-tickets/?status=All') ?>" class="dropdown-item">
                        <i class="far fa-life-ring mr-2"></i> <?= lang('Dashboard.supportTicketPendingReview', [$totalTickets]) ?>
                    </a>
                </small>
                <?php
                }
                ?>

                <div class="dropdown-divider"></div>

                <a href="#" class="dropdown-item dropdown-footer my-navbar-margin-b"><?= lang('Dashboard.seeAllNotifications') ?></a>
            </div>
        </li>

        <!-- Language Dropdown Menu -->
        <?php
        $display = "";
        if($settingsData->switch_language == 0)
            $display = "d-none";
        ?>
        <li class="nav-item dropdown <?= $display ?>">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="flag-icon <?= $defaultLanguage->flag ?>"></i>
                <span class="badge badge-dark navbar-badge"><?= $defaultLanguage->locale ?></span>
            </a>
            <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?> p-0">
                <?php
                foreach ($languagesData as $row)
                {
                    $session = session();
                    $active = "";
                    if($session->lang == $row->locale)
                        $active = "active"
                ?>
                <a href="<?= base_url('lang')."/".$row->locale ?>" class="dropdown-item <?= $active ?> my-navbar-margin-bt"><i class="flag-icon <?= $row->flag ?> mr-2"></i> <?= $row->title ?></a>
                <?php
                }
                ?>
            </div>
        </li>

        <!-- User Profile -->
        <li class="nav-item dropdown user-menu">
            <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
                <img src="<?= base_url('backend/assets/uploads/users/profile/thumb/'.$session->image) ?>" class="user-image img-circle elevation-2" alt="User Image">
                <span class="d-none d-md-inline"><?= $session->first_name." ".$session->last_name ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-lg <?= lang('Dashboard.dropdown-menu-xxx') ?>">
                <!-- User image -->
                <li class="user-header bg-primary">
                    <img src="<?= base_url('backend/assets/uploads/users/profile/thumb/'.$session->image) ?>" class="img-circle elevation-2" alt="User Image">
                    <p><?= $session->first_name." ".$session->last_name ?> <small><?= $session->email ?></small></p>
                </li>
                <!-- Menu Body -->
                <li class="user-body" style="display: none">
                    <div class="row">
                        <div class="col-4 text-center">
                            <a href="#">Followers</a>
                        </div>
                        <div class="col-4 text-center">
                            <a href="#">Sales</a>
                        </div>
                        <div class="col-4 text-center">
                            <a href="#">Friends</a>
                        </div>
                    </div>
                    <!-- /.row -->
                </li>
                <!-- Menu Footer-->
                <li class="user-footer">
                    <a href="<?= base_url('dashboard/profile') ?>" class="btn btn-default btn-sm"><?= lang('Dashboard.myProfile') ?></a>
                    <a href="<?= base_url('auth/logout') ?>" class="btn btn-default btn-sm <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.logout') ?></a>
                </li>
            </ul>
        </li>

    </ul>
</nav>
<!-- /.navbar -->