<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.categories') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/categories-list') ?>" class="dropdown-item"><?= lang('Dashboard.categoriesList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-edit-category') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= $category->title ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="icon" class="col-sm-3 col-form-label"><?= lang('Dashboard.icon') ?> <small class="text-muted">(FontAwesome)</small></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="icon" id="icon" placeholder="fas fa-list" dir="ltr" value="<?= $category->icon ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="color" class="col-sm-3 col-form-label"><?= lang('Dashboard.color') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="color" id="color" placeholder="#FF0000" dir="ltr" value="<?= $category->color ?>">
                                        </div>
                                    </div>

                                    <!--<div class="form-group row">
                                        <label for="role_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.userRole') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="role_id" id="role_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($roles as $role)
                                                {
                                                ?>
                                                    <option value="<?= $role->id ?>"><?= $role->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>-->
                                    <div class="form-group row">
                                        <label for="parent_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.parentCategory') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="parent_id" id="parent_id" required>
                                                <option value="0"><?= lang('Dashboard.withoutParent') ?></option>
                                                <?php
                                                foreach ($mainCategories as $mainCategory)
                                                {
                                                    $selected = "";
                                                    if($mainCategory->id == $category->parent_id)
                                                        $selected = "selected";
                                                ?>
                                                    <option <?= $selected ?> value="<?= $mainCategory->id ?>">◼ <?= $mainCategory->title ?></option>

                                                    <?php
                                                    //To get sub category 1
                                                    $db = db_connect();
                                                    $builder = $db->table('categories_tbl');
                                                    $builder->where('locale', $locale);
                                                    $builder->where('deleted_at', NULL);
                                                    $builder->where('status', 1);
                                                    $builder->where('parent_id', $mainCategory->id);
                                                    //$builder->where('type_id', 3);
                                                    $subCategory1 = $builder->get()->getResult();
                                                    foreach($subCategory1 as $sKey1)
                                                    {
                                                        $selected1 = "";
                                                        if($sKey1->id == $category->parent_id) $selected1 = "selected";

                                                        echo "<option $selected1 value='$sKey1->id'>&nbsp;&nbsp;&nbsp;&nbsp;◾&nbsp;$sKey1->title</option>";

                                                        //To get sub sub category 2
                                                        $builder->where('parent_id', $sKey1->id);
                                                        //$builder->where('type_id', 3);
                                                        $builder->where('deleted_at', NULL);
                                                        $subSubCategory2 = $builder->get()->getResult();
                                                        foreach($subSubCategory2 as $ssKey2)
                                                        {
                                                            $selected2 = "";
                                                            if($ssKey2->id == $category->parent_id) $selected2 = "selected";

                                                            echo "<option $selected2 value='$ssKey2->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◆&nbsp;$ssKey2->title</option>";

                                                            //To get sub sub sub category 3
                                                            $builder->where('parent_id', $ssKey2->id);
                                                            //$builder->where('type_id', 3);
                                                            $builder->where('deleted_at', NULL);
                                                            $subSubCategory3 = $builder->get()->getResult();
                                                            foreach($subSubCategory3 as $sssKey3)
                                                            {
                                                                $selected3 = "";
                                                                if($sssKey3->id == $category->parent_id) $selected3 = "selected";

                                                                echo "<option $selected3 value='$sssKey3->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◈&nbsp;$sssKey3->title</option>";
                                                            }
                                                        }
                                                    }
                                                    $db->close();
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="type_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.type') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="type_id" id="type_id" required>
                                                <?php
                                                foreach ($categoriesTypes as $categoryType)
                                                {
                                                    $selected = "";
                                                    if($categoryType->id == $category->type_id)
                                                        $selected = "selected";
                                                ?>
                                                    <option <?= $selected ?> value="<?= $categoryType->id ?>"><?= $categoryType->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="order" class="col-sm-3 col-form-label"><?= lang('Dashboard.order') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="number" class="form-control" name="order" id="order" placeholder="<?= lang('Dashboard.order') ?>" value="<?= $category->order ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?></label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 256, 256 ]) ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 200 ]) ?></small>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <?php
                                                    $checked = "";
                                                    if($category->status == '1')
                                                        $checked = "checked";
                                                    ?>
                                                    <input name="status" <?= $checked ?> type="checkbox"> <?= lang('Dashboard.enableThisCategory') ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" name="id" value="<?= $category->id ?>" readonly>
                                    <input type="hidden" name="old_image" value="<?= $category->image ?>" readonly>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.editCategory') ?>"><?= lang('Dashboard.editCategory') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.editCategory') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>