<?php
$this->session = session();
$locale = $this->session->lang;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.categories') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/categories-list') ?>" class="dropdown-item"><?= lang('Dashboard.categoriesList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-create-category') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= old('title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="icon" class="col-sm-3 col-form-label"><?= lang('Dashboard.icon') ?> <small class="text-muted">(FontAwesome)</small></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="icon" id="icon" placeholder="fas fa-list" dir="ltr" value="<?= old('icon') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="color" class="col-sm-3 col-form-label"><?= lang('Dashboard.color') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="color" id="color" placeholder="#FF0000" dir="ltr" value="<?= old('color') ?>">
                                        </div>
                                    </div>

                                    <!--<div class="form-group row">
                                        <label for="role_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.userRole') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="role_id" id="role_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($roles as $role)
                                                {
                                                ?>
                                                    <option value="<?= $role->id ?>"><?= $role->title ?></option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>-->
                                    <div class="form-group row">
                                        <label for="parent_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.parentCategory') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="parent_id" id="parent_id" required>
                                                <option value="0" selected><?= lang('Dashboard.withoutParent') ?></option>
                                                <?php
                                                foreach ($mainCategories as $mainCategory)
                                                {
                                                ?>
                                                    <option value="<?= $mainCategory->id ?>">◼ <?= $mainCategory->title ?> (<?= $mainCategory->type_id ?>)</option>
                                                    <?php
                                                    //To get sub category 1
                                                    $db = db_connect();
                                                    $builder = $db->table('categories_tbl');
                                                    $builder->where('locale', $locale);
                                                    $builder->where('deleted_at', NULL);
                                                    $builder->where('status', 1);
                                                    $builder->where('parent_id', $mainCategory->id);
                                                    //$builder->where('type_id', 3);
                                                    $subCategory1 = $builder->get()->getResult();
                                                    foreach($subCategory1 as $sKey1)
                                                    {
                                                        echo "<option value='$sKey1->id'>&nbsp;&nbsp;&nbsp;&nbsp;◾&nbsp;$sKey1->title ($sKey1->type_id)</option>";

                                                        //To get sub sub category 2
                                                        $builder->where('parent_id', $sKey1->id);
                                                        //$builder->where('type_id', 3);
                                                        $builder->where('deleted_at', NULL);
                                                        $subSubCategory2 = $builder->get()->getResult();
                                                        foreach($subSubCategory2 as $ssKey2)
                                                        {
                                                            echo "<option value='$ssKey2->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◆&nbsp;$ssKey2->title ($ssKey2->type_id)</option>";

                                                            //To get sub sub sub category 3
                                                            $builder->where('parent_id', $ssKey2->id);
                                                            //$builder->where('type_id', 3);
                                                            $builder->where('deleted_at', NULL);
                                                            $subSubCategory3 = $builder->get()->getResult();
                                                            foreach($subSubCategory3 as $sssKey3)
                                                            {
                                                                echo "<option value='$sssKey3->id'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;◈&nbsp;$sssKey3->title ($sssKey3->type_id)</option>";
                                                            }
                                                        }
                                                    }
                                                    $db->close();
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="type_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.type') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2bs4" name="type_id" id="type_id" required>
                                                <?php
                                                foreach ($categoriesTypes as $categoryType)
                                                {
                                                ?>
                                                    <option value="<?= $categoryType->id ?>"><?= $categoryType->title ?> (<?= $categoryType->id ?>)</option>
                                                <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="order" class="col-sm-3 col-form-label"><?= lang('Dashboard.order') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="number" class="form-control" name="order" id="order" placeholder="<?= lang('Dashboard.order') ?>" value="1" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?></label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMinimumImageSizeShouldBe', [ 256, 256 ]) ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 200 ]) ?></small>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="status" checked type="checkbox"> <?= lang('Dashboard.enableThisCategory') ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.createCategory') ?>"><?= lang('Dashboard.createCategory') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.createCategory') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                                <span class="i-text-small text-info"><?= lang('Dashboard.thisDataWillBeCreatedForXLanguageOnly', [$defaultLanguage->title]) ?></span>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>