<?php

use App\Models\Backend\CategoryModel;
$categoryModel = new CategoryModel();

?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.blogManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card card-primary card-outline" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/blog-comments-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body table-striped table-responsive p-0">
                                <br>
                                
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th style="min-width: 158px;"><?= lang('Dashboard.author') ?></th>
                                        <th><?= lang('Dashboard.email') ?></th>
                                        <th><?= lang('Dashboard.comment') ?></th>
                                        <th><?= lang('Dashboard.ip') ?></th>
                                        <th><?= lang('Dashboard.status') ?></th>
                                        <th style="min-width: 128px;"><?= lang('Dashboard.action') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <form class="contact-form" method="POST" id="approvedForm" accept-charset="UTF-8" onsubmit="return false">
                                    <?= csrf_field() ?>
                                    <?php
                                    foreach ($blogComments as $blogComment)
                                    {
                                        $author_ip = $blogComment->author_ip;
                                        if($theRoleID == 9)
                                            $author_ip = 'xx.xx.xx.xx';
                                        ?>
                                        
                                        <tr>
                                            <td class="align-middle"><?= $blogComment->author_name ?></td>
                                            <td class="align-middle"><?= $blogComment->author_email ?></td>
                                            <?php
                                            $comment_count = str_word_count($blogComment->comment);
                                            if ($comment_count > 28)
                                            {
                                            ?>
                                            <td class="align-middle"><?= word_limiter($blogComment->comment, 28); ?> 
                                                [<a href="#" onclick="openModal('<?= $blogComment->comment ?>', <?= $blogComment->id ?>)"><?= lang('Dashboard.readMore') ?></a>]
                                            </td>
                                            <?php
                                            }else{
                                            ?>
                                            <td class="align-middle"><?= $blogComment->comment; ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td class="align-middle"><a target="_blank" href="https://extreme-ip-lookup.com/<?= $author_ip ?>" title="<?= $blogComment->author_agent ?>"><?= $author_ip ?></a></td>
                                            <td class="align-middle">
                                                <div class="form-group">
                                                    <?php
                                                        $session = session();
                                                        $role_id = $session->role_id;
                                                        $approved_checked = $disabled = "";
                                                        if($blogComment->approved == 1)
                                                            $approved_checked = "checked";
                                                        if($role_id == 9 OR $role_id == 19)
                                                            $disabled = "disabled";
                                                    ?>
                                                    <div class="custom-control custom-switch custom-switch-off-light custom-switch-on-success pt-3">
                                                        <input type="hidden" id="post_id_<?= $blogComment->id ?>" value="<?= $blogComment->id ?>">
                                                        <input type="checkbox" class="custom-control-input" id="show_hide_<?= $blogComment->id ?>" <?= $approved_checked ?> <?= $disabled ?> onclick="event.preventDefault(); approvedFunction(this);">
                                                        <input type="hidden" id="approved" value="<?= $blogComment->approved ?>">
                                                        <label class="custom-control-label" for="show_hide_<?= $blogComment->id ?>"></label>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="align-middle" style="width: 128px;">
                                                <a target="_blank" title="<?= lang('Dashboard.viewPost') ?>" href="<?= base_url("post-details/$blogComment->post_id/post") ?>" class="text-primary p-1"><i class="fas fa-eye"></i></a>&nbsp;
                                                <a title="<?= lang('Dashboard.edit') ?>" href="<?= base_url('dashboard/edit-blog-comment/'.$blogComment->id) ?>" class="text-success p-1"><i class="fas fa-edit"></i></a>&nbsp;
                                                <a title="<?= lang('Dashboard.delete') ?>" href="<?= base_url('dashboard/delete-blog-comment/'.$blogComment->id) ?>" class="text-danger p-1" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');"><i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                        }
                                        ?>
                                        </form>
                                    </tbody>
                                </table>
                                
                                <?php
                                if(empty($blogComments)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Modal -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel"><?= lang('Dashboard.comment') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p id="fullComment"></p>
                    <p class="d-none" id="postId"></p>
                </div>
                <div class="modal-footer">
                <a href="#" id="deleteReviewButton" type="button" class="btn btn-sm btn-danger" onclick="return confirm('<?= lang('Dashboard.areYouSureYouWantToDelete') ?>');"><?= lang('Dashboard.deleteComment') ?></a>
                <a href="#" id="editReviewButton" type="button" class="btn btn-sm btn-success"><?= lang('Dashboard.editComment') ?></a>
            </div>
            </div>
        </div>
    </div>

<script>
    function openModal(comment, postId) {
        // Set the full description in the modal
        document.getElementById("fullComment").textContent = comment;
        document.getElementById("postId").textContent = "Post ID: " + postId;
        document.getElementById("editReviewButton").href = "<?= base_url('dashboard/edit-blog-comment/') ?>";
        document.getElementById("editReviewButton").href += postId; // Append reviewId to the Edit button URL
        document.getElementById("deleteReviewButton").href = "<?= base_url('dashboard/delete-blog-comment/') ?>";
        document.getElementById("deleteReviewButton").href += postId; // Append reviewId to the Delete button URL
        // Open the modal
        $('#myModal').modal('show');
    }
</script>


<script>
    function approvedFunction(checkbox) {
        // Get a reference to the spinner element
        const navbarLoadingSpinner = document.getElementById("navbarLoadingSpinner");
        // To show the spinner (remove d-none class):
        navbarLoadingSpinner.classList.remove("d-none");
        // To hide the spinner (add d-none class):
        // spinner.classList.add("d-none");
        checkbox.disabled = true;
        // Get the CSRF token value
        var csrfToken = document.querySelector('input[name="csrf_appdl"]').value;

        var postId = checkbox.previousElementSibling.value;
        var approved = checkbox.nextElementSibling.value;
        var data = new URLSearchParams();
        var xhr = new XMLHttpRequest();
        var url = "<?= base_url('dashboard/perform-approved-unapproved-blog-comments') ?>";

        data.append('post_id', postId);
        data.append('approved', approved);

        xhr.open('POST', url, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
        xhr.send(data);
        xhr.onreadystatechange = function () {
            checkbox.disabled = false;
            navbarLoadingSpinner.classList.add("d-none");
            if (xhr.readyState === 4 && xhr.status === 200) {
                if(xhr.responseText == 3) {
                    // Please fill all required fields
                    //alert(xhr.responseText);
                    toastr.options = {
                        "progressBar": true,
                        "positionClass": "toast-top-center",
                    }
                    toastr["error"](xhr.responseText, "<?= lang('Dashboard.error') ?>");

                }else {
                    //alert(xhr.responseText);
                    // https://codeseven.github.io/toastr/demo.html
                    toastr.options = {
                    "progressBar": true,
                    "positionClass": "toast-top-center",
                    }
                    toastr["success"](xhr.responseText, "");
                }

                var updated_approved = 0;
                if(approved == 1) {
                    updated_approved = 0;
                    checkbox.checked = false;
                }else{
                    updated_approved = 1;
                    checkbox.checked = true;
                }
                
                checkbox.nextElementSibling.value = updated_approved;

            }else if(xhr.status !== 200){
                //alert('<?= lang('Dashboard.errorCode') ?>: '+xhr.status);
                toastr.options = {
                    "progressBar": true,
                    "positionClass": "toast-top-center",
                }
                toastr["error"]("<?= lang('Dashboard.errorCode') ?>: "+xhr.status, "<?= lang('Dashboard.error') ?>");
            }
        };
    }
</script>

<?= $this->endSection() ?>