<?php
$this->session = session();
$locale = $this->session->lang;
use CodeIgniter\I18n\Time;
use App\Libraries\Jdf;
$jdf = new Jdf;
?>
<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.billing') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?= view('App\Views\backend\common\notifications_view'); ?>
                <div class="row">

                    <!-- Widgets -->
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-green"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisDay') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisDay, $currenciesData->decimals, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisMonth') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisMonth, $currenciesData->decimals, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-pink"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDepositedThisYear') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmountThisYear, $currenciesData->decimals, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?></span></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-black"><i class="fas fa-hand-holding-usd"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.theTotalAmountDeposited') ?></span>
                                <span class="info-box-number"><?= number_format($totalCreditAmount, $currenciesData->decimals, '.', ','); ?> <span class="font-weight-normal"><?= $currenciesData->suffix ?></span></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3 col-sm-6 col-12 d-none">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-money-check-alt"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.successfulTransactions') ?></span>
                                <span class="info-box-number"><?= $totalSuccessfulTransactions ?? 0 ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-12 d-none">
                        <div class="info-box">
                            <span class="info-box-icon bg-gray"><i class="fas fa-money-check-alt"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?= lang('Dashboard.unsuccessfulTransactions') ?></span>
                                <span class="info-box-number"><?= $totalUnsuccessfulTransactions ?? 0 ?></span>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="col-md-12">
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= lang('Dashboard.transactionsList') ?></h3>
                                <div class="card-tools">
                                    <form method="get" action="<?= base_url('dashboard/transactions-list') ?>">
                                        <div class="input-group input-group-sm">
                                            <?php
                                            $keyword = "";
                                            if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];
                                            ?>
                                            <input type="text" name="keyword" class="form-control float-right" value="<?= $keyword ?>" required placeholder="<?= lang('Dashboard.search') ?>">

                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="card-body table-responsive p-0">
                                <br>
                                <table class="table table-striped table-hover text-nowrap">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?= lang('Dashboard.user') ?></th>
                                        <th><?= lang('Dashboard.orderId') ?></th>
                                        <th><?= lang('Dashboard.gateway') ?></th>
                                        <th><?= lang('Dashboard.amount') ?> (<?= $currenciesData->suffix ?>)</th>
                                        <th><?= lang('Dashboard.transactionTracking') ?></th>
                                        <th><?= lang('Dashboard.description') ?></th>
                                        <th><?= lang('Dashboard.date') ?></th>
                                        
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($walletTransactions as $walletTransaction)
                                    {
                                        if($walletTransaction->transaction_type == "credit")
                                            $text_color = "text-success";
                                        else if($walletTransaction->transaction_type == "debit")
                                            $text_color = "text-danger";
                                        if($walletTransaction->transaction_tracking == null)
                                            $text_color = "text-gray";
                                        ?>
                                        <tr>
                                            <td class="align-middle"><?= $walletTransaction->id ?></td>
                                            <td>
                                                <a href="<?= $walletTransaction->user_id != 0 ? base_url('dashboard/user-profile/'.$walletTransaction->user_id) : '#' ?>">
                                                    <?= $walletTransaction->first_name . " " . $walletTransaction->last_name ?>
                                                </a>
                                            </td>
                                            <td class="align-middle"><?= $walletTransaction->order_id ?></td>
                                            <td class="align-middle"><?= $walletTransaction->payment_gateway_description ?></td>
                                            <td class="align-middle <?= $text_color ?>"><?= $currenciesData->prefix ?> <?= number_format($walletTransaction->amount, $currenciesData->decimals, '.', ','); ?></td>
                                            <td class="align-middle"><?= $walletTransaction->transaction_tracking ?? "<span class='text-gray small'>" . lang('Dashboard.unsuccessful') . "</span>" ?></td>
                                            <td class="align-middle"><?= $walletTransaction->description ?></td>
                                            <td class="align-middle">
                                                <?php
                                                if($settingsData->calendar_type == "jDate")
                                                {
                                                    $transaction_date = $jdf->jdate('Y/m/d G:i', $walletTransaction->transaction_date, '', $settingsData->timezone);
                                                }else{
                                                    $transaction_date = Time::createFromTimestamp($walletTransaction->transaction_date, $settingsData->timezone, 'en_US');
                                                }
                                                ?>
                                                <?= $transaction_date ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <?php
                                if(empty($walletTransactions)) echo "<br><p class='px-2 text-danger text-center'>".lang('Dashboard.notFound')."<br><br></p>";
                                ?>
                                <br><br>
                                <div class="px-0"><?= $pager->Links() ?></div>
                                
                            </div>
                            <!-- /.card-body -->
                            
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
  
<?= $this->endSection() ?>