<?= $this->extend('App\Views\backend\master_view') ?>

<?= $this->section('page-title') ?>
<?= $pageTitle; ?>
<?= $this->endSection() ?>

<?= $this->section('main-content') ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="i-text-extrabold"><?= $pageTitle; ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb <?= lang('Dashboard.float-sm-xxx') ?>">
                            <li class="breadcrumb-item"><a href="<?= base_url('dashboard/home') ?>"><?= lang('Dashboard.home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="#"><?= lang('Dashboard.advertisingManagement') ?></a></li>
                            <li class="breadcrumb-item active"><?= $pageSubTitle; ?></li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-6">
                        <?= view('App\Views\backend\common\notifications_view'); ?>
                        <!-- Default box -->
                        <div class="card card-outline card-primary" id="myCard">
                            <div class="card-header">
                                <h3 class="card-title"><?= $pageSubTitle; ?></h3>
                                <div class="card-tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-toggle="dropdown">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu <?= lang('Dashboard.dropdown-menu-xxx') ?>" role="menu">
                                            <a href="<?= base_url('dashboard/home') ?>" class="dropdown-item"><?= lang('Dashboard.home') ?></a>
                                            <a href="<?= base_url('dashboard/advertising-list') ?>" class="dropdown-item"><?= lang('Dashboard.advertisingList') ?></a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <form class="form-horizontal" action="<?= base_url('dashboard/perform-create-new-ad') ?>" method="post" enctype="multipart/form-data" onsubmit="buttonLoading()">
                                <?= csrf_field() ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label for="ad_type_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.adType') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="ad_type_id" id="ad_type_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($adTypes as $adType)
                                                {
                                                    ?>
                                                    <option value="<?= $adType->id ?>"><?= $adType->title ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="ad_place_id" class="col-sm-3 col-form-label"><?= lang('Dashboard.adPlace') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="ad_place_id" id="ad_type_id" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <?php
                                                foreach ($adPlaces as $adPlace)
                                                {
                                                    ?>
                                                    <option value="<?= $adPlace->id ?>"><?= $adPlace->title ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="title" class="col-sm-3 col-form-label"><?= lang('Dashboard.title') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="title" id="title" placeholder="<?= lang('Dashboard.title') ?>" value="<?= old('title') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="description" class="col-sm-3 col-form-label"><?= lang('Dashboard.description') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="description" id="description" placeholder="<?= lang('Dashboard.description') ?>" value="<?= old('description') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="url" class="col-sm-3 col-form-label"><?= lang('Dashboard.url') ?> *</label>
                                        <div class="col-sm-9">
                                            <input type="url" class="form-control" name="url" id="url" dir="ltr" placeholder="https://www.Domain.com" value="<?= old('url') ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="how_to_open" class="col-sm-3 col-form-label"><?= lang('Dashboard.howToOpen') ?> *</label>
                                        <div class="col-sm-9">
                                            <select class="form-control" name="how_to_open" id="how_to_open" required>
                                                <option value="" selected disabled><?= lang('Dashboard.pleaseSelect') ?></option>
                                                <option value="0"><?= lang('Dashboard.direct') ?></option>
                                                <option value="1"><?= lang('Dashboard.indirect') ?></option>
                                            </select>
                                            <small class="text-info"><?= lang('Dashboard.inTheDirectMethodItIsNotPossibleToCountTheNumberOfClicks') ?></small>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="ad_agency_title" class="col-sm-3 col-form-label"><?= lang('Dashboard.adAgencyTitle') ?></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="ad_agency_title" id="ad_agency_title" placeholder="<?= lang('Dashboard.adAgencyTitle') ?>" value="<?= old('ad_agency_title') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="ad_agency_url" class="col-sm-3 col-form-label"><?= lang('Dashboard.adAgencyUrl') ?></label>
                                        <div class="col-sm-9">
                                            <input type="url" class="form-control" name="ad_agency_url" id="ad_agency_url" dir="ltr" placeholder="https://www.Domain.com" value="<?= old('ad_agency_url') ?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="image" class="col-sm-3 col-form-label"><?= lang('Dashboard.image') ?></label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="image">
                                                    <label class="custom-file-label" for="image"><?= lang('Dashboard.chooseImage') ?></label>
                                                </div>
                                            </div>
                                            <small class="text-info"><?= lang('Dashboard.onlyImagesWithPngJpgJpegGifExtensionAreSupported') ?></small><br>
                                            <small class="text-info"><?= lang('Dashboard.theMaximumAcceptableSizeIs', [ 600 ]) ?></small>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <label>
                                                <input name="responsive" type="checkbox" checked> <?= lang('Dashboard.beResponsiveImage') ?>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="offset-sm-3 col-sm-9">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="active" type="checkbox" checked> <?= lang('Dashboard.thisAdIsEnabled') ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            <div class="card-footer">
                                <?php
                                $session = session();
                                $role_id = $session->role_id;
                                if($role_id != 9 AND $role_id != 19)
                                {
                                    ?>
                                    <input type="hidden" readonly name="user_id" value="<?= session()->id ?>">
                                    <button type="submit" id="submitButton" class="btn btn-primary <?= lang('Dashboard.float-xxx') ?>" value="<?= lang('Dashboard.createNewAd') ?>"><?= lang('Dashboard.createNewAd') ?></button>
                                    <?php
                                }else{
                                    ?>
                                    <button type="button" disabled class="btn btn-danger <?= lang('Dashboard.float-xxx') ?>"><?= lang('Dashboard.createNewAd') ?></button><small class="text-danger"> <?= lang('Dashboard.thisActionIsNotAllowedInTheDemoVersion') ?></small>
                                    <?php
                                }
                                ?>
                            </div>
                            <!-- /.card-footer-->
                        </form>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?= $this->endSection() ?>