<?php

namespace App\Models\Backend;

use CodeIgniter\Model;

class UserModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'users_tbl';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = [
        "email",
        "password",
	    "first_name",
        "last_name",
        "gender",
        "country",
        "state",
        "city",
        "address",
        "postcode",
        "dark_mode",
        "vat_number",
        "national_number",
        "mobile",
        "phone",
        "image",
        "user_note",
        "admin_note",
        "education",
        "skills",
        "credit",
        "coin",
        "currency_id",
        "language_id",
        "device_type_id",
        "activate_hash",
        "reset_hash",
        "reset_expires",
        "onesignal_player_id",
        "role_id",
        "vip_role_expiry_at",
        "referral_id",
        "is_online",
        "status_id",
        "api_key_access",
        "last_login",
        "last_login_ip",
        "last_login_agent",
        "created_at",
        "updated_at",
        "deleted_at",
    ];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = ["beforeInsert"];
	protected $afterInsert          = [];
	protected $beforeUpdate         = ["beforeUpdate"];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];

    protected function beforeInsert(array $data)
    {
        $data = $this->passwordHash($data);
        return $data;
    }

    protected function beforeUpdate(array $data)
    {
        $data = $this->passwordHash($data);
        return $data;
    }

    protected function passwordHash(array $data)
    {
        if (isset($data['data']['password'])) {
            $data['data']['password'] = password_hash($data['data']['password'], PASSWORD_DEFAULT);
        }

        return $data;
    }
}
