<?php

namespace App\Models\Backend;

use CodeIgniter\Model;

class PageModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'pages_tbl';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = [
	    'title',
	    'title_slug',
	    'page_contents',
	    'image',
	    'breadcrumbs',
	    'description',
	    'keywords',
	    'tags',
	    'tags_slug',
	    'type',
	    'locale',
	    'status',
	    'created_at',
	    'updated_at',
	    'deleted_at',
    ];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
}
