<?php

namespace App\Models\Backend;

use CodeIgniter\Model;

class BlogModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'blog_tbl';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = [
	    'user_id',
	    'structure_id',
	    'category_id',
	    'title',
	    'title_slug',
	    'post_contents',
	    'image',
	    'url',
	    'reference_title',
	    'reference_url',
        'description',
        'keywords',
	    'tags',
	    'tags_slug',
        'locale',
        'allow_comments',
	    'is_advertising',
	    'views',
	    'special',
	    'featured',
	    'status',
	    'created_at',
	    'updated_at',
	    'deleted_at',
    ];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
}
