<?php 

namespace App\Models\Backend;

use CodeIgniter\Model;

class ApiModel extends Model
{
    protected $DBGroup              = 'default';
    protected $table                = 'api_keys_tbl';
    protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'object';
    protected $useSoftDeletes       = true;
	protected $protectFields        = false;
    protected $allowedFields        = [
        'user_id', 
        'api_key', 
        'read', 
        'write', 
        'status',
    ];

    // Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'int';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}