<?php

// override core en language system validation or define your own en language validation message
return [
    // Core Messages
    'noRuleSets'            => 'No rule sets specified in Validation configuration.',
    'ruleNotFound'          => '{0} is not a valid rule.',
    'groupNotFound'         => '{0} is not a validation rules group.',
    'groupNotArray'         => '{0} rule group must be an array.',
    'invalidTemplate'       => '{0} is not a valid Validation template.',

    // Rule Messages
    'alpha'                 => 'The {field} field may only contain alphabetical characters.',
    'alpha_dash'            => 'The {field} field may only contain alphanumeric, underscore, and dash characters.',
    'alpha_numeric'         => 'The {field} field may only contain alphanumeric characters.',
    'alpha_numeric_punct'   => 'The {field} field may contain only alphanumeric characters, spaces, and  ~ ! # $ % & * - _ + = | : . characters.',
    'alpha_numeric_space'   => 'The {field} field may only contain alphanumeric and space characters.',
    'alpha_space'           => 'The {field} field may only contain alphabetical characters and spaces.',
    'decimal'               => 'The {field} field must contain a decimal number.',
    'differs'               => 'The {field} field must differ from the {param} field.',
    'equals'                => 'The {field} field must be exactly: {param}.',
    'exact_length'          => 'The {field} field must be exactly {param} characters in length.',
    'greater_than'          => 'The {field} field must contain a number greater than {param}.',
    'greater_than_equal_to' => 'The {field} field must contain a number greater than or equal to {param}.',
    'hex'                   => 'The {field} field may only contain hexidecimal characters.',
    'in_list'               => 'The {field} field must be one of: {param}.',
    'integer'               => 'The {field} field must contain an integer.',
    'is_natural'            => 'The {field} field must only contain digits.',
    'is_natural_no_zero'    => 'The {field} field must only contain digits and must be greater than zero.',
    'is_not_unique'         => 'The {field} field must contain a previously existing value in the database.',
    'is_unique'             => 'The {field} field is exist in our database.',
    'less_than'             => 'The {field} field must contain a number less than {param}.',
    'less_than_equal_to'    => 'The {field} field must contain a number less than or equal to {param}.',
    'matches'               => 'The {field} field does not match the {param} field.',
    'max_length'            => 'The {field} field cannot exceed {param} characters in length.',
    'min_length'            => 'The {field} field must be at least {param} characters in length.',
    'not_equals'            => 'The {field} field cannot be: {param}.',
    'numeric'               => 'The {field} field must contain only numbers.',
    'regex_match'           => 'The {field} field is not in the correct format.',
    'required'              => 'The {field} is required.',
    'required_with'         => 'The {field} field is required when {param} is present.',
    'required_without'      => 'The {field} field is required when {param} is not present.',
    'string'                => 'The {field} field must be a valid string.',
    'timezone'              => 'The {field} field must be a valid timezone.',
    'valid_base64'          => 'The {field} field must be a valid base64 string.',
    'valid_email'           => 'The {field} field must contain a valid email address.',
    'valid_emails'          => 'The {field} field must contain all valid email addresses.',
    'valid_ip'              => 'The {field} field must contain a valid IP.',
    'valid_url'             => 'The {field} field must contain a valid URL.',
    'valid_date'            => 'The {field} field must contain a valid date.',

    // Credit Cards
    'valid_cc_num'          => '{field} does not appear to be a valid credit card number.',

    // Files
    'uploaded'              => '{field} is not a valid uploaded file.',
    'max_size'              => '{field} is too large of a file.',
    'is_image'              => '{field} is not a valid, uploaded image file.',
    'mime_in'               => '{field} does not have a valid mime type.',
    'ext_in'                => '{field} does not have a valid file extension.',
    'max_dims'              => '{field} is either not an image, or it is too wide or tall.',

    // Custom
    'usernameOrPasswordIncorrect' => 'Username or password is incorrect.',
    'yourEmailAddressIsNotValid' => 'Your email address is not valid.',
    'pleaseEnterYourEmailAddress' => 'Please enter your email address.',
    'pleaseEnterYourPassword' => 'Please enter your password.',
    'pleaseEnterYourOldPassword' => 'Please enter your old password.',
    'pleaseEnterYourNewPassword' => 'Please enter your new password.',
    'pleaseEnterYourConfirmPassword' => 'Please enter your confirmation password',
    'theEmailFieldMustBeAtLeastCharactersInLength' => 'The email field must be at least {0} characters in length.',
    'theEmailFieldCannotExceedCharactersInLength' => 'The email field cannot exceed {0} characters in length.',
    'thePasswordFieldMustBeAtLeastCharactersInLength' => 'The password field must be at least {0} characters in length.',
    'thePasswordFieldCannotExceedCharactersInLength' => 'The password field cannot exceed {0} characters in length.',
    'theFirstNameFieldMustBeAtLeastCharactersInLength' => 'The first name field must be at least {0} characters in length.',
    'theFirstNameFieldCannotExceedCharactersInLength' => 'The first name field cannot exceed {0} characters in length.',
    'theLastNameFieldMustBeAtLeastCharactersInLength' => 'The last name field must be at least {0} characters in length.',
    'theLastNameFieldCannotExceedCharactersInLength' => 'The last name field cannot exceed {0} characters in length.',
    'pleaseEnterYourFirstName' => 'Please enter your first name.',
    'pleaseEnterYourLastName' => 'Please enter your last name.',
    'yourPasswordFieldsDoesNotMatched' => 'Your password fields does not matched.',
    'theTermsOfServicesFieldIsRequired' => 'The terms of services field is required.',
    'theEmailFieldMustContainAUniqueValue' => 'The email field must contain a unique value.',
    'theMobileFieldMustContainAUniqueValue' => 'The mobile field must contain a unique value.',
    'theMobileFieldMustBeAtLeastCharactersInLength' => 'The mobile field must be at least {0} characters in length.',
    'theMobileFieldCannotExceedCharactersInLength' => 'The mobile field cannot exceed {0} characters in length.',
    'pleaseEnterYourMobile' => 'Please enter your mobile.',
    'validateApi' => 'API key is not valid.',
    'pleaseEnterYourComment' => 'Please enter your comment.',
    'theCommentFieldMustBeAtLeastCharactersInLength' => 'The comment field must be at least {0} characters in length.',
    'yourRTLInformationIsNotValid' => 'Your RTL information is not valid.',
    'yourLicenseKeyInformationIsNotValid' => 'Your License Key information is not valid.',
];
