<?php
use Config\Services;

if (! function_exists('sending_push_notification_from_onesignal'))
{
    function sending_push_notification_from_onesignal($onesignal_app_id, $onesignal_rest_api_key, $title, $message, $small_icon = null, $large_icon = null, $big_picture = null, $app_url = null, $web_url = null, $locale = 'en')
    {
        // Define constants for OneSignal App ID and REST API Key
        define("ONESIGNAL_APP_ID", $onesignal_app_id);
        define("ONESIGNAL_REST_KEY", $onesignal_rest_api_key);

        // Prepare the content and headings with locale support
        $content = array(
            $locale => $message
        );

        $headings = array(
            $locale => $title
        );

        // Build the fields array
        $fields = array(
            'app_id' => ONESIGNAL_APP_ID,
            'included_segments' => array('Subscribed Users'),
            'data' => array("foo" => "bar"), // Custom data payload
            'headings' => $headings,
            'contents' => $content,
        );

        // Add optional fields if provided
        if ($small_icon) {
            $fields['small_icon'] = $small_icon;
            $fields['chrome_web_icon'] = $small_icon;
        }
        if ($large_icon) {
            $fields['large_icon'] = $large_icon;
        }
        if ($big_picture) {
            $fields['big_picture'] = $big_picture;
        }
        if ($app_url) {
            $fields['url'] = $app_url;
        }
        if ($web_url) {
            $fields['web_url'] = $web_url;
        }

        // Encode the fields to JSON
        $fields = json_encode($fields);

        // Initialize cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic ' . ONESIGNAL_REST_KEY
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        // Execute the cURL request
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            return array('error' => true, 'message' => "cURL Error: $error_msg");
        }

        // Close cURL
        curl_close($ch);

        // Decode the JSON response
        $response_data = json_decode($response, true);

        // Check for API errors
        if (isset($response_data['errors'])) {
            return array('error' => true, 'message' => "OneSignal API Error: " . implode(", ", $response_data['errors']));
        }

        // Return the response
        return $response_data;
    }


    
    function sending_push_notification_from_onesignal_OLD($onesignal_app_id, $onesignal_rest_api_key, $title, $message, $small_icon, $large_icon, $big_picture, $app_url, $web_url, $locale)
    {
        define("ONESIGNAL_APP_ID", $onesignal_app_id);
        define("ONESIGNAL_REST_KEY", $onesignal_rest_api_key);

        $content = array(
                    "$locale" => $message
        );

        $fields = array(
            'app_id' => ONESIGNAL_APP_ID,
            'included_segments' => array('Subscribed Users'),
            'data' => array("foo" => "bar"),
            'headings'=> array("$locale" => $title),
            'contents' => $content,
            'big_picture' => $big_picture,
            'small_icon' => $small_icon,
            'huawei_small_icon' => $small_icon,
            'chrome_web_icon' => $small_icon,
            'firefox_icon' => $small_icon,
            'app_url' => $app_url,
            'web_url' => $web_url,
        );

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic '.ONESIGNAL_REST_KEY
        ));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }
}