<?php
use Config\Services;

if (! function_exists('imageProcess'))
{
    function imageProcess($imgPath, $imgQuality, $watermark, $imgWidth, $imgHeight, $imgWidthThumbnail, $imgHeightThumbnail, $newName, $newNameWithoutExtension, $isThumbnail = false)
    {
        $image = \Config\Services::image()
            ->withFile($imgPath . $newName)
            ->text($watermark, [
                'color'      => '#000000',
                'opacity'    => 0.6,
                'withShadow' => false,
                'hAlign'     => 'center',
                'vAlign'     => 'middle',
                'fontSize'   => 30,
                'fontPath'   => ''
            ]);

        // Handle thumbnail processing
        if ($isThumbnail) {
            if ($imgHeightThumbnail === 'auto') {
                // Resize with width only, keep aspect ratio
                $image->resize($imgWidthThumbnail, 0, true); // true maintains aspect ratio
            } else {
                // Fit image with specific width and height
                $image->fit($imgWidthThumbnail, $imgHeightThumbnail, 'center');
            }
            $savePath = $imgPath . 'thumb/' . $newName;
        } else {
            if ($imgHeight === 'auto') {
                // Resize with width only, keep aspect ratio
                $image->resize($imgWidth, 0, true); // true maintains aspect ratio
            } else {
                // Fit image with specific width and height
                $image->fit($imgWidth, $imgHeight, 'center');
            }
            $savePath = $imgPath . $newName;
        }

        // Save the processed image
        $image->save($savePath, $imgQuality);

        // Convert to WebP
        $sourceImage = $savePath;
        $destinationImage = $imgPath . ($isThumbnail ? 'thumb/' : '') . $newNameWithoutExtension . '.webp';

        $info = getimagesize($sourceImage);
        switch ($info['mime']) {
            case 'image/jpeg':
                $imageWebp = @imagecreatefromjpeg($sourceImage);
                if (!$imageWebp) {
                    return redirect()->back()->with('error', 'Error creating image from JPEG');
                }
                break;
            case 'image/png':
                $imageWebp = @imagecreatefrompng($sourceImage);
                if (!$imageWebp) {
                    return redirect()->back()->with('error', 'Error creating image from PNG');
                }
                break;
            case 'image/webp':
                // If already a WebP image, no need to convert again
                return;
            default:
                return redirect()->back()->with('error', 'Invalid image format');
        }

        // Save the WebP image
        imagewebp($imageWebp, $destinationImage, $imgQuality);
        imagedestroy($imageWebp);
    }

}