<?php
use App\Models\Backend\SettingModel;
use App\Models\Backend\CaptchaProtectionModel;

if (! function_exists('google_recaptcha_v3_OLD'))
{
    function google_recaptcha_v3_OLD($token, $action)
    {
        $settingModel = new SettingModel();
        $session = session();
        $locale = $session->lang;
        $settings = $settingModel->select('settings_tbl.recaptcha_v3_secret_key, settings_tbl.captcha_protection')->where('settings_tbl.locale', $locale)->first();
        $recaptcha_v3_secret_key = $settings->recaptcha_v3_secret_key;
        $captcha_protection = $settings->captcha_protection;

        if($captcha_protection == 0){
            return true;

        }else{
            // Call curl to POST request
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,"https://www.google.com/recaptcha/api/siteverify");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('secret' => base64_decode(strrev(base64_decode($recaptcha_v3_secret_key))), 'response' => $token)));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);
            $arrResponse = json_decode($response, true);

            if($arrResponse["success"] == '1' && $arrResponse["action"] == $action && $arrResponse["score"] >= 0.5)
            {
                return true;

            }else{
                return false;
            }
        }
    }
}


if (! function_exists('validateRecaptcha'))
{
    function validateRecaptcha($token, $recaptchaType)
    {
        $captchaProtectionModel = new CaptchaProtectionModel();
        $captchaProtection = $captchaProtectionModel->select('captcha_protection_tbl.*')->where('captcha_protection_tbl.id', 1)->first();
        
        if ($recaptchaType === '2') { // reCAPTCHA v2
            $secretKey = $captchaProtection->recaptcha_v2_secret_key;
            $secretKey = base64_decode(strrev(base64_decode($secretKey)));

        } elseif ($recaptchaType === '3') { // reCAPTCHA v3
            $secretKey = $captchaProtection->recaptcha_v3_secret_key;
            $secretKey = base64_decode(strrev(base64_decode($secretKey)));
        }

        // If no recaptcha is used, return true
        if (is_null($secretKey) || empty($token)) {
            return true;
        }

        $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$token}");
        $result = json_decode($response, true);

        if ($recaptchaType === '2') { // reCAPTCHA v2
            return isset($result['success']) && $result['success'] === true;

        } elseif ($recaptchaType === '3') { // reCAPTCHA v3
            return isset($result['success']) && $result['success'] === true && $result['score'] >= 0.5;
        }

        return true;
    }
}