<?php

if (! function_exists('crud_insert'))
{
    /*
        Usage: crud_insert($db, $data, 'table_name_tbl');
    */
    function crud_insert($db, $data, $table)
    {
        // Insert data
        $builder = $db->table($table);
        $builder->insert($data);
    }
}

//========================================================//
if (! function_exists('crud_update'))
{
    /*
        Usage for 1 where: 
            $where = ['order_id' => $sizpayTransaction->order_id];
            crud_update($db, $data, 'table_name_tbl', $where);
            
        Useage for more than 1 where: 
            $where = [
                'order_id' => $sizpayTransaction->order_id,
                'user_id' => $currentUser->id
            ];

            $db = db_connect();
            crud_update($db, $data, 'table_name_tbl', $where);
            $db->close();
    */
    function crud_update($db, $data, $table, $where)
    {
        // Update data with where condition
        $builder = $db->table($table);
        
        if (is_array($where)) {
            foreach ($where as $key => $value) {
                $builder->where($key, $value); // Add multiple where conditions
            }
        } else {
            $builder->where($where); // Single condition if not an array
        }

        $builder->update($data);

        // Returns the number of rows that were updated
        return $db->affectedRows();
    }
}

//========================================================//
if (! function_exists('crud_delete'))
{
    /*
    Usage:
        Delete with Single Condition
        $db = db_connect();
        $where = ['order_id' => $sizpayTransaction->order_id];
        crud_delete($db, 'orders_tbl', $where);
        $db->close();

        Delete with Multiple Conditions
        $db = db_connect();
        $where = [
            'order_id' => $sizpayTransaction->order_id,
            'user_id' => $currentUser->id
        ];
        crud_delete($db, 'orders_tbl', $where);
        $db->close();
    */
    function crud_delete($db, $table, $where)
    {
        // Delete record with one or more where conditions
        $builder = $db->table($table);

        if (is_array($where)) {
            foreach ($where as $key => $value) {
                $builder->where($key, $value);
            }
        } else {
            $builder->where($where);
        }

        $builder->delete();
    }
}


//========================================================//
if (! function_exists('crud_select'))
{
    /*
    Usage:
        Retrieve Multiple Rows (default behavior):
        $db = db_connect();
        $where = ['status' => 'pending'];
        $data = crud_select($db, 'orders_tbl', $where);
        $db->close();

        Retrieve One Row:
        $db = db_connect();
        $where = ['order_id' => $sizpayTransaction->order_id];
        $data = crud_select($db, 'orders_tbl', $where, null, null, true); // Set $singleRow = true
        $db->close();

        Retrieve Multiple Rows with Limit and Order By:
        $db = db_connect();
        $where = ['status' => 'pending'];
        $data = crud_select($db, 'orders_tbl', $where, 10, 'created_at DESC');
        $db->close();

        Retrieve a Single Row with Conditions:
        $db = db_connect();
        $where = [
            'order_id' => $sizpayTransaction->order_id,
            'user_id' => $currentUser->id
        ];
        $data = crud_select($db, 'orders_tbl', $where, null, null, true); // Single row
        $db->close();


    */
    function crud_select($db, $table, $where = null, $limit = null, $orderBy = null, $singleRow = false)
    {
        // Select records with optional where conditions, limit, and order by
        $builder = $db->table($table);

        if (!empty($where)) {
            if (is_array($where)) {
                foreach ($where as $key => $value) {
                    $builder->where($key, $value);
                }
            } else {
                $builder->where($where);
            }
        }

        if (!empty($orderBy)) {
            $builder->orderBy($orderBy);
        }

        if (!empty($limit)) {
            $builder->limit($limit);
        }

        // Determine whether to return multiple rows or a single row
        if ($singleRow) {
            $result = $builder->get()->getFirstRow(); // Return only one row
        } else {
            $result = $builder->get()->getResult();   // Return multiple rows
        }

        return $result;
    }
}