<?php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\Backend\HomeConfigurationModel;
use App\Models\Backend\SettingModel;
use App\Models\Backend\BlogModel;
use App\Models\Backend\BlogCommentModel;
use App\Models\Backend\CategoryModel;
use App\Models\Backend\AdModel;
use Modules\Addons\Contents\Models\Backend\ContentModel;
use Modules\Addons\Contents\Models\Backend\ContentReviewModel;
use Modules\Addons\Contents\Models\Backend\ContentReportModel;
use App\Models\Backend\TestimonialsModel;

class HomeController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
        if(isset($this->session->lang)) {
            service('language')->setLocale($this->session->lang);
            $this->locale = $this->session->lang;
        }else{
            $this->locale = service('request')->getLocale();
            $this->session->set('lang', $this->locale);
            service('language')->setLocale($this->session->lang);
        }

        $this->settingModel = new SettingModel();
        $theme = $this->settingModel->select('settings_tbl.template_name')->where('settings_tbl.locale', $this->locale)->first();
        $this->template_name = $theme->template_name;

        $this->contentModel = new ContentModel();
        $this->contentReviewModel = new ContentReviewModel();
        $this->contentReportModel = new ContentReportModel();
        $this->blogModel = new BlogModel();
        $this->categoryModel = new CategoryModel();
        $this->blogCommentModel = new BlogCommentModel();
        $this->adModel = new AdModel();
        $this->testimonialsModel = new TestimonialsModel();
	}


    //===========================================================//
    public function home()
    {
        return redirect()->route('login');
    }


    //===========================================================//
    public function run()
    {
        // Open app from phone (if installed before), or download app to install on the phone
        $settings = $this->settingModel->select('settings_tbl.app_name, settings_tbl.android_app_dl_url, settings_tbl.app_description, settings_tbl.seo_meta_description, settings_tbl.seo_meta_author, settings_tbl.seo_meta_keywords')->where('settings_tbl.locale', $this->locale)->first();
        return redirect()->to($settings->android_app_dl_url, null, '');
    }


    //===========================================================//
    public function unsubscribe_newsletter()
    {
        $settings = $this->settingModel->select('settings_tbl.app_name, settings_tbl.app_description, settings_tbl.seo_meta_description, settings_tbl.seo_meta_author, settings_tbl.seo_meta_keywords')->where('settings_tbl.locale', $this->locale)->first();

        $data['pageTitle'] = lang('Frontend.unsubscribeNewsletter');
        $data['pageSubTitle'] = lang('Frontend.unsubscribeNewsletter');
        $data['seoDescription'] = $settings->seo_meta_description;
        $data['seoKeywords'] = $settings->seo_meta_keywords;
        $data['seoAuthor'] = $settings->seo_meta_author;
        $data['ogDescription'] = $settings->seo_meta_description;
        $data['ogImage'] = base_url("backend/assets/uploads/admins/images/light_logo_website_".$this->session->lang.".png");
        $data['heroTitle'] = lang('Frontend.unsubscribeNewsletter');
        $data['heroSubTitle'] = lang('Frontend.unsubscribeNewsletter');
        $data['heroImage'] = "hero8.png";
        $data['templateName'] = $this->template_name;

        echo view('\App\Views\frontend\\'.$this->template_name.'\pages\unsubscribe_newsletter_view', $data);
    }


	//===========================================================//
	public function perform_unsubscribe_newsletter()
	{
		// Validate request
		$rules = [
			'email' 	=> 'required|valid_email',
		];

		if (! $this->validate($rules)) {
			return redirect()->to(base_url('unsubscribe-newsletter'))->withInput()->with('sweet_alert_errors', $this->validator->getErrors());
		}

		$email = $this->request->getPost('email');

		$db = db_connect();
		$builder = $db->table('newsletter_tbl');
		$builder->where('newsletter_tbl.email', $email);
		$newsletter = $builder->get()->getResult();

		if(!empty($newsletter))
		{
			$builder->where('newsletter_tbl.email', $email);
			$builder->delete();
			$db->close();
			return redirect()->to(base_url('unsubscribe-newsletter'))->with('sweet_alert_success', lang('Frontend.yourEmailHasBeenSuccessfullyRemovedFromTheNewsletter'));

		}else{
			$db->close();
			return redirect()->to(base_url('unsubscribe-newsletter'))->with('sweet_alert_error', lang('Frontend.yourEmailNotExistInOurNewsletter'));
		}
	}


    //===========================================================//
    public function error_404()
    {
        $settings = $this->settingModel->select('settings_tbl.app_name, settings_tbl.app_description, settings_tbl.seo_meta_description, settings_tbl.seo_meta_author, settings_tbl.seo_meta_keywords')->where('settings_tbl.locale', $this->locale)->first();

        $data['pageTitle'] = lang('Frontend.theRequestedPageCouldNotBeFound');
        $data['pageSubTitle'] = lang('Frontend.theRequestedPageCouldNotBeFound');
        $data['seoDescription'] = $settings->seo_meta_description;
        $data['seoKeywords'] = $settings->seo_meta_keywords;
        $data['seoAuthor'] = $settings->seo_meta_author;
        $data['ogDescription'] = $settings->seo_meta_description;
        $data['ogImage'] = base_url("backend/assets/uploads/admins/images/light_logo_website_".$this->session->lang.".png");
        $data['heroTitle'] = lang('Frontend.theRequestedPageCouldNotBeFound');
        $data['heroSubTitle'] = lang('Frontend.theRequestedPageCouldNotBeFoundDesc');
        $data['heroImage'] = "hero8.png";
        $data['templateName'] = $this->template_name;

        echo view('\App\Views\frontend\\'.$this->template_name.'\pages\error_404_view', $data);
    }
	
	
    //===========================================================//
    public function ad_clicked()
    {
        $ad_id = service('uri')->getSegment(2);
        // Check ad exist
        $ad = $this->adModel->where('id', $ad_id)->first();
        if(is_null($ad))
        {
            die("404: Not Found !");
            //return redirect()->back()->with('error', lang('Dashboard.notFound'));

        }else{
            $url = $ad->url;
            $this->adModel->query("UPDATE ad_banners_tbl SET clicked = clicked + 1 WHERE id = '$ad_id'");
            return redirect()->to($url,null,'refresh');
        }
    }

}
