<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = ['number', 'url', 'form', 'date', 'time', 'text'];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    // protected $session;

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Cache The Pages
        /*$n = 3600;
        $this->cachePage($n);*/
		
		// Default Language
        $session = session();
        if(isset($session->lang)) {
            service('language')->setLocale($session->lang);
        }else{
            // Storing session values
            $locale = service('request')->getLocale();
            $session->set('lang',$locale);
            service('language')->setLocale($session->lang);
        }

        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = \Config\Services::session();
		
		// Pass data to all views
        $db = db_connect();
        
        if(isset($session->id)) {
            $data['walletData'] = $db->query("SELECT * FROM wallet_tbl WHERE user_id = '$session->id'")->getRow();
            if(isset($data['walletData']->id)) {
                $data['currenciesData'] = $db->query("SELECT * FROM currencies_tbl WHERE currencies_tbl.id = ".$data['walletData']->currency_id)->getRow();

            }else{
                $data['currenciesData'] = $db->query("SELECT * FROM currencies_tbl WHERE currencies_tbl.default = 1")->getRow();

                helper('crud');
                $data = [
                    'user_id'       => $session->id,
                    'currency_id'   => $data['currenciesData']->id,
                    'title'         => lang('Dashboard.defaultWallet'),
                    'credit'        => 0,
                    'status'        => 1,
                ];
                crud_insert($db, $data, 'wallet_tbl');
            }
            
        } else {
            $data['currenciesData'] = $db->query("SELECT * FROM currencies_tbl WHERE currencies_tbl.default = 1")->getRow();
        }
           
        $data['theLocale'] = $session->lang;
        $data['theRoleID'] = $session->role_id;
        $data['userId'] = $session->id;
        $data['userFirstName'] = $session->first_name;
        $data['userLastName'] = $session->last_name;
        $data['userEmail'] = $session->email;
        $data['languagesData'] = $db->query("SELECT * FROM languages_tbl WHERE status = 1")->getResult();
        $data['defaultLanguage'] = $db->query("SELECT * FROM languages_tbl WHERE locale = '$session->lang'")->getRow();
        $data['settingsData'] = $db->query("SELECT * FROM settings_tbl WHERE locale = '$session->lang'")->getRow();
        $data['captchaProtection'] = $db->query("SELECT * FROM captcha_protection_tbl WHERE id = 1")->getRow();
        $data['homeConfigurationData'] = $db->query("SELECT * FROM home_configuration_tbl WHERE locale = '$session->lang'")->getRow();
        $db->close();
        return view('\App\Views\backend\common\header_view', $data);
        return view('\App\Views\auth\common\header_view', $data);
    }
}
