<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\WalletTransactionModel;
use CodeIgniter\HTTP\ResponseInterface;

class WalletTransactionController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
        $this->walletTransactionModel = new WalletTransactionModel();
    }


    //===========================================================//
	public function transactions_list()
	{
        $keyword = "";
        if(isset($_GET['keyword'])) $keyword = $_GET['keyword'];

        if(empty($keyword))
        {
            $data = [
                'walletTransactions' => $this->walletTransactionModel
                    ->select('wallet_transactions_tbl.*, 
                        COALESCE(users_tbl.first_name, "' . lang('Dashboard.notRegistered') . '") AS first_name, 
                        COALESCE(users_tbl.last_name, "") AS last_name, 
                        COALESCE(payment_gateways_tbl.description, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_description,
                        COALESCE(payment_gateways_tbl.title, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_title')
                    ->join('users_tbl', 'users_tbl.id = wallet_transactions_tbl.user_id AND wallet_transactions_tbl.user_id != 0', 'left')
                    ->join('payment_gateways_tbl', 'payment_gateways_tbl.id = wallet_transactions_tbl.payment_gateway_id AND wallet_transactions_tbl.payment_gateway_id != 0', 'left')
                    ->orderBy('wallet_transactions_tbl.id', 'DESC')
                    ->paginate(30),
                'pager' => $this->walletTransactionModel->pager
            ];

        }else{
            $data = [
                'walletTransactions' => $this->walletTransactionModel
                    ->select('wallet_transactions_tbl.*, 
                        COALESCE(users_tbl.first_name, "' . lang('Dashboard.notRegistered') . '") AS first_name, 
                        COALESCE(users_tbl.last_name, "") AS last_name, 
                        COALESCE(payment_gateways_tbl.description, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_description,
                        COALESCE(payment_gateways_tbl.title, "' . lang('Dashboard.noGateway') . '") AS payment_gateway_title')
                    ->join('users_tbl', 'users_tbl.id = wallet_transactions_tbl.user_id AND wallet_transactions_tbl.user_id != 0', 'left')
                    ->join('payment_gateways_tbl', 'payment_gateways_tbl.id = wallet_transactions_tbl.payment_gateway_id AND wallet_transactions_tbl.payment_gateway_id != 0', 'left')
                    ->orderBy('wallet_transactions_tbl.id', 'DESC')
                    ->like('wallet_transactions_tbl.order_id',$keyword)
                    ->orLike('wallet_transactions_tbl.transaction_type',$keyword)
                    ->orLike('wallet_transactions_tbl.transaction_tracking',$keyword)
                    ->orLike('wallet_transactions_tbl.description',$keyword)
                    ->orLike('users_tbl.first_name',$keyword)
                    ->orLike('users_tbl.last_name',$keyword)
                    ->orLike('payment_gateways_tbl.title',$keyword)
                    ->orLike('payment_gateways_tbl.description',$keyword)
                    ->paginate(30),
                'pager' => $this->walletTransactionModel->pager
            ];
        }

        $startOfDay = strtotime('today midnight');
        $data['totalCreditAmountThisDay'] = $this->walletTransactionModel
            ->selectSum('amount')
            ->where('transaction_type', 'credit')
            ->where('transaction_tracking IS NOT NULL')
            ->where('transaction_date >=', $startOfDay)
            ->get()
            ->getRow()
            ->amount;

        $startOfMonth = strtotime('first day of this month midnight');
        $data['totalCreditAmountThisMonth'] = $this->walletTransactionModel
            ->selectSum('amount')
            ->where('transaction_type', 'credit')
            ->where('transaction_tracking IS NOT NULL')
            ->where('transaction_date >=', $startOfMonth)
            ->get()
            ->getRow()
            ->amount;

        

        $startOfYear = strtotime('first day of January midnight');
        $data['totalCreditAmountThisYear'] = $this->walletTransactionModel
            ->selectSum('amount')
            ->where('transaction_type', 'credit')
            ->where('transaction_tracking IS NOT NULL')
            ->where('transaction_date >=', $startOfYear)
            ->get()
            ->getRow()
            ->amount;

        $data['totalCreditAmount'] = $this->walletTransactionModel->selectSum('amount')->where('transaction_type', 'credit')->where('transaction_tracking IS NOT NULL')->get()->getRow()->amount;

        $data['totalSuccessfulTransactions'] = $this->walletTransactionModel->where('transaction_tracking IS NOT NULL')->countAllResults();
        $data['totalUnsuccessfulTransactions'] = $this->walletTransactionModel->where('transaction_tracking IS NULL')->countAllResults();

        $data['pageTitle'] = lang('Dashboard.transactionsList');
        $data['pageSubTitle'] = lang('Dashboard.transactionsList');
        return view('\App\Views\backend\billing\transactions_list_view', $data);
    }

}
