<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;

class SystemController extends BaseController
{
    public function __construct()
    {
        $this->session = session();
    }

    //===========================================================//
    public function php_info()
    {
        $data['pageTitle'] = lang('Dashboard.phpInfo');
        $data['pageSubTitle'] = lang('Dashboard.phpInfo');
        return view('\App\Views\backend\system\php_info_view', $data);
    }


    //===========================================================//
    public function system_cleanup()
    {
        $data['pageTitle'] = lang('Dashboard.systemCleanup');
        $data['pageSubTitle'] = lang('Dashboard.systemCleanup');
        return view('\App\Views\backend\system\system_cleanup_view', $data);
    }


    //===========================================================//
    public function perform_session_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');

        // Delete Old Session Files Here
        $dir = WRITEPATH.'session/';
        foreach (glob($dir."ci*") as $file) {
            if (filemtime($file) < time() - $cleanup) { // 259200 = 3 Days / 86400 = 1 Day
                unlink($file);
            }
        }

        return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.sessionFilesCleanupSuccessfully'));
    }


    //===========================================================//
    public function perform_logs_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');

        // Delete Old Log Files Here
        $dir = WRITEPATH.'logs/';
        foreach (glob($dir."log*") as $file) {
            if (filemtime($file) < time() - $cleanup) { // 259200 = 3 Days / 86400 = 1 Day
                unlink($file);
            }
        }

        return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.logFilesCleanupSuccessfully'));
    }


    //===========================================================//
    public function perform_debugbar_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');

        // Delete Old Log Files Here
        $dir = WRITEPATH.'debugbar/';
        foreach (glob($dir."debugbar*") as $file) {
            if (filemtime($file) < time() - $cleanup) { // 259200 = 3 Days / 86400 = 1 Day
                unlink($file);
            }
        }

        return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.debugBarFilesCleanupSuccessfully'));
    }


    //===========================================================//
    public function perform_cache_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');

        // Delete Old Log Files Here
        $dir = WRITEPATH.'cache/';
        foreach (glob($dir."cache*") as $file) {
            if (filemtime($file) < time() - $cleanup) { // 259200 = 3 Days / 86400 = 1 Day
                unlink($file);
            }
        }

        return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.cacheFilesCleanupSuccessfully'));
    }


    //===========================================================//
    public function perform_users_activity_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');
        $time_cleanup = time() - $cleanup;

        // Delete Users Activity
        $db = db_connect();
        $query = $db->query("DELETE FROM activities_tbl WHERE time < '$time_cleanup';");
        $db->close();

        if($query)
            return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.usersActivityCleanupSuccessfully'));
        else
            return redirect()->to(base_url('dashboard/system-cleanup'))->with('error', lang('Dashboard.errorOperationFailed'));
    }


    //===========================================================//
    public function perform_downloaded_files_cleanup()
    {
        $rules = [
            'cleanup'       => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/system-cleanup"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $cleanup = $this->request->getVar('cleanup');
        $time_cleanup = time() - $cleanup;

        // Delete Downloaded Files
        $db = db_connect();
        $query = $db->query("DELETE FROM contents_downloaded_tbl WHERE created_at < '$time_cleanup';");
        $db->close();

        if($query)
            return redirect()->to(base_url('dashboard/system-cleanup'))->with('success', lang('Dashboard.downloadedFilesCleanupSuccessfully'));
        else
            return redirect()->to(base_url('dashboard/system-cleanup'))->with('error', lang('Dashboard.errorOperationFailed'));
    }


    //===========================================================//
    public function database_status()
    {
        $db = db_connect();
        $tables = $db->listTables();
        $db->close();

        $data['tables'] = $tables;
        $data['pageTitle'] = lang('Dashboard.databaseStatus');
        $data['pageSubTitle'] = lang('Dashboard.databaseStatus');
        return view('\App\Views\backend\system\database_status_view', $data);
    }


    //===========================================================//
    public function perform_optimise_tables()
    {
        $db = db_connect();
        $tables = $db->listTables();
        foreach ($tables as $table) {
            $query = $db->query("OPTIMIZE TABLE $table");
            //echo "OPTIMIZE TABLE $table<br>";
        }
        $db->close();

        return redirect()->to(base_url('dashboard/database-status'))->with('success', lang('Dashboard.databaseTablesWereSuccessfullyOptimised'));
    }


    //===========================================================//
    public function license_information()
    {
        $data['pageTitle'] = lang('Dashboard.licenseInformation');
        $data['pageSubTitle'] = lang('Dashboard.licenseInformation');
        return view('\App\Views\backend\system\license_information_view', $data);
    }
}
