<?php

namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\Backend\HomeConfigurationModel;

class HomeConfigurationController extends BaseController
{
    public function __construct()
    {
        $this->homeConfigurationModel = new HomeConfigurationModel();
        $this->session = session();
    }


    //===========================================================//
	public function home_configuration()
	{
        $locale = $this->session->lang;
        $data['homeConfiguration'] = $this->homeConfigurationModel->where('locale', $locale)->first();
        if(is_null($data['homeConfiguration']))
            return redirect()->back()->with('error', lang('Dashboard.notFound'));

        $data['pageTitle'] = lang('Dashboard.homeConfiguration');
        $data['pageSubTitle'] = lang('Dashboard.homeConfiguration');
        return view('\App\Views\backend\settings\home_configuration_view', $data);
	}


    //--------------------------------------------------------------------//
    public function perform_edit_home_configuration()
    {
        $locale = $this->session->lang;

        $rules = [
            'home_page'	                => 'required',
            'show_recent_posts'	        => 'permit_empty',
            'show_random_posts'	        => 'permit_empty',
            'show_special_posts'	    => 'permit_empty',
            'show_featured_posts'	    => 'permit_empty',
            'show_pricing_plan'	        => 'permit_empty',
            'show_faq'	                => 'permit_empty',
            'show_special_apps'	        => 'permit_empty',
            'show_special_games'	    => 'permit_empty',
            'show_featured_apps'	    => 'permit_empty',
            'show_featured_games'	    => 'permit_empty',
            'show_latest_apps'	        => 'permit_empty',
            'show_latest_games'	        => 'permit_empty',
            'show_newsletter'	        => 'permit_empty',
            'show_statistics'	        => 'permit_empty',
            'show_testimonials'	        => 'permit_empty',
        ];

        if (!$this->validate($rules)) {
            return redirect()->to(base_url("dashboard/home-configuration"))
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        $show_recent_posts = $show_random_posts = $show_special_posts = $show_featured_posts = $show_pricing_plan = $show_faq = $show_special_apps = $show_special_games = $show_featured_apps = $show_featured_games = 
        $show_newsletter = $show_statistics = $show_latest_apps = $show_latest_games = $show_testimonials = 0;
        if($this->request->getVar('show_recent_posts') == "on") $show_recent_posts = 1;
        if($this->request->getVar('show_random_posts') == "on") $show_random_posts = 1;
        if($this->request->getVar('show_special_posts') == "on") $show_special_posts = 1;
        if($this->request->getVar('show_featured_posts') == "on") $show_featured_posts = 1;
        if($this->request->getVar('show_pricing_plan') == "on") $show_pricing_plan = 1;
        if($this->request->getVar('show_faq') == "on") $show_faq = 1;
        if($this->request->getVar('show_special_apps') == "on") $show_special_apps = 1;
        if($this->request->getVar('show_special_games') == "on") $show_special_games = 1;
        if($this->request->getVar('show_featured_apps') == "on") $show_featured_apps = 1;
        if($this->request->getVar('show_featured_games') == "on") $show_featured_games = 1;
        if($this->request->getVar('show_latest_apps') == "on") $show_latest_apps = 1;
        if($this->request->getVar('show_latest_games') == "on") $show_latest_games = 1;
        if($this->request->getVar('show_newsletter') == "on") $show_newsletter = 1;
        if($this->request->getVar('show_statistics') == "on") $show_statistics = 1;
        if($this->request->getVar('show_testimonials') == "on") $show_testimonials = 1;

        $data = [
            'home_page'  	            => $this->request->getVar('home_page'),
            'show_recent_posts' 	    => $show_recent_posts,
            'show_random_posts'     	=> $show_random_posts,
            'show_special_posts'     	=> $show_special_posts,
            'show_featured_posts'     	=> $show_featured_posts,
            'show_pricing_plan'     	=> $show_pricing_plan,
            'show_faq'     	            => $show_faq,
            'show_special_apps'     	=> $show_special_apps,
            'show_special_games'     	=> $show_special_games,
            'show_featured_apps'     	=> $show_featured_apps,
            'show_featured_games'     	=> $show_featured_games,
            'show_latest_apps'     	    => $show_latest_apps,
            'show_latest_games'     	=> $show_latest_games,
            'show_newsletter'     	    => $show_newsletter,
            'show_statistics'     	    => $show_statistics,
            'show_testimonials'     	=> $show_testimonials,
        ];

        if (! $this->homeConfigurationModel->update($locale, $data)) {
            return redirect()->back()->withInput()->with('errors', $this->homeConfigurationModel->errors());
        }

        return redirect()->to(base_url('dashboard/home-configuration'))->with('success', lang('Dashboard.dataSuccessfullyUpdated'));
    }
}